/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.ReadWriteMonitor;
import org.eclipse.dltk.internal.core.mixin.MixinIndexRequest;

public class MixinSourceModuleRequest
extends MixinIndexRequest {
    protected final ISourceModule module;
    protected final IDLTKLanguageToolkit toolkit;

    public MixinSourceModuleRequest(ISourceModule module, IDLTKLanguageToolkit toolkit) {
        this.module = module;
        this.toolkit = toolkit;
    }

    protected String getName() {
        return this.module.getElementName();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void run() throws CoreException, IOException {
        IScriptProject project = this.module.getScriptProject();
        Index index = this.getProjectMixinIndex(project);
        ReadWriteMonitor imon = index.monitor;
        imon.enterWrite();
        try {
            this.indexSourceModule(index, this.toolkit, this.module, project.getPath());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            imon.exitWrite();
            throw throwable;
        }
        {
            Object var4_6 = null;
            imon.exitWrite();
            return;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MixinSourceModuleRequest other = (MixinSourceModuleRequest)obj;
        return !(this.module == null ? other.module != null : !this.module.equals(other.module));
    }
}

