/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.dltk.utils.CharArraySequence;

public abstract class TextUtils {
    private TextUtils() {
        throw new AssertionError((Object)"Cannot instantiate utility class");
    }

    public static String Pattern_quote(String s) {
        int slashEIndex = s.indexOf("\\E");
        if (slashEIndex == -1) {
            return "\\Q" + s + "\\E";
        }
        StringBuffer sb = new StringBuffer(s.length() * 2);
        sb.append("\\Q");
        slashEIndex = 0;
        int current = 0;
        while ((slashEIndex = s.indexOf("\\E", current)) != -1) {
            sb.append(s.substring(current, slashEIndex));
            current = slashEIndex + 2;
            sb.append("\\E\\\\E\\Q");
        }
        sb.append(s.substring(current, s.length()));
        sb.append("\\E");
        return sb.toString();
    }

    public static String[] splitLines(CharSequence content) {
        if (content == null) {
            return null;
        }
        LineSplitter splitter = new LineSplitter(content);
        return splitter.split();
    }

    public static String[] splitLines(CharSequence content, int limit) {
        if (content == null) {
            return null;
        }
        LineSplitter splitter = new LineSplitter(content);
        return splitter.split(limit);
    }

    public static int countLines(CharSequence content) {
        return new LineSplitter(content).countLines();
    }

    public static CharSequence selectHeadLines(CharSequence content, int lines) {
        return new LineSplitter(content).selectHeadLines(lines);
    }

    public static ISourceLineTracker createLineTracker(char[] content) {
        LineTrackerBuilder builder = new LineTrackerBuilder(new CharArraySequence(content));
        return builder.buildLineTracker();
    }

    public static ISourceLineTracker createLineTracker(String content) {
        LineTrackerBuilder builder = new LineTrackerBuilder(content);
        return builder.buildLineTracker();
    }

    public static String replace(String text, char c, String s) {
        int previous = 0;
        int current = text.indexOf(c, previous);
        if (current == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer();
        while (current > -1) {
            buffer.append(text.substring(previous, current));
            buffer.append(s);
            previous = current + 1;
            current = text.indexOf(c, previous);
        }
        buffer.append(text.substring(previous));
        return buffer.toString();
    }

    public static String escapeHTML(String content) {
        content = TextUtils.replace(content, '&', "&amp;");
        content = TextUtils.replace(content, '\"', "&quot;");
        content = TextUtils.replace(content, '<', "&lt;");
        return TextUtils.replace(content, '>', "&gt;");
    }

    public static String join(Collection collection, String separator) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        Iterator iterator = collection.iterator();
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first != null ? first.toString() : "";
        }
        StringBuffer buf = new StringBuffer(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            Object obj;
            if (separator != null) {
                buf.append(separator);
            }
            if ((obj = iterator.next()) == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String join(Collection collection, char separator) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return "";
        }
        Iterator iterator = collection.iterator();
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return first != null ? first.toString() : "";
        }
        StringBuffer buf = new StringBuffer(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String join(String[] lines, char separator) {
        StringBuffer sb = new StringBuffer(256);
        int i = 0;
        while (i < lines.length) {
            if (i != 0) {
                sb.append(separator);
            }
            sb.append(lines[i]);
            ++i;
        }
        return sb.toString();
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return CharOperation.NO_STRINGS;
        }
        int i = str.indexOf(separatorChar);
        if (i == -1) {
            return new String[]{str};
        }
        ArrayList<String> list = new ArrayList<String>();
        int start = 0;
        boolean match = i != 0;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    private static class DefaultSourceLineTracker
    implements ISourceLineTracker {
        private final int contentLength;
        private final int[] lineOffsets;
        private final String[] delimiters;

        private DefaultSourceLineTracker(int contentLength, int[] lineOffsets, String[] delimiters) {
            this.contentLength = contentLength;
            this.lineOffsets = lineOffsets;
            this.delimiters = delimiters;
        }

        public int getLength() {
            return this.contentLength;
        }

        public String getLineDelimiter(int line) {
            if (line < this.delimiters.length) {
                return this.delimiters[line];
            }
            return null;
        }

        public ISourceRange getLineInformation(int line) {
            if (line < this.lineOffsets.length) {
                int length = line == this.lineOffsets.length - 1 ? this.contentLength - this.lineOffsets[line] : this.lineOffsets[line + 1] - this.lineOffsets[line];
                if (this.delimiters[line] != null) {
                    length -= this.delimiters[line].length();
                }
                return new SourceRange(this.lineOffsets[line], length);
            }
            return NULL_RANGE;
        }

        public ISourceRange getLineInformationOfOffset(int offset) {
            if (offset < this.contentLength) {
                return this.getLineInformation(this.findLine(offset));
            }
            return NULL_RANGE;
        }

        public int getLineLength(int line) {
            if (line < this.lineOffsets.length) {
                if (line == this.lineOffsets.length - 1) {
                    return this.contentLength - this.lineOffsets[line];
                }
                return this.lineOffsets[line + 1] - this.lineOffsets[line];
            }
            return 0;
        }

        public int getLineNumberOfOffset(int offset) {
            if (offset < this.contentLength) {
                return this.findLine(offset);
            }
            return 0;
        }

        private int findLine(int offset) {
            int i = this.lineOffsets.length;
            while (--i >= 0) {
                if (offset < this.lineOffsets[i]) continue;
                return i;
            }
            return 0;
        }

        public int getLineOffset(int line) {
            return line < this.lineOffsets.length ? this.lineOffsets[line] : 0;
        }

        public int getNumberOfLines() {
            return this.lineOffsets.length;
        }
    }

    private static class LineSplitter {
        private final CharSequence content;
        protected final int contentEnd;
        protected int contentPos;
        protected String lastLineDelimiter = null;
        private static final String DELIMITER_WINDOWS = "\r\n";
        private static final String DELIMITER_UNIX = "\n";
        private static final String DELIMITER_MAC = "\r";

        public LineSplitter(CharSequence content) {
            this.content = content;
            this.contentEnd = content.length();
        }

        public CharSequence selectHeadLines(int lines) {
            this.contentPos = 0;
            while (lines > 0 && this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                --lines;
            }
            return this.content.subSequence(0, this.contentPos);
        }

        public String[] split() {
            ArrayList<String> result = new ArrayList<String>();
            this.contentPos = 0;
            while (this.contentPos < this.contentEnd) {
                int begin = this.contentPos;
                int end = this.findEndOfLine();
                result.add(this.content.subSequence(begin, end).toString());
            }
            return result.toArray(new String[result.size()]);
        }

        public String[] split(int lines) {
            ArrayList<String> result = new ArrayList<String>(lines);
            this.contentPos = 0;
            while (lines > 0 && this.contentPos < this.contentEnd) {
                int begin = this.contentPos;
                int end = this.findEndOfLine();
                result.add(this.content.subSequence(begin, end).toString());
                --lines;
            }
            return result.toArray(new String[result.size()]);
        }

        public int countLines() {
            this.contentPos = 0;
            int count = 0;
            while (this.contentPos < this.contentEnd) {
                this.findEndOfLine();
                ++count;
            }
            return count;
        }

        protected final int findEndOfLine() {
            while (this.contentPos < this.contentEnd) {
                if (this.content.charAt(this.contentPos) == '\r') {
                    int endLine = this.contentPos++;
                    if (this.contentPos < this.contentEnd && this.content.charAt(this.contentPos) == '\n') {
                        ++this.contentPos;
                        this.lastLineDelimiter = DELIMITER_WINDOWS;
                    } else {
                        this.lastLineDelimiter = DELIMITER_MAC;
                    }
                    return endLine;
                }
                if (this.content.charAt(this.contentPos) == '\n') {
                    int endLine = this.contentPos++;
                    this.lastLineDelimiter = DELIMITER_UNIX;
                    return endLine;
                }
                ++this.contentPos;
            }
            this.lastLineDelimiter = null;
            return this.contentPos;
        }
    }

    private static class LineTrackerBuilder
    extends LineSplitter {
        public LineTrackerBuilder(CharSequence content) {
            super(content);
        }

        public ISourceLineTracker buildLineTracker() {
            ArrayList<String> delimiters = new ArrayList<String>();
            int[] lineOffsets = new int[256];
            int lineCount = 0;
            this.contentPos = 0;
            while (this.contentPos < this.contentEnd) {
                int begin = this.contentPos;
                this.findEndOfLine();
                if (lineCount >= lineOffsets.length) {
                    int[] newLineOffsets = new int[lineOffsets.length * 2 + 1];
                    System.arraycopy(lineOffsets, 0, newLineOffsets, 0, lineOffsets.length);
                    lineOffsets = newLineOffsets;
                }
                lineOffsets[lineCount++] = begin;
                delimiters.add(this.lastLineDelimiter);
            }
            if (lineCount < lineOffsets.length) {
                int[] newLineOffsets = new int[lineCount];
                System.arraycopy(lineOffsets, 0, newLineOffsets, 0, lineCount);
                lineOffsets = newLineOffsets;
            }
            return new DefaultSourceLineTracker(this.contentEnd, lineOffsets, delimiters.toArray(new String[delimiters.size()]));
        }
    }
}

