/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.actions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleArtifact;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.ILaunchableAdapter;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ModuleArtifactDelegate;
import org.eclipse.wst.server.ui.internal.EclipseUtil;
import org.eclipse.wst.server.ui.internal.LaunchClientJob;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.actions.OptionsMessageDialog;
import org.eclipse.wst.server.ui.internal.viewers.ModuleArtifactComposite;
import org.eclipse.wst.server.ui.internal.wizard.RunOnServerWizard;

public class RunOnServerActionDelegate
implements IWorkbenchWindowActionDelegate {
    protected static final String[] launchModes = new String[]{"run", "debug", "profile"};
    protected Object selection;
    protected IWorkbenchWindow window;
    protected static Object globalSelection;
    protected static Map<String, Boolean> globalLaunchMode;
    protected String launchMode = "run";
    protected boolean tasksAndClientShown;
    protected ILaunchableAdapter launchableAdapter;
    protected IClient client;
    protected static final char[] INVALID_CHARS;

    static {
        char[] cArray = new char[11];
        cArray[0] = 92;
        cArray[1] = 58;
        cArray[2] = 42;
        cArray[3] = 63;
        cArray[4] = 34;
        cArray[5] = 60;
        cArray[6] = 62;
        cArray[7] = 124;
        cArray[9] = 64;
        cArray[10] = 38;
        INVALID_CHARS = cArray;
    }

    public void dispose() {
        this.window = null;
    }

    public void init(IWorkbenchWindow newWindow) {
        this.window = newWindow;
    }

    public IServer getServer(IModule module, IModuleArtifact moduleArtifact, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerCore.getDefaultServer((IModule)module);
        if (server != null && !ServerUIPlugin.isCompatibleWithLaunchMode(server, this.launchMode)) {
            server = null;
        }
        if (server != null && !ServerUtil.containsModule((IServer)server, (IModule)module, (IProgressMonitor)monitor)) {
            IServerWorkingCopy wc = server.createWorkingCopy();
            try {
                ServerUtil.modifyModules((IServerWorkingCopy)wc, (IModule[])new IModule[]{module}, (IModule[])new IModule[0], (IProgressMonitor)monitor);
                wc.save(false, monitor);
            }
            catch (CoreException ce) {
                Trace.trace((int)3, (String)"Could not add module to server", (Throwable)ce);
                server = null;
            }
        }
        Shell shell = this.window != null ? this.window.getShell() : ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
        if (server == null) {
            Trace.trace((int)5, (String)"Launching wizard");
            RunOnServerWizard wizard = new RunOnServerWizard(module, this.launchMode, moduleArtifact);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            if (dialog.open() == 1) {
                if (monitor != null) {
                    monitor.setCanceled(true);
                }
                return null;
            }
            try {
                Job.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", null);
            }
            catch (Exception e) {
                Trace.trace((int)2, (String)"Error waiting for job", (Throwable)e);
            }
            server = wizard.getServer();
            boolean preferred = wizard.isPreferredServer();
            this.tasksAndClientShown = true;
            this.client = wizard.getSelectedClient();
            this.launchableAdapter = wizard.getLaunchableAdapter();
            if (server != null && preferred) {
                try {
                    ServerCore.setDefaultServer((IModule)module, (IServer)server, (IProgressMonitor)monitor);
                }
                catch (CoreException ce) {
                    String message = Messages.errorCouldNotSavePreference;
                    ErrorDialog.openError((Shell)shell, (String)Messages.errorDialogTitle, (String)message, (IStatus)ce.getStatus());
                }
            }
        }
        try {
            Job.getJobManager().join((Object)"org.eclipse.wst.server.ui.family", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Trace.trace((int)2, (String)"Error waiting for job", (Throwable)e);
        }
        return server;
    }

    protected void run() {
        IModuleArtifact moduleArtifact;
        IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)this.selection);
        if (moduleArtifacts == null || moduleArtifacts.length == 0 || moduleArtifacts[0] == null) {
            EclipseUtil.openError(Messages.errorNoArtifact);
            Trace.trace((int)5, (String)"No module artifact found");
            return;
        }
        Shell shell2 = null;
        if (this.window != null) {
            shell2 = this.window.getShell();
        } else {
            try {
                shell2 = ServerUIPlugin.getInstance().getWorkbench().getActiveWorkbenchWindow().getShell();
            }
            catch (Exception exception) {}
            if (shell2 == null) {
                shell2 = Display.getDefault().getActiveShell();
            }
        }
        final Shell shell = shell2;
        final IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (Shell.class.equals((Object)adapter)) {
                    return shell;
                }
                return null;
            }
        };
        if (moduleArtifacts.length > 1) {
            ModuleArtifactComposite artifactComposite = new ModuleArtifactComposite(shell, moduleArtifacts, this.launchMode);
            if (artifactComposite.open() == 1) {
                return;
            }
            moduleArtifact = artifactComposite.getSelection();
        } else {
            moduleArtifact = moduleArtifacts[0];
        }
        if (moduleArtifact.getModule() == null) {
            EclipseUtil.openError(Messages.errorNoModules);
            Trace.trace((int)5, (String)"Module artifact not contained in a module");
            return;
        }
        final IModule module = moduleArtifact.getModule();
        IServer[] servers = ServerCore.getServers();
        boolean found = false;
        if (servers != null) {
            int size = servers.length;
            int i = 0;
            while (i < size && !found) {
                if (ServerUIPlugin.isCompatibleWithLaunchMode(servers[i], this.launchMode)) {
                    try {
                        IModule[] parents = servers[i].getRootModules(module, null);
                        if (parents != null && parents.length > 0) {
                            found = true;
                        }
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        if (!found) {
            IServerType[] serverTypes = ServerCore.getServerTypes();
            if (serverTypes != null) {
                int size = serverTypes.length;
                int i = 0;
                while (i < size && !found) {
                    IServerType type = serverTypes[i];
                    IModuleType[] moduleTypes = type.getRuntimeType().getModuleTypes();
                    if (type.supportsLaunchMode(this.launchMode) && ServerUtil.isSupportedModule((IModuleType[])moduleTypes, (IModuleType)module.getModuleType())) {
                        found = true;
                    }
                    ++i;
                }
            }
            if (!found) {
                EclipseUtil.openError(Messages.errorNoServer);
                Trace.trace((int)5, (String)"No server for start mode");
                return;
            }
        }
        if (!ServerUIPlugin.saveEditors()) {
            return;
        }
        this.tasksAndClientShown = false;
        IServer server2 = null;
        this.client = null;
        this.launchableAdapter = null;
        try {
            IFolder folder;
            NullProgressMonitor monitor = new NullProgressMonitor();
            server2 = this.getServer(module, moduleArtifact, (IProgressMonitor)monitor);
            if (monitor.isCanceled()) {
                return;
            }
            if (server2 != null && (folder = server2.getServerConfiguration()) != null && folder.getProject() != null && !folder.getProject().isOpen()) {
                folder.getProject().open((IProgressMonitor)monitor);
            }
        }
        catch (CoreException ce) {
            EclipseUtil.openError(shell, ce.getLocalizedMessage());
            return;
        }
        final IServer server = server2;
        Trace.trace((int)5, (String)("Server: " + server));
        if (server == null) {
            EclipseUtil.openError(Messages.errorNoServer);
            Trace.trace((int)3, (String)"No server found");
            return;
        }
        if (!ServerUIPlugin.promptIfDirty(shell, server)) {
            return;
        }
        if (!this.tasksAndClientShown) {
            RunOnServerWizard wizard = new RunOnServerWizard(server, this.launchMode, moduleArtifact);
            if (wizard.shouldAppear()) {
                WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
                if (dialog.open() == 1) {
                    return;
                }
            } else {
                wizard.performFinish();
            }
            this.client = wizard.getSelectedClient();
            this.launchableAdapter = wizard.getLaunchableAdapter();
        }
        if (this.client == null) {
            this.client = new IClient(){

                public String getDescription() {
                    return Messages.clientDefaultDescription;
                }

                public String getId() {
                    return "org.eclipse.wst.server.ui.client.default";
                }

                public String getName() {
                    return Messages.clientDefaultName;
                }

                public IStatus launch(IServer server3, Object launchable2, String launchMode3, ILaunch launch) {
                    return Status.OK_STATUS;
                }

                public boolean supports(IServer server3, Object launchable2, String launchMode3) {
                    return true;
                }
            };
        }
        if (moduleArtifact instanceof ModuleArtifactDelegate) {
            boolean canLoad = false;
            try {
                Class<?> c = Class.forName(moduleArtifact.getClass().getName());
                if (c.newInstance() != null) {
                    canLoad = true;
                }
            }
            catch (Throwable throwable) {
                Trace.trace((int)2, (String)"Could not load module artifact delegate class, switching to backup");
            }
            if (canLoad) {
                try {
                    NullProgressMonitor monitor = new NullProgressMonitor();
                    ILaunchConfiguration config = this.getLaunchConfiguration(server, (ModuleArtifactDelegate)moduleArtifact, this.launchableAdapter, this.client, (IProgressMonitor)monitor);
                    config.launch(this.launchMode, (IProgressMonitor)monitor);
                }
                catch (CoreException ce) {
                    Trace.trace((int)3, (String)"Could not launch Run on Server", (Throwable)ce);
                }
                return;
            }
        }
        Thread thread = new Thread("Run on Server"){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                Trace.trace((int)5, (String)"Ready to launch");
                IModule[] modules = new IModule[]{module};
                int state = server.getServerState();
                if (state == 1) {
                    LaunchClientJob clientJob = new LaunchClientJob(server, modules, RunOnServerActionDelegate.this.launchMode, moduleArtifact, RunOnServerActionDelegate.this.launchableAdapter, RunOnServerActionDelegate.this.client);
                    clientJob.schedule();
                    return;
                } else if (state == 2) {
                    int result;
                    boolean restart = false;
                    String mode = server.getMode();
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    boolean disabledBreakpoints = false;
                    if (server.getServerRestartState()) {
                        result = RunOnServerActionDelegate.openRestartDialog(shell);
                        if (result == 0) {
                            RunOnServerActionDelegate.this.launchMode = mode;
                            restart = true;
                        } else if (result == 9) {
                            return;
                        }
                    }
                    if (!restart) {
                        int result2;
                        boolean breakpointsOption;
                        if (!"run".equals(mode) && "run".equals(RunOnServerActionDelegate.this.launchMode)) {
                            breakpointsOption = false;
                            if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                                breakpointsOption = true;
                            }
                            if ((result2 = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizRunOnServerTitle, Messages.dialogModeWarningRun, breakpointsOption)) == 0) {
                                restart = true;
                            } else if (result2 == 1) {
                                breakpointManager.setEnabled(false);
                                disabledBreakpoints = true;
                                RunOnServerActionDelegate.this.launchMode = mode;
                            } else {
                                if (result2 != 2) return;
                                RunOnServerActionDelegate.this.launchMode = mode;
                            }
                        } else if (!"debug".equals(mode) && "debug".equals(RunOnServerActionDelegate.this.launchMode)) {
                            result = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizDebugOnServerTitle, Messages.dialogModeWarningDebug, false);
                            if (result == 0) {
                                restart = true;
                            } else {
                                if (result != 1) return;
                                RunOnServerActionDelegate.this.launchMode = mode;
                            }
                        } else if (!"profile".equals(mode) && "profile".equals(RunOnServerActionDelegate.this.launchMode)) {
                            breakpointsOption = false;
                            if (breakpointManager.isEnabled() && "debug".equals(mode)) {
                                breakpointsOption = true;
                            }
                            if ((result2 = RunOnServerActionDelegate.openOptionsDialog(shell, Messages.wizProfileOnServerTitle, Messages.dialogModeWarningProfile, breakpointsOption)) == 0) {
                                restart = true;
                            } else if (result2 == 1) {
                                breakpointManager.setEnabled(false);
                                disabledBreakpoints = true;
                                RunOnServerActionDelegate.this.launchMode = mode;
                            } else {
                                if (result2 != 2) return;
                                RunOnServerActionDelegate.this.launchMode = mode;
                            }
                        }
                        if ("debug".equals(RunOnServerActionDelegate.this.launchMode) && !breakpointManager.isEnabled() && !disabledBreakpoints) {
                            result = RunOnServerActionDelegate.openBreakpointDialog(shell);
                            if (result == 0) {
                                breakpointManager.setEnabled(true);
                            } else if (result != 1) {
                                return;
                            }
                        }
                    }
                    final LaunchClientJob clientJob = new LaunchClientJob(server, modules, RunOnServerActionDelegate.this.launchMode, moduleArtifact, RunOnServerActionDelegate.this.launchableAdapter, RunOnServerActionDelegate.this.client);
                    if (restart) {
                        final IServer server3 = server;
                        server.restart(RunOnServerActionDelegate.this.launchMode, new IServer.IOperationListener(){

                            public void done(IStatus result) {
                                server3.publish(1, null, info, new IServer.IOperationListener(){

                                    public void done(IStatus result2) {
                                        if (result2.isOK()) {
                                            clientJob.schedule();
                                        }
                                    }
                                });
                            }
                        });
                        return;
                    } else {
                        server.publish(1, null, info, new IServer.IOperationListener(){

                            public void done(IStatus result) {
                                if (result.isOK()) {
                                    clientJob.schedule();
                                }
                            }
                        });
                    }
                    return;
                } else {
                    if (state == 3) return;
                    final LaunchClientJob clientJob = new LaunchClientJob(server, modules, RunOnServerActionDelegate.this.launchMode, moduleArtifact, RunOnServerActionDelegate.this.launchableAdapter, RunOnServerActionDelegate.this.client);
                    server.start(RunOnServerActionDelegate.this.launchMode, new IServer.IOperationListener(){

                        public void done(IStatus result) {
                            if (result.isOK()) {
                                clientJob.schedule();
                            }
                        }
                    });
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    protected void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy config, IServer server, ModuleArtifactDelegate moduleArtifact, ILaunchableAdapter launchableAdapter, IClient client) {
        String launchName = NLS.bind((String)Messages.runOnServerLaunchConfigName, (Object)moduleArtifact.getName());
        if (!(launchName = this.getValidLaunchConfigurationName(launchName)).equals(config.getName())) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(launchName);
            config.rename(launchName);
        }
        config.setAttribute("server-id", server.getId());
        config.setAttribute("module-artifact", moduleArtifact.serialize());
        config.setAttribute("module-artifact-class", moduleArtifact.getClass().getName());
        if (launchableAdapter != null) {
            config.setAttribute("launchable-adapter-id", launchableAdapter.getId());
        } else {
            config.setAttribute("launchable-adapter-id", null);
        }
        config.setAttribute("client-id", client.getId());
        try {
            IProject project = moduleArtifact.getModule().getProject();
            config.setMappedResources(new IResource[]{project});
        }
        catch (Exception e) {
            Trace.trace((int)2, (String)"Could not associate launch with a project", (Throwable)e);
        }
    }

    protected ILaunchConfiguration getLaunchConfiguration(IServer server, ModuleArtifactDelegate moduleArtifact, ILaunchableAdapter launchableAdapter2, IClient client2, IProgressMonitor monitor) throws CoreException {
        String serverId = server.getId();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = launchManager.getLaunchConfigurationType("org.eclipse.wst.server.ui.launchConfigurationType");
        ILaunchConfiguration[] launchConfigs = null;
        try {
            launchConfigs = launchManager.getLaunchConfigurations(launchConfigType);
        }
        catch (CoreException coreException) {}
        if (launchConfigs != null) {
            int size = launchConfigs.length;
            int i = 0;
            while (i < size) {
                List list = launchConfigs[i].getAttribute("org.eclipse.debug.ui.favoriteGroups", null);
                if (list == null || list.isEmpty()) {
                    try {
                        String serverId2 = launchConfigs[i].getAttribute("server-id", null);
                        if (serverId.equals(serverId2)) {
                            ILaunchConfigurationWorkingCopy wc = launchConfigs[i].getWorkingCopy();
                            this.setupLaunchConfiguration(wc, server, moduleArtifact, launchableAdapter2, client2);
                            if (wc.isDirty()) {
                                try {
                                    return wc.doSave();
                                }
                                catch (CoreException ce) {
                                    Trace.trace((int)3, (String)"Error configuring launch", (Throwable)ce);
                                }
                            }
                            return launchConfigs[i];
                        }
                    }
                    catch (CoreException e) {
                        Trace.trace((int)3, (String)"Error configuring launch", (Throwable)e);
                    }
                }
                ++i;
            }
        }
        String launchName = NLS.bind((String)Messages.runOnServerLaunchConfigName, (Object)moduleArtifact.getName());
        launchName = this.getValidLaunchConfigurationName(launchName);
        launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(launchName);
        ILaunchConfigurationWorkingCopy wc = launchConfigType.newInstance(null, launchName);
        wc.setAttribute("server-id", serverId);
        this.setupLaunchConfiguration(wc, server, moduleArtifact, launchableAdapter2, client2);
        return wc.doSave();
    }

    protected String getValidLaunchConfigurationName(String s) {
        if (s == null || s.length() == 0) {
            return "1";
        }
        int size = INVALID_CHARS.length;
        int i = 0;
        while (i < size) {
            s = s.replace(INVALID_CHARS[i], '_');
            ++i;
        }
        return s;
    }

    protected static int openOptionsDialog(final Shell shell, final String title, final String message, final boolean breakpointsOption) {
        int current;
        if (breakpointsOption) {
            current = ServerUIPlugin.getPreferences().getLaunchMode2();
            if (current == 2) {
                return 0;
            }
            if (current == 3) {
                return 1;
            }
            if (current == 1) {
                return 2;
            }
        } else {
            current = ServerUIPlugin.getPreferences().getLaunchMode();
            if (current == 2) {
                return 0;
            }
            if (current == 1) {
                return 1;
            }
        }
        final int[] i = new int[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                OptionsMessageDialog dialog = null;
                String[] items = null;
                items = breakpointsOption ? new String[]{Messages.dialogModeWarningRestart, Messages.dialogModeWarningBreakpoints, Messages.dialogModeWarningContinue} : new String[]{Messages.dialogModeWarningRestart, Messages.dialogModeWarningContinue};
                dialog = new OptionsMessageDialog(shell, title, message, items);
                i[0] = dialog.open();
                if (dialog.isRemember()) {
                    if (breakpointsOption) {
                        if (i[0] == 0) {
                            ServerUIPlugin.getPreferences().setLaunchMode2(2);
                        } else if (i[0] == 1) {
                            ServerUIPlugin.getPreferences().setLaunchMode2(3);
                        } else if (i[0] == 2) {
                            ServerUIPlugin.getPreferences().setLaunchMode2(1);
                        }
                    } else if (i[0] == 0) {
                        ServerUIPlugin.getPreferences().setLaunchMode(2);
                    } else if (i[0] == 1) {
                        ServerUIPlugin.getPreferences().setLaunchMode(1);
                    }
                }
            }
        });
        return i[0];
    }

    protected static int openBreakpointDialog(final Shell shell) {
        int current = ServerUIPlugin.getPreferences().getEnableBreakpoints();
        if (current == 1) {
            return 0;
        }
        if (current == 2) {
            return 1;
        }
        final int[] i = new int[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                OptionsMessageDialog dialog = new OptionsMessageDialog(shell, Messages.wizDebugOnServerTitle, Messages.dialogBreakpoints, new String[]{Messages.dialogBreakpointsReenable, Messages.dialogModeWarningContinue});
                i[0] = dialog.open();
                if (dialog.isRemember()) {
                    if (i[0] == 0) {
                        ServerUIPlugin.getPreferences().setEnableBreakpoints(1);
                    } else if (i[0] == 1) {
                        ServerUIPlugin.getPreferences().setEnableBreakpoints(2);
                    }
                }
            }
        });
        return i[0];
    }

    protected static int openRestartDialog(final Shell shell) {
        int current = ServerUIPlugin.getPreferences().getRestart();
        if (current == 1) {
            return 0;
        }
        if (current == 2) {
            return 1;
        }
        final int[] i = new int[1];
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                OptionsMessageDialog dialog = new OptionsMessageDialog(shell, Messages.defaultDialogTitle, Messages.dialogRestart, new String[]{Messages.dialogRestartRestart, Messages.dialogRestartContinue});
                i[0] = dialog.open();
                if (dialog.isRemember()) {
                    if (i[0] == 0) {
                        ServerUIPlugin.getPreferences().setRestart(1);
                    } else if (i[0] == 1) {
                        ServerUIPlugin.getPreferences().setRestart(2);
                    }
                }
            }
        });
        return i[0];
    }

    public void run(IAction action) {
        Trace.trace((int)5, (String)"Running on Server...");
        try {
            this.run();
        }
        catch (Exception e) {
            Trace.trace((int)3, (String)"Run on Server Error", (Throwable)e);
        }
    }

    protected boolean isEnabled() {
        try {
            Boolean b = globalLaunchMode.get(this.getLaunchMode());
            return b;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getLaunchMode() {
        return this.launchMode;
    }

    public void setLaunchMode(String launchMode) {
        this.launchMode = launchMode;
    }

    public void selectionChanged(IAction action, ISelection sel) {
        Trace.trace((int)5, (String)"> selectionChanged");
        this.selection = null;
        long time = System.currentTimeMillis();
        if (sel == null || sel.isEmpty() || !(sel instanceof IStructuredSelection)) {
            action.setEnabled(false);
            globalSelection = null;
            return;
        }
        IStructuredSelection select = (IStructuredSelection)sel;
        Iterator iterator = select.iterator();
        if (iterator.hasNext()) {
            this.selection = iterator.next();
        }
        if (iterator.hasNext()) {
            action.setEnabled(false);
            this.selection = null;
            globalSelection = null;
            return;
        }
        if (this.selection != globalSelection) {
            Trace.trace((int)5, (String)("Selection: " + this.selection));
            if (this.selection != null) {
                Trace.trace((int)5, (String)("Selection type: " + this.selection.getClass().getName()));
            }
            globalSelection = this.selection;
            globalLaunchMode = new HashMap<String, Boolean>();
            if (!ServerPlugin.hasModuleArtifact((Object)globalSelection)) {
                action.setEnabled(false);
                return;
            }
            Trace.trace((int)5, (String)"checking for module artifact");
            IModuleArtifact[] moduleArtifacts = ServerPlugin.getModuleArtifacts((Object)globalSelection);
            IModuleArtifact moduleArtifact = null;
            if (moduleArtifacts != null && moduleArtifacts.length > 0) {
                moduleArtifact = moduleArtifacts[0];
            }
            IModule module = null;
            if (moduleArtifact != null) {
                module = moduleArtifact.getModule();
            }
            Trace.trace((int)5, (String)("moduleArtifact= " + moduleArtifact + ", module= " + module));
            if (module != null) {
                this.findGlobalLaunchModes(module);
            } else {
                globalLaunchMode.put("run", new Boolean(true));
                globalLaunchMode.put("debug", new Boolean(true));
                globalLaunchMode.put("profile", new Boolean(true));
            }
        }
        action.setEnabled(this.isEnabled());
        Trace.trace((int)5, (String)("< selectionChanged " + (System.currentTimeMillis() - time)));
    }

    protected void findGlobalLaunchModes(IModule module) {
        IServerType[] serverTypes = ServerCore.getServerTypes();
        if (serverTypes != null) {
            int size = serverTypes.length;
            int i = 0;
            while (i < size) {
                IServerType type = serverTypes[i];
                if (this.isValidServerType(type, module)) {
                    int b = 0;
                    while (b < launchModes.length) {
                        if (type.supportsLaunchMode(launchModes[b])) {
                            globalLaunchMode.put(launchModes[b], new Boolean(true));
                        }
                        b = (byte)(b + 1);
                    }
                }
                ++i;
            }
        }
    }

    protected boolean isValidServerType(IServerType type, IModule module) {
        try {
            IRuntimeType runtimeType = type.getRuntimeType();
            ServerUtil.isSupportedModule((IModuleType[])runtimeType.getModuleTypes(), (IModuleType)module.getModuleType());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

