/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui.preferences;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.debug.ui.preferences.ScriptDebugPreferencesMessages;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public abstract class DebuggingEngineConfigOptionsBlock
extends AbstractOptionsBlock {
    private EnvironmentPathBlock logFilePaths;

    public DebuggingEngineConfigOptionsBlock(IStatusChangeListener context, IProject project, PreferenceKey[] allKeys, IWorkbenchPreferenceContainer container) {
        super(context, project, allKeys, container);
    }

    protected Control createOptionsBlock(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)4);
        this.createEngineBlock(composite);
        this.createLoggingBlock(composite);
        this.createOtherBlock(composite);
        return composite;
    }

    protected abstract void createEngineBlock(Composite var1);

    protected void createLoggingBlock(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)ScriptDebugPreferencesMessages.LoggingGroupLabel, (int)3, (int)1, (int)1808);
        this.logFilePaths = new EnvironmentPathBlock();
        this.logFilePaths.createControl((Composite)group, this.getRelevantEnvironments());
        Map paths = EnvironmentPathUtils.decodePaths((String)this.getString(this.getLogFileNamePreferenceKey()));
        this.logFilePaths.setPaths(paths);
    }

    protected IEnvironment[] getRelevantEnvironments() {
        if (this.fProject != null) {
            return new IEnvironment[]{EnvironmentManager.getEnvironment((IProject)this.fProject)};
        }
        return EnvironmentManager.getEnvironments();
    }

    protected boolean processChanges(IWorkbenchPreferenceContainer container) {
        if (this.logFilePaths != null) {
            String loggingPaths = EnvironmentPathUtils.encodePaths((Map)this.logFilePaths.getPaths());
            this.setString(this.getLogFileNamePreferenceKey(), loggingPaths);
        }
        return super.processChanges(container);
    }

    protected void createOtherBlock(Composite parent) {
    }

    protected PreferenceKey getEnableLoggingPreferenceKey() {
        return null;
    }

    protected abstract PreferenceKey getLogFileNamePreferenceKey();

    protected PreferenceKey getLogFilePathPreferenceKey() {
        return null;
    }
}

