/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.core;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.builder.ISourceLineTracker;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IExecutionEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.dltk.validators.core.AbstractExternalValidator;
import org.eclipse.dltk.validators.core.CommandLine;
import org.eclipse.dltk.validators.core.IResourceValidator;
import org.eclipse.dltk.validators.core.ISourceModuleValidator;
import org.eclipse.dltk.validators.core.IValidatorOutput;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalChecker;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalCheckerProblem;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalCheckerWildcardManager;
import org.eclipse.dltk.validators.internal.externalchecker.core.Messages;
import org.eclipse.dltk.validators.internal.externalchecker.core.Rule;
import org.eclipse.dltk.validators.internal.externalchecker.core.WildcardMatcher;

public class ExternalCheckerWorker
extends AbstractExternalValidator
implements ISourceModuleValidator,
IResourceValidator {
    public static final String PROBLEM_ID = "org.eclipse.dltk.validators.externalchecker.externalcheckerproblem";
    private final IEnvironment environment;
    private final IExecutionEnvironment execEnvironment;
    private final List rules = new ArrayList();
    private final String arguments;
    private final String[] extensions;
    private final String command;
    static /* synthetic */ Class class$0;

    public ExternalCheckerWorker(IEnvironment environment, ExternalChecker externalChecker) {
        this.environment = environment;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.environment.IExecutionEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.execEnvironment = (IExecutionEnvironment)environment.getAdapter((Class)clazz);
        int i = 0;
        while (i < externalChecker.getNRules()) {
            this.rules.add(externalChecker.getRule(i));
            ++i;
        }
        this.arguments = externalChecker.getArguments();
        this.extensions = ExternalCheckerWorker.prepareExtensions(externalChecker.getExtensions());
        this.command = ExternalCheckerWorker.prepareCommand(externalChecker.getCommand(), environment);
    }

    private static String prepareCommand(Map commands, IEnvironment environment) {
        String result = (String)commands.get(environment);
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    private static String[] prepareExtensions(String extensions) {
        String[] parts = extensions.split("[\\s;]+");
        int i = 0;
        while (i < parts.length) {
            if ("*".equals(parts[i])) {
                return CharOperation.NO_STRINGS;
            }
            ++i;
        }
        return parts;
    }

    protected String getMarkerType() {
        return PROBLEM_ID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus validate(ISourceModule[] modules, IValidatorOutput console, IProgressMonitor monitor) {
        block6: {
            IStatus iStatus;
            block5: {
                monitor.beginTask(Messages.ExternalChecker_checkingWithExternalExecutable, modules.length);
                try {
                    int i = 0;
                    while (i < modules.length) {
                        if (monitor.isCanceled()) {
                            iStatus = Status.CANCEL_STATUS;
                            Object var5_6 = null;
                            break block5;
                        }
                        this.validate(modules[i], console);
                        monitor.worked(1);
                        ++i;
                    }
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    monitor.done();
                    throw throwable;
                }
            }
            monitor.done();
            return iStatus;
        }
        Object var5_8 = null;
        monitor.done();
        return Status.OK_STATUS;
    }

    public IStatus validate(IResource[] resources, IValidatorOutput output, IProgressMonitor monitor) {
        return Status.CANCEL_STATUS;
    }

    protected boolean checkExtension(ISourceModule module) {
        if (this.extensions.length == 0) {
            return true;
        }
        String elementName = module.getElementName();
        int i = 0;
        while (i < this.extensions.length) {
            if (elementName.endsWith(this.extensions[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private IStatus validate(ISourceModule module, IValidatorOutput console) {
        block11: {
            if (!this.checkExtension(module)) {
                return Status.OK_STATUS;
            }
            IResource resource = module.getResource();
            if (resource == null) {
                return new Status(4, "org.eclipse.dltk.validators.externalchecker", Messages.ExternalChecker_sourceModuleResourceIsNull);
            }
            this.clean(resource);
            if (this.command == null || this.command.trim().length() == 0) {
                return Status.CANCEL_STATUS;
            }
            CommandLine cmdLine = new CommandLine(this.arguments);
            cmdLine.replaceSequence('f', this.getResourcePath(resource));
            cmdLine.add(0, this.command);
            BufferedReader input = null;
            Process process = null;
            try {
                try {
                    process = this.execEnvironment.exec(cmdLine.toArray(), null, null);
                }
                catch (Throwable e) {
                    if (DLTKCore.DEBUG) {
                        System.out.println(e.toString());
                    }
                    return Status.CANCEL_STATUS;
                }
                input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                ISourceLineTracker model = null;
                String line = null;
                while ((line = input.readLine()) != null) {
                    console.println(line);
                    ExternalCheckerProblem problem = this.parseProblem(line);
                    if (problem == null) continue;
                    if (model == null) {
                        model = TextUtils.createLineTracker((char[])module.getSourceAsCharArray());
                    }
                    ISourceRange bounds = model.getLineInformation(problem.getLineNumber() - 1);
                    if (problem.getType().indexOf(Messages.ExternalChecker_error) != -1) {
                        this.reportError(resource, problem.getLineNumber(), bounds.getOffset(), bounds.getOffset() + bounds.getLength(), problem.getDescription());
                        continue;
                    }
                    if (problem.getType().indexOf(Messages.ExternalChecker_warning) == -1) continue;
                    this.reportWarning(resource, problem.getLineNumber(), bounds.getOffset(), bounds.getOffset() + bounds.getLength(), problem.getDescription());
                }
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block11;
                System.out.println(e.toString());
            }
        }
        return Status.OK_STATUS;
    }

    private String getResourcePath(IResource resource) {
        if (resource.getLocation() != null) {
            return resource.getLocation().makeAbsolute().toOSString();
        }
        URI uri = resource.getLocationURI();
        IFileHandle file = this.environment.getFile(uri);
        return file.toOSString();
    }

    public ExternalCheckerProblem parseProblem(String problem) {
        List wlist = ExternalCheckerWildcardManager.loadCustomWildcards();
        int i = 0;
        while (i < this.rules.size()) {
            block4: {
                Rule rule = (Rule)this.rules.get(i);
                try {
                    WildcardMatcher wmatcher = new WildcardMatcher(wlist);
                    ExternalCheckerProblem cproblem = wmatcher.match(rule, problem);
                    if (cproblem != null) {
                        return cproblem;
                    }
                }
                catch (Exception x) {
                    if (!DLTKCore.DEBUG) break block4;
                    System.out.println(x.toString());
                }
            }
            ++i;
        }
        return null;
    }
}

