/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$OPBStringSolver;

    public OPBStringSolver() {
    }

    public OPBStringSolver(int n) {
        super(n);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        if (bl) {
            for (int i = 0; i < iVecInt.size(); ++i) {
                stringBuffer.append(new StringBuffer().append(iVec.get(i)).append(" x").append(iVecInt.get(i)).append(" ").toString());
            }
            stringBuffer.append(new StringBuffer().append(">= ").append(bigInteger).append(" ;\n").toString());
        } else {
            for (int i = 0; i < iVecInt.size(); ++i) {
                stringBuffer.append(new StringBuffer().append(((BigInteger)iVec.get(i)).negate()).append(" x").append(iVecInt.get(i)).append(" ").toString());
            }
            stringBuffer.append(new StringBuffer().append(">= ").append(bigInteger.negate()).append(" ;\n").toString());
        }
        return null;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        StringBuffer stringBuffer = this.getOut();
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(new StringBuffer().append(" #constraint= ").append(this.nbOfConstraints).append(" \n").toString());
        stringBuffer2.append("min : ");
        IVecInt iVecInt = objectiveFunction.getVars();
        IVec<BigInteger> iVec = objectiveFunction.getCoeffs();
        for (int i = 0; i < iVecInt.size(); ++i) {
            stringBuffer2.append(new StringBuffer().append(iVec.get(i)).append(" x").append(iVecInt.get(i)).append(" ").toString());
        }
        stringBuffer2.append(" ;\n");
        stringBuffer.insert(this.indxConstrObj, stringBuffer2);
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            stringBuffer.append(new StringBuffer().append("+1 x").append(iteratorInt.next()).append(" ").toString());
        }
        stringBuffer.append(new StringBuffer().append(">= ").append(n).append(" ;\n").toString());
        return null;
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            stringBuffer.append(new StringBuffer().append("-1 x").append(iteratorInt.next()).append(" ").toString());
        }
        stringBuffer.append(new StringBuffer().append(">= ").append(-n).append(" ;\n").toString());
        return null;
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            stringBuffer.append(new StringBuffer().append("+1 x").append(iteratorInt.next()).append(" ").toString());
        }
        stringBuffer.append(">= 1 ;\n");
        return null;
    }

    @Override
    public String getExplanation() {
        return null;
    }

    @Override
    public void setListOfVariablesForExplanation(IVecInt iVecInt) {
    }

    public String toString() {
        return this.getOut().toString();
    }

    public String toString(String string) {
        return "OPB output solver";
    }

    public int newVar(int n) {
        StringBuffer stringBuffer = this.getOut();
        stringBuffer.append(new StringBuffer().append("* #variable= ").append(n).toString());
        this.setNbVars(n);
        this.indxConstrObj = stringBuffer.length();
        return 0;
    }

    public void setExpectedNumberOfClauses(int n) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$OPBStringSolver == null ? (class$org$sat4j$pb$OPBStringSolver = OPBStringSolver.class$("org.sat4j.pb.OPBStringSolver")) : class$org$sat4j$pb$OPBStringSolver).desiredAssertionStatus();
    }
}

