/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.text.hover;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.internal.ui.editor.ScriptAnnotationIterator;
import org.eclipse.dltk.internal.ui.text.HTMLPrinter;
import org.eclipse.dltk.internal.ui.text.hover.AbstractScriptEditorTextHover;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public abstract class AbstractAnnotationHover
extends AbstractScriptEditorTextHover {
    protected DefaultMarkerAnnotationAccess fAnnotationAccess = new DefaultMarkerAnnotationAccess();
    protected boolean fAllAnnotations;
    private IPreferenceStore combinedStore = null;

    public AbstractAnnotationHover(boolean allAnnotations) {
        this.fAllAnnotations = allAnnotations;
    }

    protected String postUpdateMessage(String message) {
        return message;
    }

    protected String formatMessage(String message) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog(buffer, 0, AbstractAnnotationHover.getStyleSheet());
        buffer.append(this.postUpdateMessage(TextUtils.escapeHTML((String)message)));
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        if (textViewer instanceof ISourceViewer) {
            path = null;
            model = ((ISourceViewer)textViewer).getAnnotationModel();
        } else {
            path = this.getEditorInputPath();
            model = this.getAnnotationModel(path);
        }
        if (model == null) {
            return null;
        }
        try {
            store = this.getCombinedPreferenceStore();
            e = new ScriptAnnotationIterator(model, true, this.fAllAnnotations);
            layer = -1;
            message = null;
            while (true) {
                block13: {
                    if (e.hasNext()) break block13;
                    if (layer > -1) {
                        var16_14 = this.formatMessage(message);
                        var14_15 = null;
                        break;
                    }
                    ** GOTO lbl-1000
                }
                a = (Annotation)e.next();
                preference = this.getAnnotationPreference(a);
                if (preference == null || !AbstractAnnotationHover.isActive(store, preference.getTextPreferenceKey()) && !AbstractAnnotationHover.isActive(store, preference.getHighlightPreferenceKey())) continue;
                p = model.getPosition(a);
                l = this.fAnnotationAccess.getLayer(a);
                if (l <= layer || p == null || !p.overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = this.getMessageFromAnnotation(a)) == null || msg.trim().length() <= 0) continue;
                message = msg;
                layer = l;
            }
        }
        catch (Throwable var15_24) {
            var14_16 = null;
            try {
                if (path == null) throw var15_24;
                manager = FileBuffers.getTextFileBufferManager();
                manager.disconnect(path, LocationKind.NORMALIZE, null);
                throw var15_24;
            }
            catch (CoreException ex) {
                DLTKUIPlugin.log(ex.getStatus());
            }
            throw var15_24;
        }
        ** try [egrp 1[TRYBLOCK] [2 : 256->280)] { 
lbl45:
        // 1 sources

        if (path == null) return var16_14;
        manager = FileBuffers.getTextFileBufferManager();
        manager.disconnect(path, LocationKind.NORMALIZE, null);
        return var16_14;
lbl49:
        // 1 sources

        catch (CoreException ex) {
            DLTKUIPlugin.log(ex.getStatus());
        }
        return var16_14;
lbl-1000:
        // 1 sources

        {
            var14_17 = null;
        }
        try {}
        catch (CoreException ex) {
            DLTKUIPlugin.log(ex.getStatus());
            return null;
        }
        if (path == null) return null;
        manager = FileBuffers.getTextFileBufferManager();
        manager.disconnect(path, LocationKind.NORMALIZE, null);
        return null;
    }

    protected String getMessageFromAnnotation(Annotation a) {
        return a.getText();
    }

    protected static boolean isActive(IPreferenceStore store, String preference) {
        return preference != null && store.getBoolean(preference);
    }

    protected synchronized IPreferenceStore getCombinedPreferenceStore() {
        if (this.combinedStore == null) {
            this.combinedStore = new ChainedPreferenceStore(new IPreferenceStore[]{this.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.combinedStore;
    }

    protected IPath getEditorInputPath() {
        if (this.getEditor() == null) {
            return null;
        }
        IEditorInput input = this.getEditor().getEditorInput();
        if (input instanceof IStorageEditorInput) {
            try {
                return ((IStorageEditorInput)input).getStorage().getFullPath();
            }
            catch (CoreException ex) {
                DLTKUIPlugin.log(ex.getStatus());
            }
        }
        return null;
    }

    protected IAnnotationModel getAnnotationModel(IPath path) {
        IAnnotationModel iAnnotationModel;
        block8: {
            if (path == null) {
                return null;
            }
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.connect(path, LocationKind.NORMALIZE, null);
            }
            catch (CoreException ex) {
                DLTKUIPlugin.log(ex.getStatus());
                return null;
            }
            IAnnotationModel model = null;
            try {
                iAnnotationModel = model = manager.getTextFileBuffer(path, LocationKind.NORMALIZE).getAnnotationModel();
                Object var4_6 = null;
                if (model != null) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_7 = null;
                    if (model != null) break block9;
                    try {
                        manager.disconnect(path, LocationKind.NORMALIZE, null);
                    }
                    catch (CoreException ex) {
                        DLTKUIPlugin.log(ex.getStatus());
                    }
                }
                throw throwable;
            }
            try {
                manager.disconnect(path, LocationKind.NORMALIZE, null);
            }
            catch (CoreException ex) {
                DLTKUIPlugin.log(ex.getStatus());
            }
        }
        return iAnnotationModel;
    }

    protected AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }
}

