/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuffer;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementVisitor;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptModel;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IShutdownListener;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.internal.core.BufferManager;
import org.eclipse.dltk.internal.core.BuiltinSourceModule;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.ui.DLTKUIMessages;
import org.eclipse.dltk.internal.ui.editor.DocumentAdapter;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.editor.ISourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.SourceModuleDocumentProvider;
import org.eclipse.dltk.internal.ui.editor.WorkingCopyManager;
import org.eclipse.dltk.internal.ui.text.hover.EditorTextHoverDescriptor;
import org.eclipse.dltk.internal.ui.wizards.buildpath.BuildpathAttributeConfigurationDescriptors;
import org.eclipse.dltk.launching.sourcelookup.DBGPSourceModule;
import org.eclipse.dltk.ui.IWorkingCopyManager;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.ui.text.completion.ContentAssistHistory;
import org.eclipse.dltk.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.dltk.ui.viewsupport.ProblemMarkerManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ConfigurationElementSorter;
import org.osgi.framework.BundleContext;

public class DLTKUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.dltk.ui";
    public static final String ID_SCRIPTEXPLORER = "org.eclipse.dltk.ui.ScriptExplorer";
    public static final String ID_TYPE_HIERARCHY = "org.eclipse.dltk.ui.TypeHierarchy";
    public static final String ID_BUILDPATH_VARIABLES_PREFERENCE_PAGE = "org.eclipse.dltk.ui.preferences.BuildpathVariablesPreferencePage";
    private static DLTKUIPlugin plugin;
    private MembersOrderPreferenceCache fMembersOrderPreferenceCache;
    private static ISharedImages fgSharedImages;
    private ContentAssistHistory fContentAssistHistory;
    private BuildpathAttributeConfigurationDescriptors fBuildpathAttributeConfigurationDescriptors;
    private final ListenerList shutdownListeners = new ListenerList();
    private IWorkingCopyManager fWorkingCopyManager;
    private ISourceModuleDocumentProvider fSourceModuleDocumentProvider;
    private ProblemMarkerManager fProblemMarkerManager;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    private final Map editorTextHoverDescriptorsByNature = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        fgSharedImages = null;
    }

    public DLTKUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        WorkingCopyOwner.setPrimaryBufferProvider((WorkingCopyOwner)new WorkingCopyOwner(){

            public IBuffer createBuffer(ISourceModule workingCopy) {
                ISourceModule original = workingCopy.getPrimary();
                IResource resource = original.getResource();
                if (resource != null) {
                    if (resource instanceof IFile) {
                        return new DocumentAdapter((IOpenable)workingCopy, (IFile)resource);
                    }
                } else if (original instanceof ExternalSourceModule) {
                    IProjectFragment fragment = (IProjectFragment)original.getAncestor(3);
                    if (!fragment.isArchive()) {
                        return BufferManager.createBuffer((IOpenable)original);
                    }
                    return BufferManager.createBuffer((IOpenable)original);
                }
                if (original instanceof DBGPSourceModule) {
                    return BufferManager.createBuffer((IOpenable)original);
                }
                if (original instanceof BuiltinSourceModule) {
                    return BufferManager.createBuffer((IOpenable)original);
                }
                return DocumentAdapter.NULL;
            }
        });
        IPreferenceStore store = this.getPreferenceStore();
        this.fMembersOrderPreferenceCache = new MembersOrderPreferenceCache();
        this.fMembersOrderPreferenceCache.install(store);
        DLTKLaunchingPlugin.getDefault();
        PlatformUI.getWorkbench().addWorkbenchListener(new IWorkbenchListener(){

            public void postShutdown(IWorkbench workbench) {
            }

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                IWorkbenchPage activePage;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (activePage = window.getActivePage()) != null) {
                    IEditorReference[] references = activePage.getEditorReferences();
                    int i = 0;
                    while (i < references.length) {
                        ScriptEditor scriptEditor;
                        IModelElement modelElement;
                        IEnvironment environment;
                        IEditorPart editor = references[i].getEditor(false);
                        if (editor != null && editor instanceof ScriptEditor && (environment = EnvironmentManager.getEnvironment((IModelElement)(modelElement = (scriptEditor = (ScriptEditor)editor).getInputModelElement()))) != null && !environment.getId().equals("org.eclipse.dltk.core.environment.localEnvironment")) {
                            scriptEditor.close(false);
                        }
                        ++i;
                    }
                }
                return true;
            }
        });
    }

    public void addShutdownListener(IShutdownListener listener) {
        this.shutdownListeners.add((Object)listener);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fMembersOrderPreferenceCache != null) {
            this.fMembersOrderPreferenceCache.dispose();
            this.fMembersOrderPreferenceCache = null;
        }
        Object[] listeners = this.shutdownListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IShutdownListener)listeners[i]).shutdown();
            ++i;
        }
        this.shutdownListeners.clear();
        super.stop(context);
        plugin = null;
    }

    private IWorkbenchPage internalGetActivePage() {
        IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static DLTKUIPlugin getDefault() {
        return plugin;
    }

    public IDialogSettings getDialogSettingsSection(String name) {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(name);
        if (section == null) {
            section = dialogSettings.addNewSection(name);
        }
        return section;
    }

    public static IWorkbenchPage getActivePage() {
        return DLTKUIPlugin.getDefault().internalGetActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DLTKUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public synchronized IWorkingCopyManager getWorkingCopyManager() {
        if (this.fWorkingCopyManager == null) {
            ISourceModuleDocumentProvider provider = this.getSourceModuleDocumentProvider();
            this.fWorkingCopyManager = new WorkingCopyManager(provider);
        }
        return this.fWorkingCopyManager;
    }

    public synchronized ISourceModuleDocumentProvider getSourceModuleDocumentProvider() {
        if (this.fSourceModuleDocumentProvider == null) {
            this.fSourceModuleDocumentProvider = new SourceModuleDocumentProvider();
        }
        return this.fSourceModuleDocumentProvider;
    }

    public static ISourceModuleDocumentProvider getDocumentProvider() {
        return DLTKUIPlugin.getDefault().getSourceModuleDocumentProvider();
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return DLTKUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.fImageDescriptorRegistry == null) {
            this.fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.fImageDescriptorRegistry;
    }

    public static ISourceModule getEditorInputModelElement(IEditorInput editorInput) {
        IModelElement me;
        ISourceModule module;
        ISourceModule je = DLTKUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(editorInput, false);
        if (je != null) {
            return je;
        }
        if (editorInput instanceof FileStoreEditorInput && (module = DLTKUIPlugin.resolveSourceModule((FileStoreEditorInput)editorInput)) != null) {
            return module;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dltk.core.IModelElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((me = (IModelElement)editorInput.getAdapter((Class)clazz)) instanceof ISourceModule) {
            return (ISourceModule)me;
        }
        return null;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        DLTKUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        DLTKUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, DLTKUIMessages.ScriptPlugin_internal_error, e));
    }

    public static void logErrorMessage(String message) {
        DLTKUIPlugin.logErrorMessage(message, null);
    }

    public static void warn(String message) {
        DLTKUIPlugin.warn(message, null);
    }

    public static void warn(String message, Throwable throwable) {
        DLTKUIPlugin.log((IStatus)new Status(2, PLUGIN_ID, 10001, message, throwable));
    }

    public static void logErrorMessage(String message, Throwable throwable) {
        DLTKUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, 10001, message, throwable));
    }

    public static void logErrorStatus(String message, IStatus status) {
        if (status == null) {
            DLTKUIPlugin.logErrorMessage(message);
            return;
        }
        MultiStatus multi = new MultiStatus(PLUGIN_ID, 10001, message, null);
        multi.add(status);
        DLTKUIPlugin.log((IStatus)multi);
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = DLTKUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    public synchronized MembersOrderPreferenceCache getMemberOrderPreferenceCache() {
        return this.fMembersOrderPreferenceCache;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public ContentAssistHistory getContentAssistHistory() {
        if (this.fContentAssistHistory == null) {
            try {
                this.fContentAssistHistory = ContentAssistHistory.load(this.getPluginPreferences(), "content_assist_lru_history");
            }
            catch (CoreException x) {
                DLTKUIPlugin.log(x);
            }
            if (this.fContentAssistHistory == null) {
                this.fContentAssistHistory = new ContentAssistHistory();
            }
        }
        return this.fContentAssistHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditorTextHoverDescriptors() {
        Map map = this.editorTextHoverDescriptorsByNature;
        synchronized (map) {
            this.editorTextHoverDescriptorsByNature.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEditorTextHoverDescriptors(String natureId) {
        Map map = this.editorTextHoverDescriptorsByNature;
        synchronized (map) {
            this.editorTextHoverDescriptorsByNature.remove(natureId);
        }
    }

    public EditorTextHoverDescriptor[] getEditorTextHoverDescriptors(IPreferenceStore store) {
        return this.initializeEditorTextHoverDescriprtors(store, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorTextHoverDescriptor[] getEditorTextHoverDescriptors(IPreferenceStore store, String natureId) {
        EditorTextHoverDescriptor[] descriptors;
        Map map = this.editorTextHoverDescriptorsByNature;
        synchronized (map) {
            descriptors = (EditorTextHoverDescriptor[])this.editorTextHoverDescriptorsByNature.get(natureId);
        }
        if (descriptors == null && (descriptors = this.initializeEditorTextHoverDescriprtors(store, natureId)) != null && natureId != null) {
            map = this.editorTextHoverDescriptorsByNature;
            synchronized (map) {
                this.editorTextHoverDescriptorsByNature.put(natureId, descriptors);
            }
        }
        return descriptors;
    }

    private EditorTextHoverDescriptor[] initializeEditorTextHoverDescriprtors(IPreferenceStore store, String natureId) {
        Object[] descriptors = EditorTextHoverDescriptor.getContributedHovers(natureId, store);
        ConfigurationElementSorter sorter = new ConfigurationElementSorter(){

            public IConfigurationElement getConfigurationElement(Object object) {
                return ((EditorTextHoverDescriptor)object).getConfigurationElement();
            }
        };
        sorter.sort(descriptors);
        int i = 0;
        while (i < descriptors.length - 1) {
            if ("org.eclipse.dltk.ui.BestMatchHover".equals(((EditorTextHoverDescriptor)descriptors[i]).getId())) {
                Object hoverDescriptor = descriptors[i];
                int j = i;
                while (j > 0) {
                    descriptors[j] = descriptors[j - 1];
                    --j;
                }
                descriptors[0] = hoverDescriptor;
                break;
            }
            ++i;
        }
        return descriptors;
    }

    public static IEditorPart openInEditor(IModelElement element) throws ModelException, PartInitException {
        return DLTKUIPlugin.openInEditor(element, true, true);
    }

    public static IEditorPart openInEditor(IModelElement element, boolean activate, boolean reveal) throws ModelException, PartInitException {
        if (!(element instanceof ISourceReference)) {
            return null;
        }
        IEditorPart part = EditorUtility.openInEditor(element, activate);
        if (reveal && part != null) {
            EditorUtility.revealInEditor(part, element);
        }
        return part;
    }

    public synchronized ProblemMarkerManager getProblemMarkerManager() {
        if (this.fProblemMarkerManager == null) {
            this.fProblemMarkerManager = new ProblemMarkerManager();
        }
        return this.fProblemMarkerManager;
    }

    public static boolean isDebug() {
        return DLTKCore.DEBUG;
    }

    public BuildpathAttributeConfigurationDescriptors getClasspathAttributeConfigurationDescriptors() {
        if (this.fBuildpathAttributeConfigurationDescriptors == null) {
            this.fBuildpathAttributeConfigurationDescriptors = new BuildpathAttributeConfigurationDescriptors();
        }
        return this.fBuildpathAttributeConfigurationDescriptors;
    }

    public static ISourceModule resolveSourceModule(FileStoreEditorInput input) {
        final ISourceModule[] modules = new ISourceModule[1];
        final IPath filePath = URIUtil.toPath((URI)input.getURI());
        IScriptModel scriptModel = DLTKCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        try {
            scriptModel.accept(new IModelElementVisitor(){

                public boolean visit(IModelElement element) {
                    boolean shouldDescend;
                    boolean bl = shouldDescend = modules[0] == null;
                    if (shouldDescend) {
                        if (element instanceof ExternalProjectFragment) {
                            ExternalProjectFragment fragment = (ExternalProjectFragment)element;
                            try {
                                if (filePath.removeLastSegments(1).toFile().getCanonicalPath().startsWith(fragment.getPath().toFile().getCanonicalPath())) {
                                    ISourceModule module;
                                    Path folderPath = new Path(filePath.removeLastSegments(1).toFile().getCanonicalPath());
                                    IScriptFolder folder = fragment.getScriptFolder((IPath)(folderPath = folderPath.removeFirstSegments(new Path(fragment.getPath().toFile().getCanonicalPath()).segmentCount())));
                                    if (folder != null && folder.exists() && (module = folder.getSourceModule(filePath.lastSegment())) != null) {
                                        modules[0] = module;
                                    }
                                }
                            }
                            catch (IOException ixcn) {
                                ixcn.printStackTrace();
                            }
                            shouldDescend = false;
                        } else {
                            shouldDescend = element instanceof IScriptProject || element instanceof IScriptModel;
                        }
                    }
                    return shouldDescend;
                }
            });
        }
        catch (ModelException mxcn) {
            mxcn.printStackTrace();
        }
        return modules[0];
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

