/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.input.NonExistingPHPFileEditorInput;
import org.eclipse.php.internal.ui.preferences.PHPTemplateStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class UntitledPHPDocumentWizard
extends Wizard
implements INewWizard {
    private IWorkbenchWindow fWindow;
    private static final String UNTITLED_PHP_DOC_PREFIX = "PHPDocument";

    public UntitledPHPDocumentWizard() {
    }

    public UntitledPHPDocumentWizard(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void dispose() {
        this.fWindow = null;
    }

    private IFileStore queryFileStore() {
        IPath stateLocation = PHPUiPlugin.getDefault().getStateLocation();
        IPath path = stateLocation.append("/_" + new Object().hashCode());
        return EFS.getLocalFileSystem().getStore(path);
    }

    private IEditorInput createEditorInput(IFileStore fileStore) {
        return new NonExistingPHPFileEditorInput(fileStore, UNTITLED_PHP_DOC_PREFIX);
    }

    public boolean performFinish() {
        Template template;
        StructuredTextEditor textEditor;
        block7: {
            String templateName;
            block6: {
                IFileStore fileStore = this.queryFileStore();
                IEditorInput input = this.createEditorInput(fileStore);
                IWorkbenchPage page = this.fWindow.getActivePage();
                IEditorPart editor = page.openEditor(input, "org.eclipse.php.editor");
                textEditor = null;
                if (editor instanceof StructuredTextEditor) {
                    textEditor = (StructuredTextEditor)editor;
                }
                if ((templateName = PHPUiPlugin.getDefault().getPreferenceStore().getString("newFileTemplateName")) != null && templateName.length() != 0) break block6;
                return true;
            }
            TemplateStore templateStore = PHPUiPlugin.getDefault().getTemplateStore();
            template = templateStore.findTemplate(templateName);
            if (template != null) break block7;
            return true;
        }
        try {
            PHPTemplateStore.CompiledTemplate compiledTemplate = PHPTemplateStore.compileTemplate(PHPUiPlugin.getDefault().getTemplateContextRegistry(), template);
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
            document.set(compiledTemplate.string);
            documentProvider.saveDocument(null, (Object)textEditor.getEditorInput(), document, true);
            textEditor.selectAndReveal(compiledTemplate.offset, 0);
        }
        catch (PartInitException e) {
            Logger.logException(e);
            return false;
        }
        catch (CoreException e) {
            Logger.logException(e);
            return false;
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWindow = workbench.getActiveWorkbenchWindow();
    }
}

