/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ui.wizards.WorkingSetsDialog;
import org.eclipse.ui.PlatformUI;

public class CheckoutAsMainPage
extends CVSWizardPage {
    private String newProjectName;
    private boolean allowProjectConfiguration;
    private Button intoProjectButton;
    private Button simpleProjectButton;
    private Button configuredProjectButton;
    private Text projectNameField;
    private ICVSRemoteFolder[] folders;
    private Button recurseCheck;
    private boolean recurse = true;
    private Button addToWorkingSet;
    private Button browseButton;
    Text workingSetField;
    private boolean haveBrowsed;
    public static final String NAME = "CheckoutAsMainPage";

    public CheckoutAsMainPage(ImageDescriptor titleImage, ICVSRemoteFolder[] folders, boolean allowProjectConfiguration) {
        super(NAME, CVSUIMessages.CheckoutAsMainPage_title, titleImage, CVSUIMessages.CheckoutAsMainPage_description);
        this.folders = folders;
        this.allowProjectConfiguration = allowProjectConfiguration;
    }

    public void createControl(Composite parent) {
        Composite composite = this.createComposite(parent, 1, false);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.cvs.ui.checkout_configuration_context");
        if (this.isSingleFolder()) {
            this.createSingleFolderArea(composite);
        } else {
            this.createMultipleFoldersArea(composite);
        }
        this.updateEnablements();
        Dialog.applyDialogFont((Control)parent);
    }

    private boolean isSingleFolder() {
        return this.folders.length == 1;
    }

    private String getFolderName() {
        String name = CheckoutAsMainPage.getPreferredFolderName(this.folders[0]);
        if (name.equals(".")) {
            name = new Path(null, this.folders[0].getRepository().getRootDirectory()).lastSegment();
        }
        return name;
    }

    private void createSingleFolderArea(Composite composite) {
        CheckoutAsMainPage.createLabel(composite, NLS.bind((String)CVSUIMessages.CheckoutAsMainPage_singleFolder, (Object[])new String[]{this.getFolderName()}));
        this.configuredProjectButton = this.createRadioButton(composite, CVSUIMessages.CheckoutAsMainPage_asConfiguredProject, 1);
        if (!this.allowProjectConfiguration) {
            this.configuredProjectButton.setEnabled(false);
            Label configuredLabel = this.createWrappingLabel(composite, CVSUIMessages.CheckoutAsMainPage_10, 5);
            configuredLabel.setEnabled(false);
        }
        this.createCheckoutAsProjectRadioArea(composite);
        this.createCheckoutIntoRadioArea(composite);
        if (this.allowProjectConfiguration) {
            this.configuredProjectButton.setSelection(true);
        } else {
            this.simpleProjectButton.setSelection(true);
        }
        new Label(composite, 0);
        this.recurseCheck = this.createCheckBox(composite, CVSUIMessages.CheckoutAsProjectSelectionPage_recurse);
        this.recurseCheck.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CheckoutAsMainPage.this.recurse = CheckoutAsMainPage.this.recurseCheck.getSelection();
            }
        });
        this.recurseCheck.setSelection(this.recurse);
        this.addWorkingSetSection(composite, CVSUIMessages.CheckoutAsMainPage_WorkingSetSingle);
    }

    private void createMultipleFoldersArea(Composite composite) {
        CheckoutAsMainPage.createLabel(composite, NLS.bind((String)CVSUIMessages.CheckoutAsMainPage_multipleFolders, (Object[])new String[]{new Integer(this.folders.length).toString()}));
        this.createCheckoutAsProjectRadioArea(composite);
        this.createCheckoutIntoRadioArea(composite);
        this.simpleProjectButton.setSelection(true);
        this.addWorkingSetSection(composite, CVSUIMessages.CheckoutAsMainPage_WorkingSetMultiple);
    }

    private void createCheckoutAsProjectRadioArea(Composite composite) {
        if (this.isSingleFolder()) {
            this.simpleProjectButton = this.createRadioButton(composite, CVSUIMessages.CheckoutAsMainPage_asSimpleProject, 1);
            this.createProjectNameGroup(composite);
        } else {
            this.simpleProjectButton = this.createRadioButton(composite, CVSUIMessages.CheckoutAsMainPage_asProjects, 1);
        }
    }

    private void createCheckoutIntoRadioArea(Composite composite) {
        this.intoProjectButton = this.createRadioButton(composite, CVSUIMessages.CheckoutAsMainPage_intoProject, 1);
    }

    private void createProjectNameGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(CVSUIMessages.CheckoutAsMainPage_projectNameLabel);
        this.projectNameField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        this.projectNameField.setLayoutData((Object)data);
        this.newProjectName = this.getFolderName();
        this.projectNameField.setText(this.newProjectName);
        this.projectNameField.selectAll();
        this.projectNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckoutAsMainPage.this.updateEnablements();
            }
        });
    }

    void updateEnablements() {
        if (this.projectNameField != null) {
            this.projectNameField.setEnabled(this.simpleProjectButton.getSelection());
            if (this.projectNameField.isEnabled()) {
                this.newProjectName = this.projectNameField.getText();
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IStatus nameStatus = workspace.validateName(this.newProjectName, 4);
                if (!nameStatus.isOK()) {
                    this.setErrorMessage(nameStatus.getMessage());
                    this.setPageComplete(false);
                    return;
                }
            }
        }
        this.workingSetField.setEnabled(this.addToWorkingSet.getSelection());
        this.browseButton.setEnabled(this.addToWorkingSet.getSelection());
        if (this.addToWorkingSet.getSelection() && !this.haveBrowsed) {
            this.setPageComplete(false);
            return;
        }
        if (!this.validateWorkingSetName()) {
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    public String getProjectName() {
        if (this.isSingleFolder() && this.simpleProjectButton.getSelection()) {
            return this.newProjectName;
        }
        return null;
    }

    public boolean isPerformConfigure() {
        if (this.configuredProjectButton == null) {
            return false;
        }
        return this.configuredProjectButton.getSelection();
    }

    public boolean isPerformCheckoutInto() {
        return this.intoProjectButton.getSelection();
    }

    public boolean isPerformCheckoutAs() {
        return this.simpleProjectButton.getSelection();
    }

    protected Button createRadioButton(Composite parent, String label, int span) {
        Button radio = super.createRadioButton(parent, label, span);
        radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutAsMainPage.this.updateEnablements();
            }
        });
        return radio;
    }

    public boolean isRecurse() {
        return this.recurse;
    }

    public String getWorkingSetName() {
        return this.workingSetField.getText();
    }

    public boolean shouldAddToWorkingSet() {
        return this.addToWorkingSet.getSelection();
    }

    private void addWorkingSetSection(Composite composite, String label) {
        this.addToWorkingSet = this.createCheckBox(composite, label);
        this.addToWorkingSet.setSelection(false);
        this.addToWorkingSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutAsMainPage.this.updateEnablements();
            }
        });
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        this.workingSetField = CheckoutAsMainPage.createTextField(inner);
        this.workingSetField.setEditable(false);
        this.browseButton = new Button(inner, 8);
        this.browseButton.setText(CVSUIMessages.CheckoutAsMainPage_Browse);
        this.haveBrowsed = false;
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkingSetsDialog dialog = new WorkingSetsDialog(CheckoutAsMainPage.this.getShell());
                CheckoutAsMainPage.this.haveBrowsed = true;
                if (dialog.open() == 0) {
                    CheckoutAsMainPage.this.workingSetField.setText(dialog.getSelectedWorkingSet());
                }
                CheckoutAsMainPage.this.updateEnablements();
            }
        });
        this.updateEnablements();
    }

    private boolean validateWorkingSetName() {
        String workingSetName;
        if (this.addToWorkingSet.getSelection() && (workingSetName = this.workingSetField.getText()).length() == 0) {
            this.setMessage(CVSUIMessages.CheckoutAsMainPage_EmptyWorkingSetErrorMessage, 3);
            return false;
        }
        this.setMessage(null);
        return true;
    }
}

