/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.launching.zend;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.debug.ui.IDebugServerConnectionTest;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestController;
import org.eclipse.php.internal.debug.core.zend.testConnection.DebugServerTestEvent;
import org.eclipse.php.internal.debug.core.zend.testConnection.IDebugServerTestListener;
import org.eclipse.php.internal.server.PHPServerUIMessages;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.ui.Logger;
import org.eclipse.php.internal.server.ui.launching.zend.DefaultServerTestMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class DefaultDebugServerConnectionTest
implements IDebugServerConnectionTest,
IDebugServerTestListener {
    protected Shell fShell;
    protected Server fServer;
    protected String fURL;
    private Boolean isFinished = false;
    private ProgressMonitorDialog progressDialog = null;
    private static final int DEFAULT_TIMEOUT = 10000;
    private List<String> timeoutServerList = new ArrayList<String>();

    public void testConnection(Server server, Shell shell) {
        this.fServer = server;
        this.fShell = shell;
        this.fURL = server.getBaseURL();
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testingConnectivity"), -1);
                try {
                    this.checkWebServerExistence();
                    if (monitor.isCanceled()) {
                        return;
                    }
                    String[] hosts = DefaultDebugServerConnectionTest.this.getAllLocalHostsAddresses();
                    DebugServerTestController.getInstance().addListener((IDebugServerTestListener)DefaultDebugServerConnectionTest.this);
                    String[] stringArray = hosts;
                    int n = hosts.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String clientHost;
                        block16: {
                            clientHost = stringArray[n2];
                            if (monitor.isCanceled()) {
                                return;
                            }
                            DefaultDebugServerConnectionTest.this.isFinished = false;
                            String debugQuery = DefaultDebugServerConnectionTest.this.generateDebugQuery(clientHost);
                            try {
                                this.activateTestDebug(monitor, clientHost, debugQuery);
                            }
                            catch (SocketTimeoutException socketTimeoutException) {
                                if (DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) break block16;
                                String generalTimeout = NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)DefaultDebugServerConnectionTest.this.fURL);
                                DefaultDebugServerConnectionTest.this.showCustomErrorDialog(generalTimeout);
                                return;
                            }
                        }
                        if (DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) break;
                        Thread.sleep(10000L);
                        if (DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) break;
                        DefaultDebugServerConnectionTest.this.timeoutServerList.add(clientHost);
                        ++n2;
                    }
                    if (DefaultDebugServerConnectionTest.this.isFinished != false) return;
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(DefaultDebugServerConnectionTest.this.addTimeOutsMessage("A timeout occurred when the debug server attempted to connect to the following client hosts/IPs:\n"));
                    return;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_theURLCouldNotBeFound"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (!DefaultDebugServerConnectionTest.this.isFinished.booleanValue()) {
                        DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                        return;
                    }
                    DefaultDebugServerConnectionTest.this.removeThisListener();
                    return;
                }
                catch (ConnectException connectException) {
                    DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_webServerConnectionFailed"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                    return;
                    catch (IOException iOException) {
                        DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_webServerConnectionFailed"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                        return;
                    }
                }
                finally {
                    DefaultDebugServerConnectionTest.this.removeThisListener();
                }
            }

            private void activateTestDebug(IProgressMonitor monitor, String clientHost, String debugQuery) throws IOException {
                monitor.subTask(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testingCommunication"), (Object)clientHost));
                InputStream inputStream = null;
                try {
                    URL checkDebugURL = new URL(debugQuery);
                    URLConnection debugConnection = checkDebugURL.openConnection();
                    debugConnection.setReadTimeout(10000);
                    inputStream = debugConnection.getInputStream();
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }

            private void checkWebServerExistence() throws MalformedURLException, IOException {
                InputStream inputStream = null;
                try {
                    URL checkURL = new URL(String.valueOf(DefaultDebugServerConnectionTest.this.fURL) + "/dummy.php");
                    URLConnection connection = checkURL.openConnection();
                    connection.setConnectTimeout(5000);
                    connection.setReadTimeout(10000);
                    inputStream = connection.getInputStream();
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        };
        this.progressDialog = new ProgressMonitorDialog(this.fShell);
        this.progressDialog.setBlockOnOpen(false);
        this.progressDialog.setCancelable(true);
        try {
            this.progressDialog.run(true, true, runnableWithProgress);
        }
        catch (Exception e) {
            Logger.logException(e);
        }
    }

    private void removeThisListener() {
        DebugServerTestController.getInstance().removeListener((IDebugServerTestListener)this);
    }

    protected void showCustomErrorDialog(final String message) {
        this.fShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DefaultServerTestMessageDialog dialog = new DefaultServerTestMessageDialog(DefaultDebugServerConnectionTest.this.fShell, PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), null, message, 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        });
    }

    protected String generateDebugQuery(String host) {
        String urlToDebug = "";
        StringBuilder queryBuilder = new StringBuilder();
        queryBuilder.append(this.fURL);
        queryBuilder.append("/dummy.php?start_debug=1&debug_port=");
        String port = Integer.toString(PHPDebugPlugin.getDebugPort((String)"org.eclipse.php.debug.core.zendDebugger"));
        queryBuilder.append(port);
        queryBuilder.append("&debug_fastfile=1&debug_host=");
        queryBuilder.append(String.valueOf(host) + "&testConnection=true");
        urlToDebug = queryBuilder.toString();
        return urlToDebug;
    }

    private String[] getAllLocalHostsAddresses() {
        Preferences prefs = PHPProjectPreferences.getModelPreferences();
        String hosts = prefs.getString(PHPDebugCorePreferenceNames.CLIENT_IP);
        StringTokenizer tokenizer = new StringTokenizer(hosts, ", ");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private void showSuccessMessage() {
        String message = PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_success");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(message);
        if (this.timeoutServerList.size() > 0) {
            stringBuilder.append("\n");
            stringBuilder.append(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_however"));
            stringBuilder.append(this.addTimeOutsMessage(""));
        }
        MessageDialog.openInformation((Shell)this.fShell, (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), (String)stringBuilder.toString());
    }

    private String addTimeOutsMessage(String message) {
        String result = message;
        if (this.timeoutServerList.size() > 0) {
            Iterator<String> iter = this.timeoutServerList.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (iter.hasNext()) {
                stringBuilder.append(String.valueOf('-') + iter.next() + '\n');
            }
            stringBuilder.append(PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_theClientHostIPs"));
            result = String.valueOf(result) + stringBuilder.toString();
        }
        return result;
    }

    public void testEventReceived(final DebugServerTestEvent e) {
        this.fShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                DefaultDebugServerConnectionTest.this.removeThisListener();
                if (e.getEventType() == 0) {
                    DefaultDebugServerConnectionTest.this.isFinished = true;
                    DefaultDebugServerConnectionTest.this.showSuccessMessage();
                } else {
                    switch (e.getEventType()) {
                        case 2: {
                            MessageDialog.openError((Shell)DefaultDebugServerConnectionTest.this.fShell, (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_testDebugServer"), (String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_oldDebuggerVersion"));
                            break;
                        }
                        case 1: {
                            DefaultDebugServerConnectionTest.this.showCustomErrorDialog(NLS.bind((String)PHPServerUIMessages.getString("DefaultDebugServerConnectionTest_timeOutMessage"), (Object)DefaultDebugServerConnectionTest.this.fURL));
                        }
                    }
                }
            }
        });
    }
}

