/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.provisional.p2.ui.operations;

import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.ui.ProvUI;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.UndoableProvisioningOperation;

abstract class RepositoryOperation
extends UndoableProvisioningOperation {
    URL[] urls;

    RepositoryOperation(String label, URL[] urls) {
        super(label);
        this.urls = urls;
    }

    public boolean canExecute() {
        return this.urls != null;
    }

    public boolean canUndo() {
        return this.urls != null;
    }

    public Object[] getAffectedObjects() {
        return this.urls;
    }

    public boolean runInBackground() {
        return true;
    }

    protected IStatus doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws ProvisionException {
        boolean batched = false;
        if (this.urls != null && this.urls.length > 1) {
            ProvUI.startBatchOperation();
            batched = true;
        }
        IStatus status = this.doBatchedExecute(monitor, uiInfo);
        if (batched) {
            ProvUI.endBatchOperation();
        }
        return status;
    }

    protected IStatus doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws ProvisionException {
        boolean batched = false;
        if (this.urls != null && this.urls.length > 1) {
            ProvUI.startBatchOperation();
            batched = true;
        }
        IStatus status = this.doBatchedUndo(monitor, uiInfo);
        if (batched) {
            ProvUI.endBatchOperation();
        }
        return status;
    }

    protected abstract IStatus doBatchedExecute(IProgressMonitor var1, IAdaptable var2) throws ProvisionException;

    protected abstract IStatus doBatchedUndo(IProgressMonitor var1, IAdaptable var2) throws ProvisionException;
}

