/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.NewDependencyExpander;
import org.eclipse.equinox.internal.p2.director.OperationGenerator;
import org.eclipse.equinox.internal.p2.director.Projector;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.p2.resolution.ResolutionHelper;
import org.eclipse.equinox.internal.p2.rollback.FormerState;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.IUProfilePropertyQuery;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.ProvisioningPlan;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.InstallableUnitPropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.Operand;
import org.eclipse.equinox.internal.provisional.p2.engine.PropertyOperand;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.UpdateQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;

public class SimplePlanner
implements IPlanner {
    private static final int ExpandWork = 12;
    private static final String PLANNER_MARKER = "private.org.eclipse.equinox.p2.planner.installed";
    public static final String INCLUSION_RULES = "org.eclipse.equinox.p2.internal.inclusion.rules";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    private IProfile getProfile(String profileId) {
        IProfileRegistry profileRegistry;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName())) == null) {
            return null;
        }
        return profileRegistry.getProfile(profileId);
    }

    private ProvisioningPlan generateProvisioningPlan(IStatus status, Collection fromState, Collection toState, ProfileChangeRequest changeRequest) {
        InstallableUnitOperand[] iuOperands = this.generateOperations(fromState, toState);
        PropertyOperand[] propertyOperands = this.generatePropertyOperations(changeRequest);
        Operand[] operands = new Operand[iuOperands.length + propertyOperands.length];
        System.arraycopy(iuOperands, 0, operands, 0, iuOperands.length);
        System.arraycopy(propertyOperands, 0, operands, iuOperands.length, propertyOperands.length);
        if (status == null) {
            status = Status.OK_STATUS;
        }
        return new ProvisioningPlan(status, operands);
    }

    private PropertyOperand[] generatePropertyOperations(ProfileChangeRequest profileChangeRequest) {
        IProfile profile = profileChangeRequest.getProfile();
        ArrayList<Object> operands = new ArrayList<Object>();
        String[] toRemove = profileChangeRequest.getPropertiesToRemove();
        Map existingProperties = profile.getProperties();
        int i = 0;
        while (i < toRemove.length) {
            if (existingProperties.containsKey(toRemove[i])) {
                operands.add(new PropertyOperand(toRemove[i], existingProperties.get(toRemove[i]), null));
            }
            ++i;
        }
        Map propertyChanges = profileChangeRequest.getPropertiesToAdd();
        Iterator iter = propertyChanges.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            operands.add(new PropertyOperand(key, existingProperties.get(key), propertyChanges.get(key)));
        }
        Map allIUPropertyChanges = profileChangeRequest.getInstallableUnitProfilePropertiesToAdd();
        iter = allIUPropertyChanges.keySet().iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iter.next();
            Map iuPropertyChanges = (Map)allIUPropertyChanges.get(iu);
            Iterator iuPropIter = iuPropertyChanges.keySet().iterator();
            while (iuPropIter.hasNext()) {
                String key = (String)iuPropIter.next();
                String oldValue = profile.getInstallableUnitProperty(iu, key);
                operands.add(new InstallableUnitPropertyOperand(iu, key, (Object)oldValue, iuPropertyChanges.get(key)));
            }
        }
        Map allIUPropertyDeletions = profileChangeRequest.getInstallableUnitProfilePropertiesToRemove();
        iter = allIUPropertyDeletions.keySet().iterator();
        while (iter.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iter.next();
            Map existingIUProperties = profile.getInstallableUnitProperties(iu);
            List iuPropertyRemovals = (List)allIUPropertyDeletions.get(iu);
            Iterator it = iuPropertyRemovals.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!existingIUProperties.containsKey(key)) continue;
                operands.add(new InstallableUnitPropertyOperand(iu, key, existingIUProperties.get(key), null));
            }
        }
        return operands.toArray(new PropertyOperand[operands.size()]);
    }

    private InstallableUnitOperand[] generateOperations(Collection fromState, Collection toState) {
        return new OperationGenerator().generateOperation(fromState, toState);
    }

    public ProvisioningPlan getRevertPlan(IInstallableUnit profileSnapshot, ProvisioningContext context, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.director", 1, Messages.Director_Revert_Problems, null);
            if (!Boolean.valueOf(profileSnapshot.getProperty("org.eclipse.equinox.p2.type.profile")).booleanValue()) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Director_Unexpected_IU, (Object)profileSnapshot.getId())));
                ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)result);
                return provisioningPlan;
            }
            IProfile profile = this.getProfile(profileSnapshot.getId());
            if (profile == null) {
                result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Director_Unexpected_IU, (Object)profileSnapshot.getId())));
                ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)result);
                return provisioningPlan;
            }
            IProfile revertProfile = FormerState.IUToProfile(profileSnapshot, profile, context, (IProgressMonitor)sub.newChild(6));
            ProfileChangeRequest profileChangeRequest = FormerState.generateProfileDeltaChangeRequest(profile, revertProfile);
            ProvisioningPlan provisioningPlan = this.getProvisioningPlan(profileChangeRequest, context, (IProgressMonitor)sub.newChild(6));
            return provisioningPlan;
        }
        catch (CoreException e) {
            ProvisioningPlan provisioningPlan = new ProvisioningPlan(e.getStatus());
            return provisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    public static IInstallableUnit[] findPlannerMarkedIUs(final IProfile profile) {
        Query markerQuery = new Query(){

            public boolean isMatch(Object candidate) {
                if (!(candidate instanceof IInstallableUnit)) {
                    return false;
                }
                IInstallableUnit iu = (IInstallableUnit)candidate;
                String marker = profile.getInstallableUnitProperty(iu, SimplePlanner.PLANNER_MARKER);
                if (marker != null && Boolean.valueOf(marker).booleanValue()) {
                    return true;
                }
                String inclusion = profile.getInstallableUnitProperty(iu, SimplePlanner.INCLUSION_RULES);
                return inclusion != null;
            }
        };
        Collector collector = profile.query(markerQuery, new Collector(), null);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IInstallableUnit[])collector.toArray((Class)clazz);
    }

    public static Dictionary createSelectionContext(Map properties) {
        Hashtable<String, String> result = new Hashtable<String, String>(properties);
        String environments = (String)properties.get("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return result;
        }
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            int i = entry.indexOf(61);
            String key = entry.substring(0, i).trim();
            String value = entry.substring(i + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    public static IInstallableUnit[] gatherAvailableInstallableUnits(IInstallableUnit[] additionalSource, URL[] repositories, ProvisioningContext context, IProgressMonitor monitor) {
        Class<?> clazz;
        HashMap<String, IInstallableUnit> resultsMap = new HashMap<String, IInstallableUnit>();
        if (additionalSource != null) {
            int i = 0;
            while (i < additionalSource.length) {
                String key = String.valueOf(additionalSource[i].getId()) + "_" + additionalSource[i].getVersion().toString();
                resultsMap.put(key, additionalSource[i]);
                ++i;
            }
        }
        if (context != null) {
            Iterator iter = context.getExtraIUs().iterator();
            while (iter.hasNext()) {
                IInstallableUnit iu = (IInstallableUnit)iter.next();
                String key = String.valueOf(iu.getId()) + '_' + iu.getVersion().toString();
                resultsMap.put(key, iu);
            }
        }
        if ((clazz = class$2) == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName());
        if (repositories == null) {
            repositories = repoMgr.getKnownRepositories(0);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 200));
        int i = 0;
        while (i < repositories.length) {
            try {
                IMetadataRepository repository = repoMgr.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                Collector matches = repository.query((Query)new InstallableUnitQuery(null, VersionRange.emptyRange), new Collector(), (IProgressMonitor)sub.newChild(100));
                Iterator it = matches.iterator();
                while (it.hasNext()) {
                    IInstallableUnit iu = (IInstallableUnit)it.next();
                    String key = String.valueOf(iu.getId()) + "_" + iu.getVersion().toString();
                    IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
                    if (currentIU != null && !SimplePlanner.hasHigherFidelity(iu, currentIU)) continue;
                    resultsMap.put(key, iu);
                }
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        Collection results = resultsMap.values();
        return results.toArray(new IInstallableUnit[results.size()]);
    }

    private static boolean hasHigherFidelity(IInstallableUnit iu, IInstallableUnit currentIU) {
        return Boolean.valueOf(currentIU.getProperty("org.eclipse.equinox.p2.partial.iu")) != false && Boolean.valueOf(iu.getProperty("org.eclipse.equinox.p2.partial.iu")) == false;
    }

    public ProvisioningPlan getProvisioningPlan(ProfileChangeRequest profileChangeRequest, ProvisioningContext context, IProgressMonitor monitor) {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)12);
        sub.setTaskName(Messages.Director_Task_Resolving_Dependencies);
        try {
            IProfile profile = profileChangeRequest.getProfile();
            IInstallableUnit[] allIUs = this.updatePlannerInfo(profileChangeRequest);
            URL[] metadataRepositories = context != null ? context.getMetadataRepositories() : null;
            Dictionary newSelectionContext = SimplePlanner.createSelectionContext(profileChangeRequest.getProfileProperties());
            ArrayList<IInstallableUnit> extraIUs = new ArrayList<IInstallableUnit>(Arrays.asList(profileChangeRequest.getAddedInstallableUnits()));
            extraIUs.addAll(Arrays.asList(profileChangeRequest.getRemovedInstallableUnits()));
            extraIUs.addAll(profile.available((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection());
            IInstallableUnit[] availableIUs = SimplePlanner.gatherAvailableInstallableUnits(extraIUs.toArray(new IInstallableUnit[extraIUs.size()]), metadataRepositories, context, (IProgressMonitor)sub.newChild(3));
            Slicer slicer = new Slicer(allIUs, availableIUs, newSelectionContext);
            IQueryable slice = slicer.slice(allIUs, monitor);
            if (slice == null) {
                ProvisioningPlan provisioningPlan = new ProvisioningPlan((IStatus)slicer.getStatus());
                return provisioningPlan;
            }
            Projector projector = new Projector(slice, newSelectionContext);
            projector.encode(allIUs, (IProgressMonitor)sub.newChild(3));
            IStatus s = projector.invokeSolver((IProgressMonitor)sub.newChild(3));
            if (s.getSeverity() == 4) {
                IStatus oldResolverStatus;
                sub.setTaskName(Messages.Planner_NoSolution);
                LogHelper.log((IStatus)s);
                if (!"true".equalsIgnoreCase(context == null ? null : context.getProperty("org.eclipse.equinox.p2.disable.error.reporting")) && !(oldResolverStatus = new NewDependencyExpander(allIUs, null, availableIUs, newSelectionContext, false).expand((IProgressMonitor)sub.newChild(3))).isOK()) {
                    s = oldResolverStatus;
                }
                ProvisioningPlan provisioningPlan = new ProvisioningPlan(s);
                return provisioningPlan;
            }
            if (Tracing.DEBUG && s.getSeverity() != 0) {
                LogHelper.log((IStatus)s);
            }
            s = Status.OK_STATUS;
            Collection newState = projector.extractSolution();
            newState.remove(allIUs[0]);
            ResolutionHelper newStateHelper = new ResolutionHelper(newSelectionContext, null);
            newState = newStateHelper.attachCUs(newState);
            ResolutionHelper oldStateHelper = new ResolutionHelper(SimplePlanner.createSelectionContext(profile.getProperties()), null);
            Collection oldState = oldStateHelper.attachCUs(profile.query((Query)InstallableUnitQuery.ANY, new Collector(), null).toCollection());
            ProvisioningPlan provisioningPlan = this.generateProvisioningPlan(s, oldState, newState, profileChangeRequest);
            return provisioningPlan;
        }
        finally {
            sub.done();
        }
    }

    private IInstallableUnit createIURepresentingTheProfile(ArrayList allRequirements) {
        MetadataFactory.InstallableUnitDescription iud = new MetadataFactory.InstallableUnitDescription();
        String time = Long.toString(System.currentTimeMillis());
        iud.setId(time);
        iud.setVersion(new Version(0, 0, 0, time));
        iud.setRequiredCapabilities(allRequirements.toArray(new RequiredCapability[allRequirements.size()]));
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)iud);
    }

    private IInstallableUnit[] updatePlannerInfo(ProfileChangeRequest profileChangeRequest) {
        int i;
        Collector previousMarkers = profileChangeRequest.getProfile().query((Query)new IUProfilePropertyQuery(profileChangeRequest.getProfile(), PLANNER_MARKER, Boolean.TRUE.toString()), new Collector(), null);
        Iterator iterator = previousMarkers.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator.next();
            profileChangeRequest.setInstallableUnitInclusionRules(iu, PlannerHelper.createStrictInclusionRule(iu));
            profileChangeRequest.removeInstallableUnitProfileProperty(iu, PLANNER_MARKER);
        }
        Collection includedIUs = profileChangeRequest.getProfile().query((Query)new IUProfilePropertyQuery(profileChangeRequest.getProfile(), INCLUSION_RULES, null), new Collector(), null).toCollection();
        HashSet alreadyInstalled = new HashSet(includedIUs);
        alreadyInstalled.addAll(previousMarkers.toCollection());
        IInstallableUnit[] added = profileChangeRequest.getAddedInstallableUnits();
        IInstallableUnit[] removed = profileChangeRequest.getRemovedInstallableUnits();
        Iterator iterator2 = profileChangeRequest.getInstallableUnitProfilePropertiesToRemove().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry object = iterator2.next();
            if (!((List)object.getValue()).contains(INCLUSION_RULES)) continue;
            profileChangeRequest.setInstallableUnitProfileProperty((IInstallableUnit)object.getKey(), INCLUSION_RULES, PlannerHelper.createStrictInclusionRule((IInstallableUnit)object.getKey()));
        }
        iterator2 = alreadyInstalled.iterator();
        block2: while (iterator2.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator2.next();
            i = 0;
            while (i < removed.length) {
                if (iu.equals(removed[i])) {
                    profileChangeRequest.removeInstallableUnitProfileProperty(removed[i], INCLUSION_RULES);
                    iterator2.remove();
                    continue block2;
                }
                ++i;
            }
        }
        ArrayList<RequiredCapability> gatheredRequirements = new ArrayList<RequiredCapability>();
        Map iuPropertiesToAdd = profileChangeRequest.getInstallableUnitProfilePropertiesToAdd();
        i = 0;
        while (i < added.length) {
            Map propertiesForIU = (Map)iuPropertiesToAdd.get(added[i]);
            RequiredCapability profileRequirement = null;
            if (propertiesForIU != null) {
                profileRequirement = this.createRequirement(added[i], (String)propertiesForIU.get(INCLUSION_RULES));
            }
            if (profileRequirement == null) {
                profileChangeRequest.setInstallableUnitProfileProperty(added[i], INCLUSION_RULES, PlannerHelper.createStrictInclusionRule(added[i]));
                profileRequirement = this.createStrictRequirement(added[i]);
            }
            gatheredRequirements.add(profileRequirement);
            ++i;
        }
        Iterator iterator3 = alreadyInstalled.iterator();
        while (iterator3.hasNext()) {
            IInstallableUnit iu = (IInstallableUnit)iterator3.next();
            Map propertiesForIU = (Map)iuPropertiesToAdd.get(iu);
            RequiredCapability profileRequirement = null;
            if (propertiesForIU != null) {
                profileRequirement = this.createRequirement(iu, (String)propertiesForIU.get(INCLUSION_RULES));
            }
            if (profileRequirement == null) {
                profileRequirement = this.createRequirement(iu, profileChangeRequest.getProfile().getInstallableUnitProperty(iu, INCLUSION_RULES));
            }
            gatheredRequirements.add(profileRequirement);
        }
        return new IInstallableUnit[]{this.createIURepresentingTheProfile(gatheredRequirements)};
    }

    private RequiredCapability createRequirement(IInstallableUnit iu, String rule) {
        if (rule == null) {
            return null;
        }
        if (rule.equals(PlannerHelper.createStrictInclusionRule(iu))) {
            return this.createStrictRequirement(iu);
        }
        if (rule.equals(PlannerHelper.createOptionalInclusionRule(iu))) {
            return this.createOptionalRequirement(iu);
        }
        return null;
    }

    private RequiredCapability createOptionalRequirement(IInstallableUnit iu) {
        return MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, (boolean)true, (boolean)false, (boolean)true);
    }

    private RequiredCapability createStrictRequirement(IInstallableUnit iu) {
        return MetadataFactory.createRequiredCapability((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)new VersionRange(iu.getVersion(), true, iu.getVersion(), true), null, (boolean)false, (boolean)false, (boolean)true);
    }

    public IInstallableUnit[] updatesFor(IInstallableUnit toUpdate, ProvisioningContext context, IProgressMonitor monitor) {
        HashMap<String, IInstallableUnit> resultsMap = new HashMap<String, IInstallableUnit>();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)ServiceHelper.getService((BundleContext)DirectorActivator.context, (String)clazz.getName());
        URL[] repositories = context.getMetadataRepositories();
        if (repositories == null) {
            repositories = repoMgr.getKnownRepositories(0);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(repositories.length * 200));
        int i = 0;
        while (i < repositories.length) {
            try {
                IMetadataRepository repository = repoMgr.loadRepository(repositories[i], (IProgressMonitor)sub.newChild(100));
                Collector matches = repository.query((Query)new UpdateQuery(toUpdate), new Collector(), (IProgressMonitor)sub.newChild(100));
                Iterator it = matches.iterator();
                while (it.hasNext()) {
                    IInstallableUnit iu = (IInstallableUnit)it.next();
                    String key = String.valueOf(iu.getId()) + "_" + iu.getVersion().toString();
                    IInstallableUnit currentIU = (IInstallableUnit)resultsMap.get(key);
                    if (currentIU != null && !SimplePlanner.hasHigherFidelity(iu, currentIU)) continue;
                    resultsMap.put(key, iu);
                }
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        sub.done();
        Collection results = resultsMap.values();
        return results.toArray(new IInstallableUnit[results.size()]);
    }
}

