/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.resolution;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.DirectorActivator;
import org.eclipse.equinox.internal.p2.director.Recommendation;
import org.eclipse.equinox.internal.p2.director.RecommendationDescriptor;
import org.eclipse.equinox.internal.p2.resolution.StateMetadataMap;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.ProvidedCapability;
import org.eclipse.equinox.internal.provisional.p2.metadata.RequiredCapability;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.GenericDescription;
import org.eclipse.osgi.service.resolver.GenericSpecification;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.InvalidSyntaxException;

public class Transformer {
    private static final byte IU_KIND = 0;
    private static final String IU_NAMESPACE = "iu.namespace";
    static long iuInternalId = 0L;
    private Dictionary context = null;
    private StateObjectFactory factory = null;
    private ArrayList iuCapabilities;
    private Map iuDependencies;
    private byte kind = 0;
    private BundleDescription result = null;
    private RecommendationDescriptor recommendations = null;

    public Transformer(StateObjectFactory factory) {
        this(factory, null, null);
    }

    public Transformer(StateObjectFactory factory, Dictionary context, RecommendationDescriptor recommendations) {
        this.factory = factory;
        this.context = context;
        this.recommendations = recommendations;
    }

    private String getNamespace() {
        switch (this.kind) {
            case 0: {
                return IU_NAMESPACE;
            }
        }
        throw new IllegalStateException("unknown kind");
    }

    public BundleDescription getResult() {
        return this.result;
    }

    private boolean isEnabled(RequiredCapability capability) {
        if (this.context == null) {
            return true;
        }
        String filter = capability.getFilter();
        if (filter == null) {
            return true;
        }
        try {
            return DirectorActivator.context.createFilter(filter).match(this.context);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return true;
        }
    }

    private String toFilter(VersionRange range) {
        if (range == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("(&");
        buf.append("(version>=").append(range.getMinimum().toString()).append(')');
        if (!range.getIncludeMinimum()) {
            buf.append("(!(version=").append(range.getMinimum().toString()).append("))");
        }
        buf.append("(version<=").append(range.getMaximum().toString()).append(')');
        if (!range.getIncludeMaximum()) {
            buf.append("(!(version=").append(range.getMaximum().toString()).append("))");
        }
        buf.append(')');
        return buf.toString();
    }

    public void visitCapability(ProvidedCapability capability) {
        this.iuCapabilities.add(this.factory.createGenericDescription(capability.getName(), capability.getNamespace(), capability.getVersion(), null));
    }

    public void visitInstallableUnit(IInstallableUnit toTransform) {
        this.kind = 0;
        RequiredCapability[] requires = toTransform.getRequiredCapabilities();
        this.iuDependencies = new HashMap(requires.length);
        int i = 0;
        while (i < requires.length) {
            this.visitRequiredCapability(requires[i]);
            ++i;
        }
        ProvidedCapability[] capabilities = toTransform.getProvidedCapabilities();
        this.iuCapabilities = new ArrayList(requires.length + 1);
        int i2 = 0;
        while (i2 < capabilities.length) {
            this.visitCapability(capabilities[i2]);
            ++i2;
        }
        this.iuCapabilities.add(this.factory.createGenericDescription(toTransform.getId(), this.getNamespace(), toTransform.getVersion(), null));
        GenericSpecification[] genericSpecifications = new GenericSpecification[this.iuDependencies.size()];
        this.iuDependencies.keySet().toArray(genericSpecifications);
        GenericDescription[] genericDescriptions = new GenericDescription[this.iuCapabilities.size()];
        this.iuCapabilities.toArray(genericDescriptions);
        this.result = this.factory.createBundleDescription(iuInternalId++, toTransform.getId(), toTransform.getVersion(), null, null, null, null, null, toTransform.isSingleton(), true, true, toTransform.getFilter(), null, genericSpecifications, genericDescriptions);
        this.result.setUserObject((Object)new StateMetadataMap(toTransform, this.iuDependencies));
    }

    public void visitRequiredCapability(RequiredCapability capability) {
        try {
            if (this.isEnabled(capability)) {
                capability = this.rewrite(capability);
                this.iuDependencies.put(this.factory.createGenericSpecification(capability.getName(), capability.getNamespace(), this.toFilter(capability.getRange()), capability.isOptional(), capability.isMultiple()), capability);
            }
        }
        catch (InvalidSyntaxException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.director", "Invalid filter: " + e.getFilter(), (Throwable)e));
        }
    }

    private RequiredCapability rewrite(RequiredCapability match) {
        if (this.recommendations == null) {
            return match;
        }
        Recommendation foundRecommendation = this.recommendations.findRecommendation(match);
        return foundRecommendation != null ? foundRecommendation.newValue() : match;
    }
}

