/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.internal.validation;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.core.IIncludePathAttribute;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.validation.JsValidator;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.internal.ConfigurationManager;
import org.eclipse.wst.validation.internal.ProjectConfiguration;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.Message;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;

public final class JsBatchValidator
implements IValidatorJob,
IExecutableExtension {
    static final boolean DEBUG = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jsvalidator"));
    private static final String PLUGIN_ID_JSP_CORE = "org.eclipse.wst.jsdt.web.core";
    private IPath[] excludeLibPaths;
    private static final String[] rhinoValidator = new String[]{"org.eclipse.atf.javascript.internal.validation.JSSyntaxValidator"};
    private IContentType[] fContentTypes = null;
    private IContentType fJSPFContentType = null;
    private JsValidator fJSPJavaValidator = new JsValidator((IValidator)this);
    static /* synthetic */ Class class$0;

    static {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int j = 0;
        while (j < projects.length) {
            IProject project = projects[j];
            if (project.isOpen()) {
                try {
                    if (project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
                        WorkbenchReporter.removeAllMessages((IResource)project, (String[])rhinoValidator, null);
                    }
                }
                catch (CoreException coreException) {}
            }
            ++j;
        }
    }

    private static ProjectConfiguration getProjectConfiguration(IFile file) {
        IProject project;
        ProjectConfiguration projectConfiguration = null;
        if (file != null && (project = file.getProject()) != null) {
            try {
                projectConfiguration = ConfigurationManager.getManager().getProjectConfiguration(project);
            }
            catch (InvocationTargetException e) {
                Logger.log(202, e.getMessage(), e);
            }
        }
        return projectConfiguration;
    }

    static boolean isBatchValidatorPreferenceEnabled(IFile file) {
        if (file == null) {
            return true;
        }
        boolean enabled = true;
        ProjectConfiguration configuration = JsBatchValidator.getProjectConfiguration(file);
        if (configuration != null) {
            ValidationRegistryReader validationRegistryReader = ValidationRegistryReader.getReader();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.web.core.internal.validation.JsBatchValidator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ValidatorMetaData metadata = validationRegistryReader.getValidatorMetaData(clazz.getName());
            if (configuration != null && metadata != null && !configuration.isBuildEnabled(metadata) && !configuration.isManualEnabled(metadata)) {
                enabled = false;
            }
        }
        return enabled;
    }

    public void cleanup(IReporter reporter) {
        this.fJSPJavaValidator.cleanup(reporter);
    }

    private IPath[] getLibraryPaths(IFile file) {
        if (this.excludeLibPaths != null) {
            return this.excludeLibPaths;
        }
        IProject project = file.getProject();
        IJavaScriptProject javaProject = JavaScriptCore.create((IProject)project);
        if (javaProject == null) {
            return new IPath[0];
        }
        IIncludePathEntry[] entries = new IIncludePathEntry[]{};
        try {
            entries = javaProject.getResolvedIncludepath(true);
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        ArrayList<IPath> ignorePaths = new ArrayList<IPath>();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 1) {
                IIncludePathAttribute[] attribs = entries[i].getExtraAttributes();
                int k = 0;
                while (attribs != null && k < attribs.length) {
                    if (attribs[k].getName().equalsIgnoreCase("validate") && attribs[k].getValue().equalsIgnoreCase("false")) {
                        ignorePaths.add(entries[i].getPath());
                        break;
                    }
                    ++k;
                }
            }
            ++i;
        }
        this.excludeLibPaths = ignorePaths.toArray(new Path[ignorePaths.size()]);
        return this.excludeLibPaths;
    }

    void doValidate(IValidationContext helper, IReporter reporter) throws ValidationException {
        block11: {
            JSPFileVisitor visitor;
            LocalizedMessage message;
            block9: {
                block10: {
                    String[] uris = helper.getURIs();
                    if (uris.length <= 0) break block10;
                    IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                    IFile currentFile = null;
                    int i = 0;
                    while (i < uris.length && !reporter.isCancelled()) {
                        currentFile = wsRoot.getFile((IPath)new Path(uris[i]));
                        if (currentFile != null && currentFile.exists()) {
                            if (this.shouldValidate(currentFile)) {
                                LocalizedMessage message2 = new LocalizedMessage(4, i + 1 + "/" + uris.length + " - " + currentFile.getFullPath().toString().substring(1));
                                reporter.displaySubtask((IValidator)this, (IMessage)message2);
                                reporter.removeAllMessages((IValidator)this, (Object)currentFile);
                                this.validateFile(currentFile, reporter);
                            }
                            if (DEBUG) {
                                System.out.println("validating: [" + uris[i] + "]");
                            }
                        }
                        ++i;
                    }
                    break block11;
                }
                if (!(helper instanceof IWorkbenchContext)) break block11;
                IProject project = ((IWorkbenchContext)helper).getProject();
                message = new LocalizedMessage(4, NLS.bind((String)JsCoreMessages.JSPBatchValidator_0, (Object)project.getFullPath()));
                reporter.displaySubtask((IValidator)this, (IMessage)message);
                visitor = new JSPFileVisitor(reporter);
                try {
                    project.accept((IResourceProxyVisitor)visitor, 2);
                }
                catch (CoreException e) {
                    if (!DEBUG) break block9;
                    e.printStackTrace();
                }
            }
            IFile[] files = visitor.getFiles();
            int i = 0;
            while (i < files.length && !reporter.isCancelled()) {
                if (this.shouldValidate(files[i])) {
                    message = new LocalizedMessage(4, i + 1 + "/" + files.length + " - " + files[i].getFullPath().toString().substring(1));
                    reporter.displaySubtask((IValidator)this, (IMessage)message);
                    this.validateFile(files[i], reporter);
                }
                if (DEBUG) {
                    System.out.println("validating: [" + files[i] + "]");
                }
                ++i;
            }
        }
    }

    public ISchedulingRule getSchedulingRule(IValidationContext helper) {
        if (helper instanceof IWorkbenchContext) {
            return ResourcesPlugin.getWorkspace().getRuleFactory().buildRule();
        }
        return null;
    }

    private void performValidation(IFile f, IReporter reporter, IStructuredModel model) {
        if (!reporter.isCancelled()) {
            this.fJSPJavaValidator.performValidation(f, reporter, model, true);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean shouldValidate(IFile file) {
        IFile resource = file;
        IPath[] libPaths = this.getLibraryPaths(file);
        IPath filePath = file.getFullPath().removeLastSegments(1);
        int i = 0;
        while (i < libPaths.length) {
            if (libPaths[i].isPrefixOf(filePath)) {
                return false;
            }
            ++i;
        }
        do {
            if (!resource.isDerived() && !resource.isTeamPrivateMember() && resource.isAccessible() && resource.getName().charAt(0) != '.') continue;
            return false;
        } while (((resource = resource.getParent()).getType() & 4) == 0);
        return true;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        this.doValidate(helper, reporter);
    }

    /*
     * Exception decompiling
     */
    void validateFile(IFile f, IReporter reporter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [4 : 99->103)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IStatus validateInJob(final IValidationContext helper, final IReporter reporter) throws ValidationException {
        Job currentJob = Platform.getJobManager().currentJob();
        ISchedulingRule rule = null;
        if (currentJob != null) {
            rule = currentJob.getRule();
        }
        IWorkspaceRunnable validationRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    JsBatchValidator.this.doValidate(helper, reporter);
                }
                catch (ValidationException e) {
                    throw new CoreException((IStatus)new Status(4, JsBatchValidator.PLUGIN_ID_JSP_CORE, 0, JsBatchValidator.PLUGIN_ID_JSP_CORE, (Throwable)e));
                }
            }
        };
        try {
            JavaScriptCore.run((IWorkspaceRunnable)validationRunnable, (ISchedulingRule)rule, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            if (e.getCause() instanceof ValidationException) {
                throw (ValidationException)e.getCause();
            }
            throw new ValidationException((IMessage)new LocalizedMessage(3, e.getMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private List fFiles = new ArrayList();
        private IReporter fReporter = null;

        public JSPFileVisitor(IReporter reporter) {
            this.fReporter = reporter;
        }

        final IFile[] getFiles() {
            return this.fFiles.toArray(new IFile[this.fFiles.size()]);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (this.fReporter.isCancelled()) {
                return false;
            }
            if (proxy.getType() == 1 && Util.isJsType(proxy.getName()) && proxy.isAccessible()) {
                IFile file = (IFile)proxy.requestResource();
                if (DEBUG) {
                    System.out.println("(+) JSPValidator adding file: " + file.getName());
                }
                this.fFiles.add(file);
                return false;
            }
            return true;
        }
    }

    class LocalizedMessage
    extends Message {
        private String _message = null;

        public LocalizedMessage(int severity, String messageText) {
            this(severity, messageText, null);
        }

        public LocalizedMessage(int severity, String messageText, IResource targetObject) {
            this(severity, messageText, (Object)targetObject);
        }

        public LocalizedMessage(int severity, String messageText, Object targetObject) {
            super(null, severity, null);
            this.setLocalizedMessage(messageText);
            this.setTargetObject(targetObject);
        }

        private String getLocalizedText() {
            return this._message;
        }

        public String getText() {
            return this.getLocalizedText();
        }

        public String getText(ClassLoader cl) {
            return this.getLocalizedText();
        }

        public String getText(Locale l) {
            return this.getLocalizedText();
        }

        public String getText(Locale l, ClassLoader cl) {
            return this.getLocalizedText();
        }

        public void setLocalizedMessage(String message) {
            this._message = message;
        }
    }
}

