/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.variables;

import com.ibm.icu.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.VariableValueEditorManager;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.variables.ChangeVariableValueInputDialog;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.actions.IVariableValueEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionProviderAction;

public class ChangeVariableValueAction
extends SelectionProviderAction {
    protected IVariable fVariable;
    private VariablesView fView;
    private boolean fEditing = false;

    public ChangeVariableValueAction(VariablesView view) {
        super((ISelectionProvider)view.getViewer(), ActionMessages.ChangeVariableValue_title);
        this.setDescription(ActionMessages.ChangeVariableValue_toolTipText);
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_CHANGE_VARIABLE_VALUE"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_CHANGE_VARIABLE_VALUE"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_CHANGE_VARIABLE_VALUE"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.change_value_action_context");
        this.fView = view;
    }

    protected void doActionPerformed(IVariable variable) {
        Shell shell = this.fView.getViewSite().getShell();
        if (this.fEditing) {
            return;
        }
        this.fEditing = true;
        this.fVariable = variable;
        if (!this.delegateEdit(shell)) {
            this.doDefaultEdit(shell);
        }
        this.fEditing = false;
    }

    private boolean delegateEdit(Shell shell) {
        String modelIdentifier = this.fVariable.getModelIdentifier();
        IVariableValueEditor editor = VariableValueEditorManager.getDefault().getVariableValueEditor(modelIdentifier);
        if (editor != null) {
            return editor.editVariable(this.fVariable, shell);
        }
        return false;
    }

    protected void doDefaultEdit(Shell shell) {
        String name = "";
        String value = "";
        try {
            name = this.fVariable.getName();
            value = this.fVariable.getValue().getValueString();
        }
        catch (DebugException exception) {
            DebugUIPlugin.errorDialog(shell, ActionMessages.ChangeVariableValue_errorDialogTitle, ActionMessages.ChangeVariableValue_errorDialogMessage, exception);
            return;
        }
        ChangeVariableValueInputDialog inputDialog = new ChangeVariableValueInputDialog(shell, ActionMessages.ChangeVariableValue_1, MessageFormat.format((String)ActionMessages.ChangeVariableValue_2, (Object[])new String[]{name}), value, new IInputValidator(){

            public String isValid(String input) {
                try {
                    if (ChangeVariableValueAction.this.fVariable.verifyValue(input)) {
                        return null;
                    }
                }
                catch (DebugException debugException) {
                    return ActionMessages.ChangeVariableValue_3;
                }
                return ActionMessages.ChangeVariableValue_4;
            }
        });
        inputDialog.open();
        String newValue = inputDialog.getValue();
        if (newValue != null) {
            try {
                this.fVariable.setValue(newValue);
                this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)this.fVariable));
            }
            catch (DebugException de) {
                DebugUIPlugin.errorDialog(shell, ActionMessages.ChangeVariableValue_errorDialogTitle, ActionMessages.ChangeVariableValue_errorDialogMessage, de);
            }
        }
    }

    protected void update(IStructuredSelection sel) {
        Object object;
        Iterator iter = sel.iterator();
        if (iter.hasNext() && (object = iter.next()) instanceof IValueModification) {
            IValueModification varMod = (IValueModification)object;
            if (!varMod.supportsValueModification()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(!iter.hasNext());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        this.doActionPerformed((IVariable)iterator.next());
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.update(sel);
    }
}

