/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.commands.actions;

import org.eclipse.debug.internal.ui.commands.actions.DebugCommandActionDelegate;
import org.eclipse.debug.internal.ui.commands.actions.DebugCommandService;
import org.eclipse.debug.internal.ui.commands.actions.ICommandParticipant;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public abstract class DebugCommandAction
extends Action
implements IDebugContextListener {
    private IWorkbenchWindow fWindow;
    private IWorkbenchPart fPart;
    private DebugCommandService fUpdateService;
    private DebugCommandActionDelegate fDelegate;

    public DebugCommandAction() {
        String helpContextId = this.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, helpContextId);
        }
        this.setEnabled(false);
    }

    public void setDelegate(DebugCommandActionDelegate delegate) {
        this.fDelegate = delegate;
    }

    protected boolean execute(Object[] targets) {
        return this.fUpdateService.executeCommand(this.getCommandType(), targets, this.getCommandParticipant(targets));
    }

    protected ICommandParticipant getCommandParticipant(Object[] targets) {
        return null;
    }

    protected abstract Class getCommandType();

    public void debugContextChanged(DebugContextEvent event) {
        this.fUpdateService.postUpdateCommand(this.getCommandType(), this);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.fDelegate != null) {
            this.fDelegate.setEnabled(enabled);
        }
    }

    public void init(IWorkbenchPart part) {
        this.fPart = part;
        this.fWindow = part.getSite().getWorkbenchWindow();
        this.fUpdateService = DebugCommandService.getService(this.fWindow);
        IDebugContextService service = this.getDebugContextService();
        String partId = part.getSite().getId();
        service.addDebugContextListener(this, partId);
        ISelection activeContext = service.getActiveContext(partId);
        if (activeContext != null) {
            this.fUpdateService.updateCommand(this.getCommandType(), (IAction)this);
        } else {
            this.setEnabled(this.getInitialEnablement());
        }
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fUpdateService = DebugCommandService.getService(this.fWindow);
        IDebugContextService contextService = this.getDebugContextService();
        contextService.addDebugContextListener(this);
        ISelection activeContext = contextService.getActiveContext();
        if (activeContext != null) {
            this.fUpdateService.updateCommand(this.getCommandType(), (IAction)this);
        } else {
            this.setEnabled(this.getInitialEnablement());
        }
    }

    protected boolean getInitialEnablement() {
        return false;
    }

    protected ISelection getContext() {
        if (this.fPart != null) {
            this.getDebugContextService().getActiveContext(this.fPart.getSite().getId());
        }
        return this.getDebugContextService().getActiveContext();
    }

    public void run() {
        ISelection selection = this.getContext();
        if (selection instanceof IStructuredSelection && this.isEnabled()) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            boolean enabled = this.execute(ss.toArray());
            this.setEnabled(enabled);
        }
    }

    public void runWithEvent(Event event) {
        this.run();
    }

    public void dispose() {
        IDebugContextService service = this.getDebugContextService();
        if (this.fPart != null) {
            service.removeDebugContextListener(this, this.fPart.getSite().getId());
        } else {
            service.removeDebugContextListener(this);
        }
        this.fWindow = null;
        this.fPart = null;
    }

    protected IDebugContextService getDebugContextService() {
        return DebugUITools.getDebugContextManager().getContextService(this.fWindow);
    }

    public abstract String getHelpContextId();

    public abstract String getId();

    public abstract String getText();

    public abstract String getToolTipText();

    public abstract ImageDescriptor getDisabledImageDescriptor();

    public abstract ImageDescriptor getHoverImageDescriptor();

    public abstract ImageDescriptor getImageDescriptor();

    protected DebugCommandActionDelegate getDelegate() {
        return this.fDelegate;
    }
}

