/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.LaunchConfigurationTabExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;

public class LaunchConfigurationTabGroupWrapper
implements ILaunchConfigurationTabGroup {
    private ILaunchConfigurationTabGroup fGroup = null;
    private String fGroupId = null;
    private List fTabs = null;
    private String fMode = null;
    private ILaunchConfiguration fConfig = null;

    public LaunchConfigurationTabGroupWrapper(ILaunchConfigurationTabGroup group, String groupId, ILaunchConfiguration config) {
        this.fGroup = group;
        this.fGroupId = groupId;
        this.fConfig = config;
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        if (this.fGroup != null) {
            this.fGroup.createTabs(dialog, mode);
            this.fMode = mode;
        }
    }

    public void dispose() {
        this.fGroup.dispose();
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.dispose();
                }
                ++i;
            }
            this.fTabs.clear();
        }
    }

    public ILaunchConfigurationTab[] getTabs() {
        if (this.fTabs == null) {
            try {
                this.fTabs = new ArrayList();
                this.fTabs.addAll(Arrays.asList(this.fGroup.getTabs()));
                LaunchConfigurationTabExtension[] ext = LaunchConfigurationPresentationManager.getDefault().getTabExtensions(this.fGroupId, this.fConfig, this.fMode);
                String id = null;
                int i = 0;
                while (i < ext.length) {
                    id = ext[i].getRelativeTabId();
                    if (id != null) {
                        int idx = this.indexofTab(id);
                        if (idx > -1) {
                            this.fTabs.add(idx + 1, ext[i].getTab());
                        } else {
                            this.fTabs.add(ext[i].getTab());
                        }
                    } else {
                        this.fTabs.add(ext[i].getTab());
                    }
                    ++i;
                }
            }
            catch (CoreException ce) {
                DebugUIPlugin.log(ce);
            }
        }
        return this.fTabs.toArray(new ILaunchConfigurationTab[this.fTabs.size()]);
    }

    private int indexofTab(String id) {
        if (id != null) {
            Object o = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                o = this.fTabs.get(i);
                if (o instanceof AbstractLaunchConfigurationTab && id.equals(((AbstractLaunchConfigurationTab)o).getId())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fGroup.initializeFrom(configuration);
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.initializeFrom(configuration);
                }
                ++i;
            }
        }
    }

    public void launched(ILaunch launch) {
        if (this.fGroup != null) {
            this.fGroup.launched(launch);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fGroup.performApply(configuration);
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.performApply(configuration);
                }
                ++i;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.fGroup.setDefaults(configuration);
        if (this.fTabs != null) {
            List<ILaunchConfigurationTab> tabs = Arrays.asList(this.fGroup.getTabs());
            ILaunchConfigurationTab tab = null;
            int i = 0;
            while (i < this.fTabs.size()) {
                tab = (ILaunchConfigurationTab)this.fTabs.get(i);
                if (!tabs.contains(tab)) {
                    tab.setDefaults(configuration);
                }
                ++i;
            }
        }
    }
}

