/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.actions.ActionMessages;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.dltk.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.corext.dom.NodeFinder;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenCallHierarchyAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;

    public OpenCallHierarchyAction(IWorkbenchSite site) {
        super(site);
        this.setText(CallHierarchyMessages.OpenCallHierarchyAction_label);
        this.setToolTipText(CallHierarchyMessages.OpenCallHierarchyAction_tooltip);
        this.setDescription(CallHierarchyMessages.OpenCallHierarchyAction_description);
    }

    public OpenCallHierarchyAction(IWorkbenchSite site, ISelectionProvider provider) {
        this(site);
        this.setSpecialSelectionProvider(provider);
    }

    public OpenCallHierarchyAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private boolean isEnabled(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return false;
        }
        Object input = selection.getFirstElement();
        if (!(input instanceof IModelElement) && input instanceof IAdaptable) {
            input = ((IAdaptable)input).getAdapter(IModelElement.class);
        }
        if (!(input instanceof IModelElement)) {
            return false;
        }
        switch (((IModelElement)input).getElementType()) {
            case 9: {
                return true;
            }
        }
        return false;
    }

    public void run(ITextSelection selection) {
        ISourceModule input = SelectionConverter.getInput(this.fEditor);
        if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)input)) {
            return;
        }
        try {
            IModelElement enclosingMethod;
            IModelElement[] elements = SelectionConverter.codeResolveOrInputForked(this.fEditor);
            if (elements == null) {
                return;
            }
            ArrayList<IModelElement> candidates = new ArrayList<IModelElement>(elements.length);
            int i = 0;
            while (i < elements.length) {
                IModelElement[] resolvedElements = CallHierarchyUI.getCandidates((Object)elements[i]);
                if (resolvedElements != null) {
                    candidates.addAll((Collection)Arrays.asList(resolvedElements));
                }
                ++i;
            }
            if (candidates.isEmpty() && (enclosingMethod = this.getEnclosingMethod((IModelElement)input, selection)) != null) {
                candidates.add(enclosingMethod);
            }
            this.run(candidates.toArray(new IModelElement[candidates.size()]));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)OpenCallHierarchyAction.getErrorDialogTitle(), (String)ActionMessages.SelectionConverter_codeResolve_failed);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IModelElement getEnclosingMethod(IModelElement input, ITextSelection selection) {
        IModelElement enclosingElement = null;
        try {
            switch (input.getElementType()) {
                case 5: {
                    ISourceModule cu = (ISourceModule)input.getAncestor(5);
                    if (cu == null) break;
                    enclosingElement = cu.getElementAt(selection.getOffset());
                }
            }
            if (enclosingElement != null && enclosingElement.getElementType() == 9) {
                return enclosingElement;
            }
        }
        catch (ModelException e) {
            DLTKUIPlugin.log((Throwable)e);
        }
        return null;
    }

    protected IModelElement getSelectionModelElement(int offset, int length, ISourceModule sourceModule) {
        IModelElement element = null;
        try {
            ASTNode selectedNode;
            Program ast = SharedASTProvider.getAST(sourceModule, SharedASTProvider.WAIT_NO, null);
            if (ast != null && (selectedNode = NodeFinder.perform((ASTNode)ast, offset, length)).getType() == 33) {
                element = ((Identifier)selectedNode).resolveBinding().getPHPElement();
            }
        }
        catch (Exception exception) {}
        if (element == null) {
            try {
                element = sourceModule.getElementAt(offset);
            }
            catch (ModelException modelException) {}
        }
        return element;
    }

    public void run(IStructuredSelection selection) {
        if (selection instanceof ITextSelection) {
            this.run((ITextSelection)selection);
        } else {
            if (selection.size() != 1) {
                return;
            }
            Object input = selection.getFirstElement();
            if (!(input instanceof IModelElement)) {
                IStatus status = OpenCallHierarchyAction.createStatus("A PHP element must be selected.");
                ErrorDialog.openError((Shell)this.getShell(), (String)OpenCallHierarchyAction.getErrorDialogTitle(), (String)CallHierarchyMessages.OpenCallHierarchyAction_messages_title, (IStatus)status);
                return;
            }
            ISourceModule sourceModule = (ISourceModule)input;
            String fileName = sourceModule.getElementName();
            IModelElement element = DLTKCore.create((IFile)ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)fileName)));
            if (element instanceof ISourceModule) {
                int offset = 0;
                try {
                    offset = sourceModule.getSourceRange().getOffset();
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
                IModelElement modelElement = this.getSelectionModelElement(offset, 1, (ISourceModule)element);
                if (modelElement != null) {
                    if (!ActionUtil.isProcessable((Shell)this.getShell(), (Object)modelElement)) {
                        return;
                    }
                    this.run(new IModelElement[]{modelElement});
                }
            }
        }
    }

    private int openErrorDialog(IStatus status) {
        String message = CallHierarchyMessages.OpenCallHierarchyAction_messages_title;
        String dialogTitle = OpenCallHierarchyAction.getErrorDialogTitle();
        return ErrorDialog.openError((Shell)this.getShell(), (String)dialogTitle, (String)message, (IStatus)status);
    }

    private static String getErrorDialogTitle() {
        return CallHierarchyMessages.OpenCallHierarchyAction_dialog_title;
    }

    public void run(IModelElement[] elements) {
        if (elements.length == 0) {
            this.getShell().getDisplay().beep();
            return;
        }
        CallHierarchyUI.open((IModelElement[])elements, (IWorkbenchWindow)this.getSite().getWorkbenchWindow(), (String)this.getCallHierarchyID());
    }

    private static IStatus compileCandidates(List result, IModelElement elem) {
        Status ok = new Status(0, DLTKUIPlugin.getPluginId(), 0, "", null);
        switch (elem.getElementType()) {
            case 9: {
                result.add(elem);
                return ok;
            }
        }
        return OpenCallHierarchyAction.createStatus(CallHierarchyMessages.OpenCallHierarchyAction_messages_no_valid_java_element);
    }

    private static IStatus createStatus(String message) {
        return new Status(1, DLTKUIPlugin.getPluginId(), 10001, message, null);
    }

    public String getCallHierarchyID() {
        return "org.eclipse.dltk.callhierarchy.view";
    }
}

