/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.completion.ScriptOverrideCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.php.core.codeassist.FakeGroupMethod;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.AutoActivationTrigger;

public class PHPOverrideCompletionProposal
extends ScriptOverrideCompletionProposal
implements ICompletionProposalExtension4 {
    public PHPOverrideCompletionProposal(IScriptProject jproject, ISourceModule cu, String methodName, String[] paramTypes, int start, int length, String displayName, String completionProposal) {
        super(jproject, cu, methodName, paramTypes, start, length, displayName, completionProposal);
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (this.getModelElement() instanceof FakeGroupMethod) {
            AutoActivationTrigger.register(document);
        }
        super.apply(document, trigger, offset);
        this.calculateCursorPosition(document, offset);
    }

    public boolean isAutoInsertable() {
        return PHPCorePlugin.getDefault().getPluginPreferences().getBoolean("contentAssistAutoinsert");
    }

    protected boolean insertCompletion() {
        Preferences pluginPreferences = PHPCorePlugin.getDefault().getPluginPreferences();
        return pluginPreferences.getBoolean("contentAssistInsertCompletion");
    }

    protected void calculateCursorPosition(IDocument document, int offset) {
        block9: {
            try {
                while (Character.isJavaIdentifierPart(document.getChar(offset))) {
                    ++offset;
                }
                if (document.getChar(offset) != '(') break block9;
                boolean hasArguments = false;
                IModelElement modelElement = this.getModelElement();
                if (modelElement.getElementType() == 9) {
                    IMethod method = (IMethod)modelElement;
                    try {
                        String[] parameters = method.getParameters();
                        if (parameters != null && parameters.length > 0) {
                            hasArguments = true;
                        }
                    }
                    catch (ModelException modelException) {}
                }
                if (!hasArguments) {
                    this.setCursorPosition(offset - this.getReplacementOffset() + 2);
                } else {
                    this.setCursorPosition(offset - this.getReplacementOffset() + 1);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public IContextInformation getContextInformation() {
        String displayString = this.getDisplayString();
        String infoDisplayString = displayString;
        int i = infoDisplayString.indexOf(40);
        if (i != -1) {
            infoDisplayString = infoDisplayString.substring(i + 1);
        }
        if ((i = infoDisplayString.indexOf(41)) != -1) {
            infoDisplayString = infoDisplayString.substring(0, i);
        }
        if (infoDisplayString.length() == 0) {
            return null;
        }
        return new ContextInformation(displayString, infoDisplayString);
    }

    protected boolean isCamelCaseMatching() {
        return true;
    }

    protected ScriptTextTools getTextTools() {
        return PHPUiPlugin.getDefault().getTextTools();
    }
}

