/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.core.IType;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Assignment;
import org.eclipse.php.internal.core.ast.nodes.Block;
import org.eclipse.php.internal.core.ast.nodes.ClassConstantDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FieldAccess;
import org.eclipse.php.internal.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.FunctionName;
import org.eclipse.php.internal.core.ast.nodes.ITypeBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodDeclaration;
import org.eclipse.php.internal.core.ast.nodes.MethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Statement;
import org.eclipse.php.internal.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.TypeDeclaration;
import org.eclipse.php.internal.core.ast.nodes.Variable;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.Messages;

public class ClassMembersOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "ClassMembersOccurrencesFinder";
    private String classMemberName;
    private String typeDeclarationName;
    private boolean isMethod;
    private IType dispatcherType;

    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.typeDeclarationName = null;
        this.isMethod = false;
        if (node.getType() == 33) {
            Identifier identifier = (Identifier)node;
            this.dispatcherType = this.resolveDispatcherType(identifier);
            this.classMemberName = identifier.getName();
            ASTNode parent = identifier.getParent();
            int type = parent.getType();
            this.isMethod = type == 29 || parent.getLocationInParent() == FunctionName.NAME_PROPERTY || parent.getLocationInParent() == FunctionInvocation.FUNCTION_PROPERTY;
            while (this.typeDeclarationName == null && parent != this.fASTRoot) {
                if (type == 12 || type == 40) {
                    this.typeDeclarationName = ((TypeDeclaration)parent).getName().getName();
                    break;
                }
                parent = parent.getParent();
                type = parent.getType();
            }
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    private IType resolveDispatcherType(Identifier identifier) {
        ITypeBinding typeBinding = null;
        ASTNode parent = identifier.getParent();
        if (parent.getType() == 60) {
            Variable var = (Variable)parent;
            ASTNode varParent = var.getParent();
            if (var.getParent().getType() == 0) {
                varParent = varParent.getParent();
            }
            if (varParent.getType() == 24) {
                typeBinding = ((FieldAccess)varParent).getDispatcher().resolveTypeBinding();
            } else if (varParent.getType() == 31) {
                FunctionInvocation fi;
                FunctionName fn = (FunctionName)varParent;
                if (fn.getParent().getType() == 30 && (fi = (FunctionInvocation)fn.getParent()).getParent().getType() == 43) {
                    typeBinding = ((MethodInvocation)fi.getParent()).getDispatcher().resolveTypeBinding();
                }
            } else if (varParent.getType() == 63) {
                return this.resolveDeclaringClassType(var.getParent());
            }
        } else if (parent.getType() == 10) {
            StaticConstantAccess sca = (StaticConstantAccess)parent;
            typeBinding = sca.getClassName().resolveTypeBinding();
        } else if (parent.getType() == 52) {
            StaticFieldAccess sfa = (StaticFieldAccess)parent;
            typeBinding = sfa.getClassName().resolveTypeBinding();
        } else {
            if (parent.getType() == 42) {
                MethodDeclaration md = (MethodDeclaration)parent;
                return this.resolveDeclaringClassType((ASTNode)md);
            }
            if (parent.getType() == 29) {
                FunctionDeclaration fd = (FunctionDeclaration)parent;
                return this.resolveDeclaringClassType((ASTNode)fd);
            }
            if (parent.getType() == 11) {
                ClassConstantDeclaration ccd = (ClassConstantDeclaration)parent;
                return this.resolveDeclaringClassType((ASTNode)ccd);
            }
        }
        if (typeBinding != null && typeBinding.isClass()) {
            return (IType)typeBinding.getPHPElement();
        }
        return null;
    }

    protected IType resolveDeclaringClassType(ASTNode node) {
        ASTNode parent = node.getParent();
        ClassDeclaration declaration = null;
        while (declaration == null && parent != null) {
            if (parent.getType() == 12) {
                declaration = (ClassDeclaration)parent;
            }
            parent = parent.getParent();
        }
        if (declaration != null) {
            try {
                return declaration.getProgramRoot().getSourceModule().getType(declaration.getName().getName());
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return null;
    }

    protected void findOccurrences() {
        this.fDescription = this.isMethod ? Messages.format(BASE_DESCRIPTION, String.valueOf(this.classMemberName) + "()") : Messages.format(BASE_DESCRIPTION, this.classMemberName);
        this.fASTRoot.accept((Visitor)this);
    }

    public boolean visit(ClassDeclaration classDeclaration) {
        this.checkTypeDeclaration((TypeDeclaration)classDeclaration);
        return false;
    }

    public boolean visit(InterfaceDeclaration interfaceDeclaration) {
        this.checkTypeDeclaration((TypeDeclaration)interfaceDeclaration);
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        if (this.isMethod) {
            this.checkDispatch((ASTNode)methodInvocation.getMethod().getFunctionName().getName());
        }
        return super.visit(methodInvocation);
    }

    public boolean visit(FieldAccess fieldAccess) {
        if (!this.isMethod) {
            this.checkDispatch((ASTNode)fieldAccess.getField().getName());
        }
        return super.visit(fieldAccess);
    }

    public boolean visit(StaticConstantAccess classConstantAccess) {
        Identifier constant = classConstantAccess.getConstant();
        if (this.classMemberName.equals(constant.getName())) {
            if (this.dispatcherType != null) {
                if (this.dispatcherType.equals(this.resolveDispatcherType(constant))) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(constant.getStart(), constant.getLength(), this.getOccurrenceType((ASTNode)constant), this.fDescription));
                }
            } else {
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(constant.getStart(), constant.getLength(), this.getOccurrenceType((ASTNode)constant), this.fDescription));
            }
        }
        return true;
    }

    public boolean visit(StaticMethodInvocation methodInvocation) {
        if (this.isMethod) {
            this.checkDispatch((ASTNode)methodInvocation.getMethod().getFunctionName().getName());
        }
        return super.visit(methodInvocation);
    }

    public boolean visit(StaticFieldAccess fieldAccess) {
        if (!this.isMethod) {
            this.checkDispatch((ASTNode)fieldAccess.getField().getName());
        }
        return super.visit(fieldAccess);
    }

    private void checkDispatch(ASTNode node) {
        Identifier id;
        if (node.getType() == 33 && (id = (Identifier)node).getName().equalsIgnoreCase(this.classMemberName)) {
            if (this.dispatcherType != null) {
                if (this.dispatcherType.equals(this.resolveDispatcherType(id))) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(node), this.fDescription));
                }
            } else {
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), this.getOccurrenceType(node), this.fDescription));
            }
        }
        if (node.getType() == 60) {
            id = (Variable)node;
            this.checkDispatch((ASTNode)id.getName());
        }
    }

    private void checkTypeDeclaration(TypeDeclaration typeDeclaration) {
        assert (typeDeclaration != null);
        Block body = typeDeclaration.getBody();
        List statements = body.statements();
        for (Statement statement : statements) {
            Object variableNames;
            FieldsDeclaration classVariableDeclaration;
            if (statement.getType() == 42) {
                Identifier functionName;
                MethodDeclaration classMethodDeclaration = (MethodDeclaration)statement;
                if (!this.isMethod || !this.classMemberName.equalsIgnoreCase((functionName = classMethodDeclaration.getFunction().getFunctionName()).getName())) continue;
                if (this.dispatcherType != null) {
                    if (!this.dispatcherType.equals(this.resolveDispatcherType(functionName))) continue;
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType((ASTNode)functionName), this.fDescription));
                    continue;
                }
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType((ASTNode)functionName), this.fDescription));
                continue;
            }
            if (statement.getType() == 25) {
                if (this.isMethod) continue;
                classVariableDeclaration = (FieldsDeclaration)statement;
                variableNames = classVariableDeclaration.getVariableNames();
                int j = 0;
                while (j < ((Object)variableNames).length) {
                    assert (variableNames[j].getName().getType() == 33);
                    Identifier variable = (Identifier)variableNames[j].getName();
                    if (this.classMemberName.equals(variable.getName())) {
                        if (this.dispatcherType != null) {
                            if (this.dispatcherType.equals(this.resolveDispatcherType(variable))) {
                                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(variable.getStart() - 1, variable.getLength() + 1, 1, this.fDescription));
                            }
                        } else {
                            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(variable.getStart() - 1, variable.getLength() + 1, 1, this.fDescription));
                        }
                    }
                    ++j;
                }
                continue;
            }
            if (statement.getType() != 11) continue;
            classVariableDeclaration = (ClassConstantDeclaration)statement;
            variableNames = classVariableDeclaration.names();
            Iterator iterator = variableNames.iterator();
            while (iterator.hasNext()) {
                Identifier name = (Identifier)iterator.next();
                if (!this.classMemberName.equals(name.getName())) continue;
                if (this.dispatcherType != null) {
                    if (!this.dispatcherType.equals(this.resolveDispatcherType(name))) continue;
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), this.getOccurrenceType((ASTNode)name), this.fDescription));
                    continue;
                }
                this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), this.getOccurrenceType((ASTNode)name), this.fDescription));
            }
        }
        body.accept((Visitor)this);
    }

    protected int getOccurrenceType(ASTNode node) {
        if (node.getParent().getType() == 11 || this.isInAssignment(node)) {
            return 1;
        }
        return 2;
    }

    protected boolean isInAssignment(ASTNode node) {
        FieldAccess fAccess;
        Variable var;
        return node.getParent().getType() == 60 && (var = (Variable)node.getParent()).getParent().getType() == 24 && (fAccess = (FieldAccess)var.getParent()).getLocationInParent() == Assignment.LEFT_HAND_SIDE_PROPERTY;
    }

    public String getElementName() {
        return this.classMemberName;
    }

    public String getID() {
        return ID;
    }
}

