/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.Messages;

public class FunctionOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "FunctionOccurrencesFinder";
    private String functionName;

    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        if (node.getType() == 33) {
            this.functionName = ((Identifier)node).getName();
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    protected void findOccurrences() {
        this.fDescription = Messages.format(BASE_DESCRIPTION, String.valueOf(this.functionName) + "()");
        this.fASTRoot.accept((Visitor)this);
    }

    public boolean visit(FunctionDeclaration functionDeclaration) {
        Identifier name;
        ASTNode parent = functionDeclaration.getParent();
        while (parent.getType() == 6 || parent.getType() == 29) {
            parent = parent.getParent();
        }
        if (parent.getType() != 42 && this.functionName.equalsIgnoreCase((name = functionDeclaration.getFunctionName()).getName())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(name.getStart(), name.getLength(), this.getOccurrenceType((ASTNode)name), this.fDescription));
        }
        return true;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        Identifier identifier;
        Expression functionName = functionInvocation.getFunctionName().getName();
        int invocationParent = functionInvocation.getParent().getType();
        if (functionName.getType() == 33 && invocationParent != 43 && invocationParent != 53 && this.functionName.equalsIgnoreCase((identifier = (Identifier)functionName).getName())) {
            this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(functionName.getStart(), functionName.getLength(), this.getOccurrenceType((ASTNode)functionName), this.fDescription));
        }
        return true;
    }

    protected int getOccurrenceType(ASTNode node) {
        return 2;
    }

    public String getElementName() {
        return this.functionName;
    }

    public String getID() {
        return ID;
    }
}

