/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.AbstractSourceModule;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.ASTNodes;
import org.eclipse.php.internal.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.internal.core.ast.nodes.ClassName;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.FormalParameter;
import org.eclipse.php.internal.core.ast.nodes.FunctionInvocation;
import org.eclipse.php.internal.core.ast.nodes.IBinding;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.internal.core.ast.nodes.StructuralPropertyDescriptor;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.ui.search.IOccurrencesFinder;
import org.eclipse.php.internal.ui.search.Messages;

public class IncludeOccurrencesFinder
extends AbstractOccurrencesFinder {
    private static final String INCLUDE_POINT_OF = PHPUIMessages.getString("IncludeOccurrencesFinder.0");
    public static final String ID = "RequireFinder";
    private IModelElement source;
    private IBinding binding;
    private Include includeNode;
    private IType[] types;
    private IMethod[] methods;

    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        this.includeNode = this.getIncludeExpression(node);
        if (this.includeNode != null) {
            this.binding = this.includeNode.resolveBinding();
            this.source = this.binding.getPHPElement();
            if (this.source != null) {
                AbstractSourceModule module = (AbstractSourceModule)this.source;
                try {
                    this.types = module.getTypes();
                    this.methods = module.getMethods();
                    return null;
                }
                catch (ModelException modelException) {
                    this.fDescription = "MethodExitsFinder_occurrence_exit_description";
                    return this.fDescription;
                }
            }
        }
        this.fDescription = "MethodExitsFinder_occurrence_exit_description";
        return this.fDescription;
    }

    private final Include getIncludeExpression(ASTNode node) {
        boolean isInclude;
        boolean bl = isInclude = node != null && node.getType() == 36;
        if (isInclude) {
            return (Include)node;
        }
        ASTNode parent = ASTNodes.getParent((ASTNode)node, Include.class);
        return parent != null && parent.getType() == 36 ? (Include)parent : null;
    }

    protected void findOccurrences() {
        this.fDescription = Messages.format(INCLUDE_POINT_OF, this.source.getElementName());
        this.getASTRoot().accept((Visitor)this);
        int offset = this.includeNode.getStart();
        int length = this.includeNode.getLength();
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(offset, length, this.getOccurrenceType(null), this.fDescription));
    }

    protected int getOccurrenceType(ASTNode node) {
        return 5;
    }

    public String getElementName() {
        return this.binding.getName();
    }

    public String getID() {
        return ID;
    }

    public String getJobLabel() {
        return "RncludeFinder_job_label";
    }

    public int getSearchKind() {
        return 7;
    }

    public String getUnformattedPluralLabel() {
        return "IncludeFinder_label_plural";
    }

    public String getUnformattedSingularLabel() {
        return "IncludeFinder_label_singular";
    }

    public boolean visit(ClassName className) {
        Expression className2 = className.getName();
        if (className2.getType() == 33) {
            Identifier id = (Identifier)className2;
            String name = id.getName();
            IType[] iTypeArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (type.getElementName().equals(name)) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(className.getStart(), className.getLength(), this.getOccurrenceType(null), this.fDescription));
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean visit(Identifier className) {
        StructuralPropertyDescriptor location = className.getLocationInParent();
        if (location == ClassDeclaration.SUPER_CLASS_PROPERTY || location == ClassDeclaration.INTERFACES_PROPERTY || location == StaticMethodInvocation.CLASS_NAME_PROPERTY || location == FormalParameter.PARAMETER_TYPE_PROPERTY) {
            String name = className.getName();
            IType[] iTypeArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                if (type.getElementName().equals(name)) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(className.getStart(), className.getLength(), this.getOccurrenceType(null), this.fDescription));
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean visit(FunctionInvocation functionInvocation) {
        Expression functionName2 = functionInvocation.getFunctionName().getName();
        if (functionName2.getType() == 33) {
            Identifier id = (Identifier)functionName2;
            String name = id.getName();
            IMethod[] iMethodArray = this.methods;
            int n = this.methods.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(name)) {
                    this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(functionInvocation.getStart(), functionInvocation.getLength(), this.getOccurrenceType(null), this.fDescription));
                }
                ++n2;
            }
        }
        return true;
    }
}

