/*******************************************************************************
 * Copyright (c) 2005, 2007 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
package lib.org.eclipse.php.test.bare.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import junit.framework.TestCase;

import org.eclipse.php.test.infra.util.FilterLinefeedInputStream;

/**
 * Description: Filter Line feed chars from input stream  
 * @author Assaf Almaz, 2006
 */
public class TestFilterLinefeedInputStream extends TestCase {

	public void testRead() throws IOException {
		String str = "baba \n kuku \r\n lala \r";
		ByteArrayInputStream content = new ByteArrayInputStream(str.getBytes());
		FilterLinefeedInputStream is = new FilterLinefeedInputStream(content);

		int length = 0;

		while (is.read() != -1) {
			length++;
		}

		// only the '\r' that is part of '\n\r' should be filtered out
		assertEquals(str.length() - 1, length);
	}
}
