/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.breakpoint;

import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.breakpoint.provider.PHPBreakpointProvider;
import org.eclipse.ui.texteditor.IMarkerUpdater;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    public String[] getAttribute() {
        return new String[]{"lineNumber", "message"};
    }

    public String getMarkerType() {
        return "org.eclipse.php.debug.core.PHPConditionalBreakpointMarker";
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        block4: {
            int newLine;
            block5: {
                if (position.isDeleted()) {
                    return false;
                }
                newLine = document.getLineOfOffset(position.offset) + 1;
                int offset = PHPBreakpointProvider.getValidPosition(document, newLine);
                if (offset == -1) break block4;
                newLine = document.getLineOfOffset(offset) + 1;
                marker.setAttribute("message", (Object)MessageFormat.format(PHPDebugCoreMessages.LineBreakPointMessage_1, marker.getResource().getName(), newLine));
                if (marker.getAttribute("lineNumber", -1) != newLine) break block5;
                return true;
            }
            try {
                marker.setAttribute("lineNumber", newLine);
                return true;
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return false;
    }
}

