/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.StateSetEnumerator;

public final class StateSet {
    private final boolean DEBUG = false;
    public static final StateSet EMPTY = new StateSet();
    static final int BITS = 6;
    static final int MASK = 63;
    long[] bits;

    public StateSet() {
        this.bits = new long[4];
    }

    public StateSet(int n) {
        this();
        this.addState(n);
    }

    public StateSet(StateSet stateSet) {
        this.bits = new long[stateSet.bits.length];
        System.arraycopy(stateSet.bits, 0, this.bits, 0, stateSet.bits.length);
    }

    public void addState(int n) {
        this.resize(n);
        int n2 = n >> 6;
        this.bits[n2] = this.bits[n2] | 1L << (n & 0x3F);
    }

    private int nbits2size(int n) {
        return (n >> 6) + 1;
    }

    private void resize(int n) {
        int n2 = this.nbits2size(n);
        if (n2 < this.bits.length) {
            return;
        }
        long[] lArray = new long[Math.max(this.bits.length * 2, n2)];
        System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
        this.bits = lArray;
    }

    public void clear() {
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            this.bits[n2] = 0L;
            ++n2;
        }
    }

    public boolean isElement(int n) {
        int n2 = n >> 6;
        if (n2 >= this.bits.length) {
            return false;
        }
        return (this.bits[n2] & 1L << (n & 0x3F)) != 0L;
    }

    public int getAndRemoveElement() {
        int n = 0;
        int n2 = 0;
        long l = 1L;
        while (this.bits[n] == 0L) {
            ++n;
        }
        while ((this.bits[n] & l) == 0L) {
            l <<= 1;
            ++n2;
        }
        int n3 = n;
        this.bits[n3] = this.bits[n3] & (l ^ 0xFFFFFFFFFFFFFFFFL);
        return (n << 6) + n2;
    }

    public void remove(int n) {
        this.resize(n);
        int n2 = n >> 6;
        this.bits[n2] = this.bits[n2] & (1L << (n & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public StateSet complement(StateSet stateSet) {
        if (stateSet == null) {
            return null;
        }
        StateSet stateSet2 = new StateSet();
        stateSet2.bits = new long[stateSet.bits.length];
        int n = Math.min(this.bits.length, stateSet.bits.length);
        int n2 = 0;
        while (n2 < n) {
            stateSet2.bits[n2] = (this.bits[n2] ^ 0xFFFFFFFFFFFFFFFFL) & stateSet.bits[n2];
            ++n2;
        }
        if (this.bits.length < stateSet.bits.length) {
            System.arraycopy(stateSet.bits, n, stateSet2.bits, n, stateSet2.bits.length - n);
        }
        return stateSet2;
    }

    public boolean add(StateSet stateSet) {
        if (stateSet == null) {
            return false;
        }
        if (this.bits.length < stateSet.bits.length) {
            long[] lArray = new long[stateSet.bits.length];
            System.arraycopy(this.bits, 0, lArray, 0, this.bits.length);
            this.bits = lArray;
        }
        boolean bl = false;
        int n = 0;
        while (n < stateSet.bits.length) {
            long l = this.bits[n] | stateSet.bits[n];
            if (l != this.bits[n]) {
                bl = true;
            }
            this.bits[n] = l;
            ++n;
        }
        return bl;
    }

    public boolean containsSet(StateSet stateSet) {
        int n = Math.min(this.bits.length, stateSet.bits.length);
        int n2 = 0;
        while (n2 < n) {
            if ((this.bits[n2] & stateSet.bits[n2]) != stateSet.bits[n2]) {
                return false;
            }
            ++n2;
        }
        n2 = n;
        while (n2 < stateSet.bits.length) {
            if (stateSet.bits[n2] != 0L) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object var1_1) {
        block6: {
            var2_2 = 0;
            var5_3 = (StateSet)var1_1;
            var3_4 = this.bits.length;
            var4_5 = var5_3.bits.length;
            if (var3_4 > var4_5) ** GOTO lbl18
            while (var2_2 < var3_4) {
                if (this.bits[var2_2] != var5_3.bits[var2_2]) {
                    return false;
                }
                ++var2_2;
            }
            while (var2_2 < var4_5) {
                if (var5_3.bits[var2_2++] == 0L) continue;
                return false;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                if (this.bits[var2_2] != var5_3.bits[var2_2]) {
                    return false;
                }
                ++var2_2;
lbl18:
                // 2 sources

                ** while (var2_2 < var4_5)
            }
lbl19:
            // 2 sources

            while (var2_2 < var3_4) {
                if (this.bits[var2_2++] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (--n >= 0) {
            l ^= this.bits[n] * (long)n;
        }
        return (int)(l >> 32 ^ l);
    }

    public StateSetEnumerator states() {
        return new StateSetEnumerator(this);
    }

    public boolean containsElements() {
        int n = 0;
        while (n < this.bits.length) {
            if (this.bits[n] != 0L) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public StateSet copy() {
        StateSet stateSet = new StateSet();
        stateSet.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, stateSet.bits, 0, this.bits.length);
        return stateSet;
    }

    public String toString() {
        StateSetEnumerator stateSetEnumerator = this.states();
        StringBuffer stringBuffer = new StringBuffer("{");
        if (stateSetEnumerator.hasMoreElements()) {
            stringBuffer.append(String.valueOf(stateSetEnumerator.nextElement()));
        }
        while (stateSetEnumerator.hasMoreElements()) {
            int n = stateSetEnumerator.nextElement();
            stringBuffer.append(", " + n);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

