/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.model;

import java.io.UnsupportedEncodingException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpVariable;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleByteArrayValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleIntValue;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.SimpleVariable;
import org.w3c.dom.Node;

public class DBGpStringValue
extends DBGpValue {
    private boolean complete = false;
    private int requiredBytes;
    private IVariable[] stringInfo = null;

    public DBGpStringValue(DBGpVariable owningVariable, Node property, int strByteLen) {
        super(owningVariable);
        this.setModifiable(true);
        this.simpleParseNode(property);
        int actualLength = this.getValueBytes().length;
        this.complete = actualLength >= strByteLen;
        this.requiredBytes = strByteLen;
    }

    public String getReferenceTypeName() throws DebugException {
        return "string";
    }

    void genValueString(String data) {
        this.stringInfo = null;
        if (data != null && data.trim().length() > 0) {
            this.setValueString(data);
        } else {
            this.setValueString("");
            this.setValueBytes(new byte[0]);
        }
    }

    public void setValue(String expression) throws DebugException {
        byte[] newBytes;
        this.stringInfo = null;
        if (expression != null) {
            this.setValueString(expression.trim());
        } else {
            this.setValueString("<Invalid>");
        }
        try {
            newBytes = expression.getBytes(((DBGpTarget)this.getDebugTarget()).getBinaryEncoding());
        }
        catch (UnsupportedEncodingException e) {
            DBGpLogger.logException("unexpected encoding problem", (Object)this, e);
            newBytes = expression.getBytes();
        }
        this.setValueBytes(newBytes);
        this.requiredBytes = newBytes.length;
    }

    boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public int getRequiredBytes() {
        return this.requiredBytes;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.stringInfo == null) {
            int arrayLength = this.getValueBytes().length;
            this.stringInfo = SimpleByteArrayValue.createVariables(this.getValueBytes(), 0, arrayLength, 1, this.getDebugTarget());
            SimpleIntValue iv = new SimpleIntValue(arrayLength, this.getRequiredBytes(), this.getDebugTarget());
            this.stringInfo[0] = new SimpleVariable("length", iv, this.getDebugTarget());
        }
        return this.stringInfo;
    }

    public boolean hasVariables() throws DebugException {
        return true;
    }
}

