/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.debugger.handlers;

import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.debug.core.debugger.handlers.IDebugMessageHandler;
import org.eclipse.php.debug.core.debugger.messages.IDebugMessage;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.pathmapper.PathEntry;
import org.eclipse.php.internal.debug.core.pathmapper.VirtualPath;
import org.eclipse.php.internal.debug.core.zend.debugger.Breakpoint;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.ContinueProcessFileNotification;
import org.eclipse.php.internal.debug.core.zend.debugger.messages.StartProcessFileNotification;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;

public class StartProcessFileNotificationHandler
implements IDebugMessageHandler {
    protected boolean isFirstFileToDebug = true;

    public void handle(IDebugMessage message, PHPDebugTarget debugTarget) {
        StartProcessFileNotification notification = (StartProcessFileNotification)message;
        String remoteFileName = notification.getFileName();
        this.prepareForProcessing(remoteFileName, debugTarget);
        RemoteDebugger remoteDebugger = (RemoteDebugger)debugTarget.getRemoteDebugger();
        remoteDebugger.sendCustomNotification(new ContinueProcessFileNotification());
    }

    protected void prepareForProcessing(String remoteFileName, PHPDebugTarget debugTarget) {
        RemoteDebugger remoteDebugger = (RemoteDebugger)debugTarget.getRemoteDebugger();
        ILaunchConfiguration launchConfiguration = debugTarget.getLaunch().getLaunchConfiguration();
        remoteDebugger.removeCWDCache();
        debugTarget.setLastFileName(remoteFileName);
        boolean isWebServerDebugger = Boolean.toString(true).equals(debugTarget.getLaunch().getAttribute("webServerDebugger"));
        String debugType = "";
        try {
            debugType = launchConfiguration.getAttribute("php_debug_type", "");
        }
        catch (CoreException e) {
            PHPDebugPlugin.log(e);
        }
        String localPath = null;
        if (this.isFirstFileToDebug) {
            if (isWebServerDebugger) {
                PathEntry pathEntry = debugTarget.mapFirstDebugFile(remoteFileName);
                localPath = pathEntry != null ? pathEntry.getResolvedPath() : remoteFileName;
                if (debugType.equals("php_web_script_debug")) {
                    VirtualPath remotePath = new VirtualPath(remoteFileName);
                    remotePath.removeLastSegment();
                    remoteDebugger.setCurrentWorkingDirectory(remotePath.toString());
                }
            } else {
                try {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)remoteFileName));
                    if (file != null) {
                        localPath = file.getFullPath().toString();
                    }
                }
                catch (Exception exception) {}
                if (localPath == null) {
                    localPath = remoteFileName;
                }
            }
        } else {
            localPath = remoteDebugger.convertToLocalFilename(remoteFileName);
        }
        if (localPath != null && "debug".equals(debugTarget.getLaunch().getLaunchMode())) {
            IBreakpoint[] breakPoints;
            IBreakpoint[] iBreakpointArray = breakPoints = this.findBreakpoints(localPath, debugTarget);
            int n = breakPoints.length;
            int n2 = 0;
            while (n2 < n) {
                IBreakpoint bp = iBreakpointArray[n2];
                try {
                    if (bp.isEnabled()) {
                        PHPConditionalBreakpoint phpBP = (PHPConditionalBreakpoint)bp;
                        Breakpoint runtimeBreakpoint = phpBP.getRuntimeBreakpoint();
                        int lineNumber = (Integer)bp.getMarker().getAttribute("lineNumber");
                        int bpID = runtimeBreakpoint.getID();
                        int bpType = runtimeBreakpoint.getType();
                        int bpLifeTime = runtimeBreakpoint.getLifeTime();
                        Breakpoint bpToSend = new Breakpoint(remoteFileName, lineNumber);
                        bpToSend.setID(bpID);
                        bpToSend.setType(bpType);
                        bpToSend.setLifeTime(bpLifeTime);
                        debugTarget.getRemoteDebugger().addBreakpoint(bpToSend);
                        runtimeBreakpoint.setID(bpToSend.getID());
                    }
                }
                catch (CoreException e) {
                    PHPDebugPlugin.log(e);
                }
                ++n2;
            }
        }
        this.isFirstFileToDebug = false;
    }

    protected IBreakpoint[] findBreakpoints(String localPath, PHPDebugTarget debugTarget) {
        IBreakpointManager breakpointManager = debugTarget.getBreakpointManager();
        if (!breakpointManager.isEnabled()) {
            return new IBreakpoint[0];
        }
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints("org.eclipse.php.debug.core");
        LinkedList<IBreakpoint> l = new LinkedList<IBreakpoint>();
        IBreakpoint[] iBreakpointArray = breakpoints;
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IBreakpoint bp = iBreakpointArray[n2];
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(localPath);
            if (bp.getMarker().getResource().equals((Object)resource)) {
                l.add(bp);
            }
            try {
                Object secondaryId = bp.getMarker().getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
                if (secondaryId != null && new VirtualPath(localPath).equals(new VirtualPath((String)secondaryId))) {
                    l.add(bp);
                }
            }
            catch (CoreException e) {
                PHPDebugPlugin.log(e);
            }
            ++n2;
        }
        return l.toArray(new IBreakpoint[l.size()]);
    }
}

