/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.zend.model;

import java.util.StringTokenizer;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.php.internal.debug.core.model.PHPDebugElement;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpression;
import org.eclipse.php.internal.debug.core.zend.debugger.DefaultExpressionsManager;
import org.eclipse.php.internal.debug.core.zend.debugger.Expression;
import org.eclipse.php.internal.debug.core.zend.debugger.ExpressionValue;
import org.eclipse.php.internal.debug.core.zend.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.zend.model.PHPVariable;

public class PHPValue
extends PHPDebugElement
implements IValue {
    private ExpressionValue fValue;
    private boolean fHasChildren = false;
    private IVariable[] fChildren = new IVariable[0];
    private Expression fVariable;
    private boolean fGlobal;
    private String[] types = new String[]{"NULL", "INT", "STRING", "BOOLEAN", "DOUBLE", "ARRAY", "OBJECT", "RESOURCE"};

    public PHPValue(PHPDebugTarget target, Expression var) {
        super(target);
        this.fValue = var.getValue();
        this.fVariable = var;
        this.fGlobal = false;
        this.processChildren(this.fValue);
    }

    public PHPValue(PHPDebugTarget target, Expression var, boolean global) {
        super(target);
        this.fValue = var.getValue();
        this.fVariable = var;
        this.fGlobal = global;
        this.processChildren(this.fValue);
    }

    public String getReferenceTypeName() throws DebugException {
        return this.types[this.fValue.getType()];
    }

    public String getValueString() throws DebugException {
        StringBuffer string = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(this.fValue.getValueAsString(), "\\", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.length() > 1) {
                string.append(token);
                continue;
            }
            string.append(token);
            if (!tokenizer.hasMoreTokens()) continue;
            tokenizer.nextToken();
        }
        String rString = string.toString();
        return rString;
    }

    public String getValue() throws DebugException {
        return (String)this.fValue.getValue();
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (this.fChildren.length == 0) {
            PHPDebugTarget debugTarget = (PHPDebugTarget)this.getDebugTarget();
            DefaultExpressionsManager expressionManager = debugTarget.getExpressionManager();
            Expression var = this.fVariable;
            if (this.fGlobal) {
                String exp = "$GLOBALS[\"" + this.fVariable.getFullName().substring(1) + "\"]";
                var = new DefaultExpression(exp);
            }
            expressionManager.update(var, 1);
            this.fValue = var.getValue();
            this.processChildren(this.fValue);
        }
        return this.fChildren;
    }

    public boolean hasVariables() throws DebugException {
        return this.fHasChildren;
    }

    public void updateValue(ExpressionValue value) {
        this.fValue = value;
        this.processChildren(this.fValue);
    }

    public boolean isPrimative() {
        return this.fValue.isPrimitive();
    }

    private void processChildren(ExpressionValue value) {
        Expression[] eChildren = value.getChildren();
        if (eChildren == null) {
            return;
        }
        if (eChildren.length == 0) {
            this.fHasChildren = true;
            this.fChildren = new IVariable[0];
            return;
        }
        this.fHasChildren = true;
        this.fChildren = new PHPVariable[eChildren.length];
        int i = 0;
        while (i < eChildren.length) {
            this.fChildren[i] = new PHPVariable((PHPDebugTarget)this.getDebugTarget(), eChildren[i], this.fGlobal);
            ++i;
        }
    }

    public boolean equals(Object obj) {
        return this.equals(obj, 5);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean equals(Object obj, int recurseDepth) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PHPValue)) {
            return false;
        }
        PHPValue otherValue = (PHPValue)((Object)obj);
        boolean otherValueNull = otherValue.fValue.getValue() == null;
        if (!this.fVariable.getFullName().equals(otherValue.fVariable.getFullName())) return false;
        if (!otherValueNull) {
            if (!this.fValue.getValueAsString().equals(otherValue.fValue.getValueAsString())) return false;
        }
        if (!this.fHasChildren) {
            if (!otherValue.fHasChildren) return true;
            return false;
        }
        if (this.fChildren.length == 0) {
            try {
                this.getVariables();
            }
            catch (DebugException debugException) {}
        }
        if (otherValue.fChildren.length == 0) {
            try {
                otherValue.getVariables();
            }
            catch (DebugException debugException) {}
        }
        if (this.fChildren.length != otherValue.fChildren.length) {
            return false;
        }
        if (recurseDepth <= 0) {
            return true;
        }
        try {
            int i = 0;
            while (true) {
                if (i >= this.fChildren.length) {
                    return true;
                }
                IVariable myChild = this.fChildren[i];
                IVariable otherChild = otherValue.fChildren[i];
                if (!((PHPValue)myChild.getValue()).equals(otherChild.getValue(), --recurseDepth)) {
                    return false;
                }
                ++i;
            }
        }
        catch (DebugException debugException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }
}

