/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.autoEdit.IAfterNewLineAutoEditStrategy;
import org.eclipse.php.internal.ui.text.PHPDocumentRegionEdgeMatcher;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.parser.ContextRegionContainer;

public class PairCurlyBracketAutoEditStrategy
implements IAfterNewLineAutoEditStrategy {
    private static final char CURLY_OPEN = '{';
    private static final char CURLY_CLOSE = '}';
    private static PHPDocumentRegionEdgeMatcher matcher = new PHPDocumentRegionEdgeMatcher();
    private final CurlyCloseIndentationStrategy curlyCloseIndentationStrategy = new CurlyCloseIndentationStrategy();

    private ITextRegion getPhpToken(IStructuredDocumentRegion sdRegion, int offset) {
        try {
            ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
            int regionStart = sdRegion.getStartOffset(tRegion);
            if (tRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)tRegion;
                tRegion = container.getRegionAtCharacterOffset(offset);
                regionStart += tRegion.getStart();
            }
            if (tRegion instanceof IPhpScriptRegion) {
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                tRegion = scriptRegion.getPhpToken(offset - regionStart);
                return tRegion;
            }
        }
        catch (BadLocationException badLocationException) {}
        return null;
    }

    public int autoEditAfterNewLine(IStructuredDocument document, DocumentCommand command, StringBuffer buffer) {
        try {
            int offset = command.offset;
            int rvPosition = offset + buffer.length();
            rvPosition += this.copyRestOfLine(document, command, buffer);
            boolean addCurlyClose = false;
            int curlyCloseCounter = 0;
            int currOffset = offset;
            IStructuredDocumentRegion sdRegion = document.getRegionAtCharacterOffset(currOffset);
            int regionStart = sdRegion.getStart();
            String text = sdRegion.getFullText();
            ITextRegion tRegion = null;
            int indexInText = text.length() - 1;
            while (indexInText >= 0) {
                char currChar = text.charAt(indexInText);
                if (currChar == '}') {
                    tRegion = this.getPhpToken(sdRegion, regionStart + indexInText);
                    if (tRegion == null || tRegion.getType() == "PHP_CURLY_CLOSE") {
                        ++curlyCloseCounter;
                    }
                } else if (currChar == '{') {
                    tRegion = this.getPhpToken(sdRegion, regionStart + indexInText);
                    if (tRegion == null || tRegion.getType() != "PHP_CURLY_OPEN") {
                        --indexInText;
                        continue;
                    }
                    if (--curlyCloseCounter < 0) {
                        if (matcher.match((IDocument)document, regionStart + indexInText + 1) == null) {
                            addCurlyClose = true;
                            break;
                        }
                        ++curlyCloseCounter;
                    }
                }
                --indexInText;
            }
            if (addCurlyClose) {
                this.addCurlyCloseBracket(document, command, buffer);
            }
            return rvPosition;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
            return -1;
        }
    }

    private int copyRestOfLine(IStructuredDocument document, DocumentCommand command, StringBuffer buffer) throws BadLocationException {
        int documentLength = document.getLength();
        if (command.offset + command.length == documentLength) {
            return 0;
        }
        int offset = command.offset;
        IRegion lineInfo = document.getLineInformationOfOffset(offset);
        int endOffset = lineInfo.getOffset() + lineInfo.getLength();
        int whiteSpacesAdded = 0;
        int lengthToCopyDown = endOffset - offset;
        IStructuredDocumentRegion[] structuredDocumentRegions = document.getStructuredDocumentRegions(offset, lengthToCopyDown);
        if (structuredDocumentRegions != null && structuredDocumentRegions.length > 0) {
            int absolutOffset;
            ITextRegion regionAtCharacterOffset;
            IStructuredDocumentRegion structuredDocumentRegion = structuredDocumentRegions[0];
            ITextRegion firstRegion = structuredDocumentRegion.getFirstRegion();
            ITextRegion lastRegion = structuredDocumentRegion.getLastRegion();
            int xmlRelativeOffset = 0;
            if (!(firstRegion instanceof ContextRegion) && (regionAtCharacterOffset = structuredDocumentRegion.getRegionAtCharacterOffset(offset)) instanceof ContextRegionContainer) {
                ContextRegionContainer phpContext = (ContextRegionContainer)regionAtCharacterOffset;
                lastRegion = phpContext.getLastRegion();
                firstRegion = phpContext.getFirstRegion();
                xmlRelativeOffset = firstRegion.getLength();
            }
            if ((absolutOffset = lastRegion.getStart() + structuredDocumentRegion.getStartOffset() + xmlRelativeOffset) <= endOffset) {
                lengthToCopyDown = absolutOffset - offset;
            }
        }
        String lineEnd = document.get(offset, lengthToCopyDown);
        int i = 0;
        while (i < lineEnd.length()) {
            char c = lineEnd.charAt(i);
            --lengthToCopyDown;
            if (c == '\n' || c == '\r' || !Character.isWhitespace(c)) {
                command.length += i;
                ++lengthToCopyDown;
                break;
            }
            ++i;
        }
        String trimmedLineEnd = lineEnd.trim();
        if (trimmedLineEnd.length() > 0 && trimmedLineEnd.charAt(0) == '}') {
            int indentationSize = FormatPreferencesSupport.getInstance().getIndentationSize((IDocument)document);
            char indentationChar = FormatPreferencesSupport.getInstance().getIndentationChar((IDocument)document);
            int i2 = 0;
            while (i2 < indentationSize) {
                buffer.append(indentationChar);
                ++whiteSpacesAdded;
                ++i2;
            }
            buffer.append(document.getLineDelimiter());
            String blanks = FormatterUtils.getLineBlanks((IStructuredDocument)document, (IRegion)lineInfo);
            buffer.append(blanks);
        }
        char nextChar = document.getChar(offset += command.length);
        while (lengthToCopyDown > 0) {
            buffer.append(nextChar);
            ++command.length;
            if (++offset == documentLength) break;
            nextChar = document.getChar(offset);
            --lengthToCopyDown;
        }
        return whiteSpacesAdded;
    }

    private void addCurlyCloseBracket(IStructuredDocument document, DocumentCommand command, StringBuffer buffer) {
        buffer.append(document.getLineDelimiter());
        int lineIndex = document.getLineOfOffset(command.offset);
        try {
            IRegion lineInfo = document.getLineInformation(lineIndex);
            this.curlyCloseIndentationStrategy.placeMatchingBlanks(document, buffer, lineIndex, lineInfo.getOffset() + lineInfo.getLength());
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        buffer.append('}');
    }
}

