/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.contentassist;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.ui.text.ScriptTextTools;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.php.core.codeassist.FakeGroupType;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.contentassist.AutoActivationTrigger;
import org.eclipse.swt.graphics.Image;

public class PHPCompletionProposal
extends ScriptCompletionProposal {
    public PHPCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
    }

    public PHPCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance, boolean indoc) {
        super(replacementString, replacementOffset, replacementLength, image, displayString, relevance, indoc);
    }

    protected boolean isSmartTrigger(char trigger) {
        return trigger == '$';
    }

    public void apply(IDocument document, char trigger, int offset) {
        if (this.getModelElement() instanceof FakeGroupType) {
            AutoActivationTrigger.register(document);
        }
        super.apply(document, trigger, offset);
        this.setCursorPosition(this.calcCursorPosition());
    }

    private int calcCursorPosition() {
        String replacementString = this.getReplacementString();
        int i = replacementString.lastIndexOf(40);
        if (i != -1) {
            return i + 1;
        }
        i = replacementString.lastIndexOf(39);
        if (i != -1) {
            return i;
        }
        i = replacementString.lastIndexOf(34);
        if (i != -1) {
            return i;
        }
        return replacementString.length();
    }

    public IContextInformation getContextInformation() {
        String displayString = this.getDisplayString();
        if (displayString.indexOf(40) == -1) {
            return null;
        }
        return super.getContextInformation();
    }

    protected boolean isCamelCaseMatching() {
        return true;
    }

    protected boolean insertCompletion() {
        Preferences pluginPreferences = PHPCorePlugin.getDefault().getPluginPreferences();
        return pluginPreferences.getBoolean("contentAssistInsertCompletion");
    }

    protected ScriptTextTools getTextTools() {
        return PHPUiPlugin.getDefault().getTextTools();
    }
}

