/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerLabelProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

public class PHPExplorerLabelProvider
extends ScriptExplorerLabelProvider {
    public PHPExplorerLabelProvider(ScriptExplorerContentProvider cp, IPreferenceStore store) {
        super(cp, store);
        super.setIsFlatLayout(false);
    }

    public void setIsFlatLayout(boolean state) {
        super.setIsFlatLayout(false);
    }

    public Image getImage(Object element) {
        IModelElement modelElement = null;
        if (element instanceof ExternalProjectFragment) {
            return PHPPluginImages.get("org.eclipse.php.ui.library_obj.gif");
        }
        if (element instanceof IncludePath) {
            Object entry = ((IncludePath)element).getEntry();
            if (entry instanceof IBuildpathEntry) {
                if (((IBuildpathEntry)entry).getEntryKind() == 2) {
                    return PHPPluginImages.get("org.eclipse.php.ui.php_project_obj.gif");
                }
                if (((IBuildpathEntry)entry).getEntryKind() == 1) {
                    return PHPPluginImages.get("org.eclipse.php.ui.library_obj.gif");
                }
            }
            if (entry instanceof ExternalProjectFragment) {
                return PHPPluginImages.get("org.eclipse.php.ui.library_obj.gif");
            }
            if (entry instanceof IFolder) {
                IModelElement createdScriptFolder = DLTKCore.create((IResource)((IFolder)entry));
                if (createdScriptFolder == null) {
                    return this.getImage(entry);
                }
                return this.getImage(createdScriptFolder);
            }
            if (entry instanceof IResource) {
                return this.getImage((IResource)entry);
            }
            return null;
        }
        if (element instanceof IResource) {
            modelElement = DLTKCore.create((IResource)((IResource)element));
        } else if (element instanceof IModelElement) {
            modelElement = (IModelElement)element;
        }
        if (modelElement != null) {
            IScriptProject project = modelElement.getScriptProject();
            if (!project.isOnBuildpath(modelElement)) {
                if (modelElement.getElementType() == 5) {
                    return PHPPluginImages.get("org.eclipse.php.ui.php_resource_obj.gif");
                }
                if (modelElement.getElementType() == 3 || modelElement.getElementType() == 4) {
                    return PHPPluginImages.get("org.eclipse.php.ui.folder_opened.gif");
                }
            } else if (modelElement.getElementType() == 4 || element instanceof IFolder) {
                return PHPPluginImages.get("org.eclipse.php.ui.folderroot_obj.gif");
            }
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof ExternalProjectFragment) {
            return ((ExternalProjectFragment)element).toStringWithAncestors();
        }
        if (element instanceof IncludePath) {
            Object entry = ((IncludePath)element).getEntry();
            if (entry instanceof IBuildpathEntry) {
                if (((IBuildpathEntry)entry).getEntryKind() == 2) {
                    return ((IBuildpathEntry)entry).getPath().lastSegment();
                }
                IPath localPath = EnvironmentPathUtils.getLocalPath((IPath)((IBuildpathEntry)entry).getPath());
                return localPath.toOSString();
            }
            if (entry instanceof ExternalProjectFragment) {
                return ((ExternalProjectFragment)entry).toStringWithAncestors();
            }
            if (entry instanceof IResource) {
                return ((IResource)entry).getFullPath().toString().substring(1);
            }
            return null;
        }
        return super.getText(element);
    }
}

