/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.projectoutlineview;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchEngine;
import org.eclipse.php.internal.core.mixin.PHPMixinModel;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.projectoutlineview.ProjectOutlineContentProvider;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ProjectOutlineGroups {
    GROUP_CLASSES(PHPPluginImages.DESC_OBJ_PHP_CLASSES_GROUP.createImage(), PHPUIMessages.getString("PHPProjectOutline.nodes.classes")),
    GROUP_CONSTANTS(PHPPluginImages.DESC_OBJ_PHP_CONSTANTS_GROUP.createImage(), PHPUIMessages.getString("PHPProjectOutline.nodes.constants")),
    GROUP_FUNCTIONS(PHPPluginImages.DESC_OBJ_PHP_FUNCTIONS_GROUP.createImage(), PHPUIMessages.getString("PHPProjectOutline.nodes.functions"));

    private static final String ASTRIX_STRING = "*";
    private final Image image;
    private final String text;
    protected static final Object[] NO_CHILDREN;

    static {
        NO_CHILDREN = new Object[0];
    }

    private ProjectOutlineGroups(Image image, String text) {
        this.image = image;
        this.text = text;
    }

    public Image getImage() {
        return this.image;
    }

    public String getText() {
        return this.text;
    }

    protected Object[] getChildren() {
        if (ProjectOutlineContentProvider.scripProject != null) {
            ArrayList<IProjectFragment> projectFragments = new ArrayList<IProjectFragment>();
            try {
                IProjectFragment[] iProjectFragmentArray = ProjectOutlineContentProvider.scripProject.getProjectFragments();
                int n = iProjectFragmentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProjectFragment projectFragment = iProjectFragmentArray[n2];
                    if (projectFragment != null && !projectFragment.isExternal()) {
                        projectFragments.add(projectFragment);
                    }
                    ++n2;
                }
            }
            catch (ModelException e) {
                Logger.logException(e);
            }
            PHPMixinModel mixinModel = PHPMixinModel.getInstance((IScriptProject)ProjectOutlineContentProvider.scripProject);
            TreeSet<IModelElement> childrenList = new TreeSet<IModelElement>(new Comparator<IModelElement>(){

                @Override
                public int compare(IModelElement o1, IModelElement o2) {
                    if (o1.getElementName().compareTo(o2.getElementName()) != 0) {
                        return (String.valueOf(o1.getPath().toOSString()) + o1.getElementName()).compareTo(String.valueOf(o2.getPath().toOSString()) + o2.getElementName());
                    }
                    return 0;
                }
            });
            for (IProjectFragment projectFragment : projectFragments) {
                IDLTKSearchScope scope = SearchEngine.createSearchScope((IModelElement)projectFragment);
                IModelElement[] children = null;
                switch (this) {
                    case GROUP_CLASSES: {
                        children = mixinModel.getType(ASTRIX_STRING, scope);
                        break;
                    }
                    case GROUP_FUNCTIONS: {
                        children = mixinModel.getFunction(ASTRIX_STRING, scope);
                        break;
                    }
                    case GROUP_CONSTANTS: {
                        children = mixinModel.getConstant(ASTRIX_STRING, null, scope);
                    }
                }
                childrenList.addAll((Collection<IModelElement>)Arrays.asList(children));
            }
            return childrenList.toArray();
        }
        return NO_CHILDREN;
    }

    public boolean hasChildren() {
        Object[] children = this.getChildren();
        return children != null && children.length != 0;
    }
}

