/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.externalchecker.ui;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.dltk.ui.environment.EnvironmentPathBlock;
import org.eclipse.dltk.ui.environment.IEnvironmentPathBlockListener;
import org.eclipse.dltk.validators.internal.externalchecker.core.ExternalChecker;
import org.eclipse.dltk.validators.internal.externalchecker.core.Rule;
import org.eclipse.dltk.validators.internal.externalchecker.ui.IRulesListViewer;
import org.eclipse.dltk.validators.internal.externalchecker.ui.Messages;
import org.eclipse.dltk.validators.internal.externalchecker.ui.RuleCelllModifier;
import org.eclipse.dltk.validators.internal.externalchecker.ui.RulesLabelProvider;
import org.eclipse.dltk.validators.internal.externalchecker.ui.RulesList;
import org.eclipse.dltk.validators.ui.ValidatorConfigurationPage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ExternalCheckerConfigurationPage
extends ValidatorConfigurationPage {
    private StringDialogField fArguments;
    private EnvironmentPathBlock fPath;
    private StringDialogField fExtensions;
    private Table fTable;
    private TableViewer tableViewer;
    private Button addRule;
    private Button delRule;
    private RulesList rulesList = new RulesList();
    private String message = "";
    private int messageType = 0;
    private final String TYPES = "TYPES";
    private String[] columnNames = new String[]{"RULES", "TYPES"};

    public RulesList getRulesList() {
        return this.rulesList;
    }

    public IStatus getStatus() {
        return new Status(this.messageType, "org.eclipse.dltk.validators.externalchecker", this.message);
    }

    private void resetMessage() {
        this.message = "";
        this.messageType = 0;
    }

    private void setMessage(IEnvironment env, String message, int type) {
        String pattern = Messages.ValidatorMessages_path_msgPattern;
        message = MessageFormat.format(pattern, env.getName(), message);
        this.setMessage(message, type);
    }

    private void setMessage(String message, int type) {
        if (type > this.messageType) {
            this.message = message;
            this.messageType = type;
        }
    }

    protected void validateTclCheckerPath() {
        Map envs = this.fPath.getPaths();
        Iterator it = envs.keySet().iterator();
        while (it.hasNext()) {
            IEnvironment env = (IEnvironment)it.next();
            String txtPath = envs.get(env).toString();
            if ("".equals(txtPath = txtPath.trim())) continue;
            IPath path = Path.fromPortableString((String)txtPath);
            IFileHandle file = env.getFile(path);
            if (file == null) {
                this.setMessage(env, Messages.ValidatorMessages_path_isinvalid, 4);
                continue;
            }
            if (!file.isFile()) {
                this.setMessage(env, Messages.ValidatorMessages_path_notexists, 4);
                continue;
            }
            if (file.exists()) continue;
            this.setMessage(env, Messages.ValidatorMessages_path_notexists, 4);
        }
    }

    protected void validate() {
        this.resetMessage();
        this.validateTclCheckerPath();
        this.updateStatus();
    }

    public void applyChanges() {
        ExternalChecker externalChecker = this.getExtrenalChecker();
        externalChecker.setArguments(this.fArguments.getText());
        externalChecker.setCommand(this.fPath.getPaths());
        externalChecker.setRules(this.rulesList.getRules());
        externalChecker.setExtensions(this.fExtensions.getText());
    }

    private void createPathBrowse(Composite parent, int columns) {
        this.fPath = new EnvironmentPathBlock();
        this.fPath.createControl(parent, columns);
        this.fPath.addListener(new IEnvironmentPathBlockListener(){

            public void valueChanged(Map paths) {
                ExternalCheckerConfigurationPage.this.validate();
            }
        });
    }

    public void createControl(Composite ancestor, int columns) {
        this.createFields();
        this.createPathBrowse(ancestor, columns);
        this.fArguments.doFillIntoGrid(ancestor, columns);
        this.fExtensions.doFillIntoGrid(ancestor, columns);
        Label label = new Label(ancestor, 64);
        label.setText(Messages.ExternalCheckerConfigurationPage_commaSeparatedListOfExtensions);
        GridData data = new GridData(4, 4, false, false);
        data.horizontalSpan = columns;
        data.minimumWidth = 100;
        data.widthHint = 100;
        label.setLayoutData((Object)data);
        this.rulesList.getRules().clear();
        Group group = new Group(ancestor, 0);
        group.setText(Messages.ExternalCheckerConfigurationPage_patternRules);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = columns;
        group.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        label = new Label(ancestor, 64);
        label.setText(Messages.ExternalCheckerConfigurationPage_patternIsARegularExpression);
        data = new GridData(4, 4, false, false);
        data.horizontalSpan = columns;
        data.minimumWidth = 100;
        data.widthHint = 100;
        label.setLayoutData((Object)data);
        this.fTable = new Table((Composite)group, 101124);
        data = new GridData(4, 4, true, true);
        data.widthHint = 300;
        data.heightHint = 100;
        this.fTable.setLayoutData((Object)data);
        this.fTable.setLinesVisible(true);
        this.fTable.setHeaderVisible(true);
        TableColumn col1 = new TableColumn(this.fTable, 16384, 0);
        col1.setWidth(200);
        col1.setText(Messages.ExternalCheckerConfigurationPage_outputRule);
        TableColumn col2 = new TableColumn(this.fTable, 16384, 1);
        col2.setWidth(100);
        col2.setText(Messages.ExternalCheckerConfigurationPage_type);
        this.tableViewer = new TableViewer(this.fTable);
        this.tableViewer.setColumnProperties(this.columnNames);
        CellEditor[] editors = new CellEditor[this.columnNames.length];
        TextCellEditor textEditor = new TextCellEditor((Composite)this.fTable);
        ((Text)textEditor.getControl()).setTextLimit(60);
        editors[0] = textEditor;
        ComboBoxCellEditor comboEditor = new ComboBoxCellEditor((Composite)this.fTable, this.rulesList.getTypes(), 8);
        editors[1] = comboEditor;
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier((ICellModifier)new RuleCelllModifier(this));
        this.tableViewer.setContentProvider((IContentProvider)new RulesContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new RulesLabelProvider());
        this.tableViewer.setInput((Object)this.rulesList);
        Composite buttons = new Composite((Composite)group, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        data = new GridData(4, 0, false, false);
        data.verticalAlignment = 128;
        this.addRule = new Button(buttons, 8);
        this.addRule.setLayoutData((Object)data);
        this.addRule.setText(Messages.ExternalCheckerConfigurationPage_addRule);
        this.addRule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ExternalCheckerConfigurationPage.this.rulesList.addRule();
            }
        });
        this.delRule = new Button(buttons, 8);
        this.delRule.setLayoutData((Object)data);
        this.delRule.setText(Messages.ExternalCheckerConfigurationPage_deleteRule);
        this.delRule.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                Rule rule = (Rule)((IStructuredSelection)ExternalCheckerConfigurationPage.this.tableViewer.getSelection()).getFirstElement();
                if (rule != null) {
                    ExternalCheckerConfigurationPage.this.rulesList.removeRule(rule);
                }
            }
        });
        this.updateValuesFrom();
    }

    private ExternalChecker getExtrenalChecker() {
        return (ExternalChecker)this.getValidator();
    }

    private void updateValuesFrom() {
        ExternalChecker externalChecker = this.getExtrenalChecker();
        this.fArguments.setText(externalChecker.getArguments());
        this.fPath.setPaths(externalChecker.getCommand());
        this.fExtensions.setText(externalChecker.getExtensions());
        this.rulesList.getRules().clear();
        int i = 0;
        while (i < externalChecker.getNRules()) {
            Rule r = externalChecker.getRule(i);
            this.rulesList.addRule(r);
            ++i;
        }
    }

    private void createFields() {
        this.fArguments = new StringDialogField();
        this.fArguments.setLabelText(Messages.ExternalCheckerConfigurationPage_CheckerArguments);
        this.fExtensions = new StringDialogField();
        this.fExtensions.setLabelText(Messages.ExternalCheckerConfigurationPage_filenameExtensions);
    }

    public List getColumnNames() {
        return Arrays.asList(this.columnNames);
    }

    public String[] getChoices(String property) {
        if ("TYPES".equals(property)) {
            return this.rulesList.getTypes();
        }
        return new String[0];
    }

    public class RulesContentProvider
    implements IStructuredContentProvider,
    IRulesListViewer {
        public Object[] getElements(Object inputElement) {
            return ExternalCheckerConfigurationPage.this.rulesList.getRules().toArray();
        }

        public void dispose() {
            ExternalCheckerConfigurationPage.this.rulesList.removeChangeListener(this);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput != null) {
                ((RulesList)newInput).addChangeListener(this);
            }
            if (oldInput != null) {
                ((RulesList)oldInput).removeChangeListener(this);
            }
        }

        public void addRule(Rule r) {
            ExternalCheckerConfigurationPage.this.tableViewer.add((Object)r);
            ExternalCheckerConfigurationPage.this.tableViewer.editElement((Object)r, 0);
        }

        public void removeRule(Rule r) {
            ExternalCheckerConfigurationPage.this.tableViewer.remove((Object)r);
        }

        public void updateRule(Rule r) {
            ExternalCheckerConfigurationPage.this.tableViewer.update((Object)r, null);
        }
    }
}

