/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.builder;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dltk.core.IScriptProject;

public interface IScriptBuilder {
    public static final int INCREMENTAL_BUILD = 0;
    public static final int FULL_BUILD = 1;

    public void initialize(IScriptProject var1);

    public IStatus buildResources(IScriptProject var1, List var2, IProgressMonitor var3, int var4);

    public IStatus buildModelElements(IScriptProject var1, List var2, IProgressMonitor var3, int var4);

    public DependencyResponse getDependencies(IScriptProject var1, int var2, Set var3, Set var4, Set var5, Set var6);

    public void clean(IScriptProject var1, IProgressMonitor var2);

    public void reset(IScriptProject var1);

    public static class DependencyResponse {
        public static final DependencyResponse FULL_LOCAL_BUILD = new DependencyResponse(){

            public boolean isFullLocalBuild() {
                return true;
            }
        };
        public static final DependencyResponse FULL_EXTERNAL_BUILD = new DependencyResponse(){

            public boolean isFullLocalBuild() {
                return true;
            }

            public boolean isFullExternalBuild() {
                return true;
            }
        };

        public boolean isFullLocalBuild() {
            return false;
        }

        public boolean isFullExternalBuild() {
            return false;
        }

        public Set getLocalDependencies() {
            return Collections.EMPTY_SET;
        }

        public Set getExternalDependencies() {
            return Collections.EMPTY_SET;
        }

        public static DependencyResponse createLocal(Set localDependencies) {
            return new DependencyResponse(localDependencies){
                private final /* synthetic */ Set val$localDependencies;
                {
                    this.val$localDependencies = set;
                }

                public Set getLocalDependencies() {
                    return this.val$localDependencies;
                }
            };
        }

        public static DependencyResponse create(boolean fullLocal, Set localDependencies, Set externalDependencies) {
            return new DependencyResponse(fullLocal, localDependencies, externalDependencies){
                private final /* synthetic */ boolean val$fullLocal;
                private final /* synthetic */ Set val$localDependencies;
                private final /* synthetic */ Set val$externalDependencies;
                {
                    this.val$fullLocal = bl;
                    this.val$localDependencies = set;
                    this.val$externalDependencies = set2;
                }

                public boolean isFullLocalBuild() {
                    return this.val$fullLocal;
                }

                public Set getLocalDependencies() {
                    return !this.val$fullLocal && this.val$localDependencies != null ? this.val$localDependencies : Collections.EMPTY_SET;
                }

                public Set getExternalDependencies() {
                    return this.val$externalDependencies != null ? this.val$externalDependencies : Collections.EMPTY_SET;
                }
            };
        }
    }
}

