/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.util.HashtableOfObject;
import org.eclipse.dltk.compiler.util.ObjectVector;
import org.eclipse.dltk.compiler.util.SimpleSet;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.search.index.EntryResult;
import org.eclipse.dltk.core.search.index.Index;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.internal.core.util.Util;

public class MixinIndex
extends Index {
    private static final char[] OLD_HEADER = "MIXIN INDEX 0.1".toCharArray();
    private static final char[] HEADER = "MIXIN INDEX 0.2".toCharArray();
    private final HashtableOfObject keyToDocs = new HashtableOfObject(10);
    private final SimpleSet documentNames = new SimpleSet(10);
    private final String fileName;
    private boolean dirty;

    public MixinIndex(String fileName, String containerPath, boolean reuseFile) throws IOException {
        super(fileName, containerPath);
        this.fileName = fileName;
        this.dirty = false;
        if (reuseFile) {
            this.initialize(reuseFile);
        } else {
            this.save();
        }
    }

    public void addIndexEntry(char[] category, char[] key, String containerRelativePath) {
        this.dirty = true;
        Assert.isTrue((boolean)CharOperation.equals(category, IIndexConstants.MIXIN));
        this.addIndexEntry(key, this.internDocName(containerRelativePath));
    }

    public void addDocumentName(String containerRelativePath) {
        int savedCount = this.documentNames.elementSize;
        this.internDocName(containerRelativePath);
        if (this.documentNames.elementSize > savedCount) {
            this.dirty = true;
        }
    }

    private void addIndexEntry(char[] key, String containerRelativePath) {
        SimpleSet docs = (SimpleSet)this.keyToDocs.get(key);
        if (docs == null) {
            docs = new SimpleSet(1);
            this.keyToDocs.put(key, docs);
        }
        docs.add(containerRelativePath);
    }

    public String containerRelativePath(String documentPath) {
        int index = documentPath.indexOf("|");
        if (index == -1) {
            index = this.containerPath.length();
            if (documentPath.length() <= index) {
                throw new IllegalArgumentException("Document path " + documentPath + " must be relative to " + this.containerPath);
            }
        }
        return documentPath.substring(index + 1);
    }

    public File getIndexFile() {
        return new File(this.fileName);
    }

    public boolean hasChanged() {
        return this.dirty;
    }

    private static boolean isMixinCategory(char[][] categories) {
        int i = 0;
        while (i < categories.length) {
            if (CharOperation.equals(categories[i], IIndexConstants.MIXIN)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public EntryResult[] query(char[][] categories, char[] key, int matchRule) throws IOException {
        if (!MixinIndex.isMixinCategory(categories)) {
            return new EntryResult[0];
        }
        ObjectVector results = new ObjectVector();
        this.performQuery(key, matchRule, results);
        Object[] entryResults = new EntryResult[results.size];
        results.copyInto(entryResults);
        return entryResults;
    }

    private void performQuery(char[] key, int matchRule, ObjectVector results) {
        char[][] keyTable = this.keyToDocs.keyTable;
        int i = 0;
        int keyLen = keyTable.length;
        while (i < keyLen) {
            char[] nextKey = keyTable[i];
            if (nextKey != null && Index.isMatch(key, nextKey, matchRule)) {
                EntryResult s = new EntryResult(nextKey, null);
                results.add(s);
                Object[] docTable = ((SimpleSet)this.keyToDocs.valueTable[i]).values;
                int j = 0;
                int docLen = docTable.length;
                while (j < docLen) {
                    String doc = (String)docTable[j];
                    if (doc != null) {
                        s.addDocumentName(doc);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static String[] extractKeysFromTable(SimpleSet table, String substring) {
        String[] documentNames = new String[table.elementSize];
        int count = 0;
        Object[] values = table.values;
        int i = 0;
        int l = values.length;
        while (i < l) {
            String result = (String)values[i];
            if (result != null && (substring == null || result.startsWith(substring))) {
                documentNames[count++] = result;
            }
            ++i;
        }
        if (count != documentNames.length) {
            String[] result = new String[count];
            System.arraycopy(documentNames, 0, result, 0, count);
            documentNames = result;
        }
        return documentNames;
    }

    public String[] queryDocumentNames(String substring) throws IOException {
        return MixinIndex.extractKeysFromTable(this.documentNames, substring);
    }

    public void remove(String containerRelativePath) {
        this.dirty = true;
        if (this.documentNames.remove(containerRelativePath) != null) {
            char[][] keyTable = this.keyToDocs.keyTable;
            int i = 0;
            while (i < keyTable.length) {
                SimpleSet docs = (SimpleSet)this.keyToDocs.valueTable[i];
                if (docs != null) {
                    docs.remove(containerRelativePath);
                }
                ++i;
            }
        }
    }

    public void save() throws IOException {
        if (!this.hasChanged()) {
            return;
        }
        File f = this.getIndexFile();
        FileOutputStream fouts = new FileOutputStream(f, false);
        BufferedOutputStream bufout = new BufferedOutputStream(fouts, 2048);
        DataOutputStream stream = new DataOutputStream(bufout);
        SimpleSet allDocuments = new SimpleSet();
        allDocuments.addAll(this.documentNames);
        Util.writeUTF(stream, HEADER);
        int keyCount = this.keyToDocs.elementSize;
        stream.writeInt(keyCount);
        int i = 0;
        while (i < this.keyToDocs.keyTable.length) {
            char[] key = this.keyToDocs.keyTable[i];
            if (key != null) {
                Util.writeUTF(stream, key);
                SimpleSet docs = (SimpleSet)this.keyToDocs.valueTable[i];
                stream.writeInt(docs.elementSize);
                int j = 0;
                while (j < docs.values.length) {
                    String docName = (String)docs.values[j];
                    if (docName != null) {
                        Util.writeUTF(stream, docName.toCharArray());
                        allDocuments.remove(docName);
                    }
                    ++j;
                }
            }
            ++i;
        }
        stream.writeInt(allDocuments.size());
        i = 0;
        int docTableLen = allDocuments.values.length;
        while (i < docTableLen) {
            String docName = (String)allDocuments.values[i];
            if (docName != null) {
                Util.writeUTF(stream, docName.toCharArray());
            }
            ++i;
        }
        bufout.close();
        stream.close();
        fouts.close();
        this.dirty = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initialize(boolean reuseExistingFile) throws IOException {
        boolean successful = false;
        File indexFile = this.getIndexFile();
        if (indexFile.exists()) {
            if (reuseExistingFile) {
                try {
                    block20: {
                        try {
                            this.monitor.enterRead();
                            DataInputStream stream = new DataInputStream(new BufferedInputStream(new FileInputStream(indexFile), 8192));
                            try {
                                char[] header = Util.readUTF(stream);
                                if (CharOperation.equals(OLD_HEADER, header)) {
                                    this.loadDocToKeyFormat(stream);
                                    successful = true;
                                } else if (CharOperation.equals(HEADER, header)) {
                                    this.loadKeyToDocFormat(stream);
                                    successful = true;
                                }
                                Object var6_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var6_9 = null;
                                stream.close();
                                throw throwable;
                            }
                            stream.close();
                        }
                        catch (FileNotFoundException e) {
                            if (DLTKCore.DEBUG_INDEX) {
                                e.printStackTrace();
                            }
                        }
                        catch (IOException e) {
                            if (!DLTKCore.DEBUG_INDEX) break block20;
                            e.printStackTrace();
                        }
                    }
                    Object var8_13 = null;
                    this.monitor.exitRead();
                    if (successful) {
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    this.monitor.exitRead();
                    throw throwable;
                }
            }
            if (!indexFile.delete()) {
                if (DLTKCore.DEBUG_INDEX) {
                    System.out.println("initialize - Failed to delete mixin index " + this.fileName);
                }
                throw new IOException("Failed to delete mixin index " + this.fileName);
            }
        }
        if (indexFile.createNewFile()) {
            this.save();
            this.dirty = false;
            return;
        }
        if (DLTKCore.DEBUG_INDEX) {
            System.out.println("initialize - Failed to create new index " + this.fileName);
        }
        throw new IOException("Failed to create new index " + this.fileName);
    }

    private void loadKeyToDocFormat(DataInputStream stream) throws IOException {
        int keyCount = stream.readInt();
        int i = 0;
        while (i < keyCount) {
            char[] key = Util.readUTF(stream);
            int docCount = stream.readInt();
            int j = 0;
            while (j < docCount) {
                String docName = this.internDocName(new String(Util.readUTF(stream)));
                this.addIndexEntry(key, docName);
                ++j;
            }
            ++i;
        }
        int docCount = stream.readInt();
        int i2 = 0;
        while (i2 < docCount) {
            this.internDocName(new String(Util.readUTF(stream)));
            ++i2;
        }
    }

    private void loadDocToKeyFormat(DataInputStream stream) throws IOException {
        int documentsCount = stream.readInt();
        int i = 0;
        while (i < documentsCount) {
            String docName = this.internDocName(new String(Util.readUTF(stream)));
            int wordsCount = stream.readInt();
            if (wordsCount > 0) {
                int j = 0;
                while (j < wordsCount) {
                    char[] word = Util.readUTF(stream);
                    this.addIndexEntry(word, docName);
                    ++j;
                }
            }
            ++i;
        }
    }

    private final String internDocName(String docName) {
        return (String)this.documentNames.addIntern(docName);
    }

    public void startQuery() {
    }

    public void stopQuery() {
    }

    public String toString() {
        return "Mixin Index for " + this.containerPath;
    }

    public boolean isRebuildable() {
        return false;
    }

    public String getContainerPath() {
        if (this.containerPath.startsWith("#special#mixin#")) {
            return this.containerPath.substring("#special#mixin#".length());
        }
        return this.containerPath;
    }
}

