/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IAccessRule;
import org.eclipse.dltk.core.IBuildpathAttribute;
import org.eclipse.dltk.core.IBuildpathContainer;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelStatus;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.environment.EnvironmentManager;
import org.eclipse.dltk.core.environment.EnvironmentPathUtils;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;
import org.eclipse.dltk.internal.compiler.env.AccessRule;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.BuildpathAccessRule;
import org.eclipse.dltk.internal.core.BuildpathAttribute;
import org.eclipse.dltk.internal.core.BuiltinProjectFragment;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.ModelStatus;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.XMLWriter;
import org.eclipse.dltk.internal.core.util.Messages;
import org.eclipse.dltk.internal.core.util.Util;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class BuildpathEntry
implements IBuildpathEntry {
    public static final String TAG_BUILDPATH = "buildpath";
    public static final String TAG_BUILDPATHENTRY = "buildpathentry";
    public static final String TAG_KIND = "kind";
    public static final String TAG_PATH = "path";
    public static final String TAG_EXPORTED = "exported";
    public static final String TAG_EXTERNAL = "external";
    public static final String TAG_INCLUDING = "including";
    public static final String TAG_EXCLUDING = "excluding";
    public static final String TAG_ACCESS_RULES = "accessrules";
    public static final String TAG_ACCESS_RULE = "accessrule";
    public static final String TAG_PATTERN = "pattern";
    public static final String TAG_ATTRIBUTES = "attributes";
    public static final String TAG_ATTRIBUTE = "attribute";
    public static final String TAG_ATTRIBUTE_NAME = "name";
    public static final String TAG_ATTRIBUTE_VALUE = "value";
    public static final String TAG_COMBINE_ACCESS_RULES = "combineaccessrules";
    public static final String TAG_ACCESSIBLE = "accessible";
    public static final String TAG_NON_ACCESSIBLE = "nonaccessible";
    public static final String TAG_DISCOURAGED = "discouraged";
    public static final String TAG_IGNORE_IF_BETTER = "ignoreifbetter";
    private int contentKind;
    private int entryKind;
    private IPath path;
    private IPath[] inclusionPatterns;
    private char[][] fullInclusionPatternChars;
    private IPath[] exclusionPatterns;
    private char[][] fullExclusionPatternChars;
    private static final char[][] UNINIT_PATTERNS = new char[][]{"Non-initialized yet".toCharArray()};
    private boolean combineAccessRules;
    private String rootID;
    private AccessRuleSet accessRuleSet;
    boolean fIsContainerEntry = false;
    public static final IPath[] INCLUDE_ALL = new IPath[0];
    public static final IPath[] EXCLUDE_NONE = new IPath[0];
    public static final IBuildpathAttribute[] NO_EXTRA_ATTRIBUTES = new IBuildpathAttribute[0];
    public static final IAccessRule[] NO_ACCESS_RULES = new IAccessRule[0];
    boolean isExported;
    IBuildpathAttribute[] extraAttributes;
    private boolean isExternal;

    public BuildpathEntry(int contentKind, int entryKind, IPath path, boolean isExported, IPath[] inclusionPatterns, IPath[] exclusionPatterns, IAccessRule[] accessRules, boolean combineAccessRules, IBuildpathAttribute[] extraAttributes, boolean externalLib) {
        int length;
        Assert.isLegal((!externalLib || EnvironmentPathUtils.isFull(path) || path.segment(0).equals("#special#builtin#") ? 1 : 0) != 0);
        this.contentKind = contentKind;
        this.entryKind = entryKind;
        this.path = path;
        this.isExported = isExported;
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
        this.isExternal = externalLib;
        if (accessRules != null && (length = accessRules.length) > 0) {
            AccessRule[] rules = new AccessRule[length];
            System.arraycopy(accessRules, 0, rules, 0, length);
            this.accessRuleSet = new AccessRuleSet(rules, this.getMessageTemplates());
        }
        this.combineAccessRules = combineAccessRules;
        this.extraAttributes = extraAttributes;
        if (inclusionPatterns != INCLUDE_ALL && inclusionPatterns.length > 0) {
            this.fullInclusionPatternChars = UNINIT_PATTERNS;
        }
        if (exclusionPatterns.length > 0) {
            this.fullExclusionPatternChars = UNINIT_PATTERNS;
        }
    }

    public int getEntryKind() {
        return this.entryKind;
    }

    public IPath[] getExclusionPatterns() {
        return this.exclusionPatterns;
    }

    public IBuildpathAttribute[] getExtraAttributes() {
        return this.extraAttributes;
    }

    private String[] getMessageTemplates() {
        ModelManager manager = ModelManager.getModelManager();
        String[] result = new String[4];
        if (this.entryKind == 2 || this.entryKind == 3) {
            result[0] = manager.intern(Messages.bind(Messages.restrictedAccess_project, new String[]{"{0}", this.getPath().segment(0)}));
            result[1] = manager.intern(Messages.bind(Messages.restrictedAccess_constructor_project, new String[]{"{0}", this.getPath().segment(0)}));
            result[2] = manager.intern(Messages.bind(Messages.restrictedAccess_method_project, new String[]{"{0}", "{1}", this.getPath().segment(0)}));
            result[3] = manager.intern(Messages.bind(Messages.restrictedAccess_field_project, new String[]{"{0}", "{1}", this.getPath().segment(0)}));
        } else {
            IPath libPath = this.getPath();
            Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), libPath, false);
            String pathString = target instanceof IFileHandle ? target.toString() : libPath.makeRelative().toString();
            result[0] = manager.intern(Messages.bind(Messages.restrictedAccess_library, new String[]{"{0}", pathString}));
            result[1] = manager.intern(Messages.bind(Messages.restrictedAccess_constructor_library, new String[]{"{0}", pathString}));
            result[2] = manager.intern(Messages.bind(Messages.restrictedAccess_method_library, new String[]{"{0}", "{1}", pathString}));
            result[3] = manager.intern(Messages.bind(Messages.restrictedAccess_field_library, new String[]{"{0}", "{1}", pathString}));
        }
        return result;
    }

    public IPath[] getInclusionPatterns() {
        return this.inclusionPatterns;
    }

    public IPath getPath() {
        return this.path;
    }

    public boolean isExported() {
        return this.isExported;
    }

    public boolean isOptional() {
        int i = 0;
        int length = this.extraAttributes.length;
        while (i < length) {
            IBuildpathAttribute attribute = this.extraAttributes[i];
            if ("optional".equals(attribute.getName()) && "true".equals(attribute.getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String rootID() {
        if (this.rootID == null) {
            switch (this.entryKind) {
                case 2: {
                    this.rootID = "[PRJ]" + this.path;
                    break;
                }
                case 1: {
                    this.rootID = "[LIB]" + this.path;
                    break;
                }
                case 3: {
                    this.rootID = "[SRC]" + this.path;
                    break;
                }
                case 5: {
                    this.rootID = "[CON]" + this.path;
                    break;
                }
                default: {
                    this.rootID = "";
                }
            }
        }
        return this.rootID;
    }

    public boolean combineAccessRules() {
        return this.combineAccessRules;
    }

    public BuildpathEntry combineWith(BuildpathEntry referringEntry) {
        if (referringEntry == null) {
            return this;
        }
        if (referringEntry.isExported() || referringEntry.getAccessRuleSet() != null) {
            boolean combine = this.entryKind == 3 || referringEntry.combineAccessRules();
            return new BuildpathEntry(this.getContentKind(), this.getEntryKind(), this.getPath(), referringEntry.isExported() || this.isExported, this.inclusionPatterns, this.exclusionPatterns, this.combine(referringEntry.getAccessRules(), this.getAccessRules(), combine), this.combineAccessRules, this.extraAttributes, this.isExternal);
        }
        return this;
    }

    private IAccessRule[] combine(IAccessRule[] referringRules, IAccessRule[] rules, boolean combine) {
        if (!combine) {
            return rules;
        }
        if (rules == null || rules.length == 0) {
            return referringRules;
        }
        int referringRulesLength = referringRules.length;
        int accessRulesLength = rules.length;
        int rulesLength = referringRulesLength + accessRulesLength;
        IAccessRule[] result = new IAccessRule[rulesLength];
        System.arraycopy(referringRules, 0, result, 0, referringRulesLength);
        System.arraycopy(rules, 0, result, referringRulesLength, accessRulesLength);
        return result;
    }

    public IAccessRule[] getAccessRules() {
        if (this.accessRuleSet == null) {
            return NO_ACCESS_RULES;
        }
        AccessRule[] rules = this.accessRuleSet.getAccessRules();
        int length = rules.length;
        if (length == 0) {
            return NO_ACCESS_RULES;
        }
        IAccessRule[] result = new IAccessRule[length];
        System.arraycopy(rules, 0, result, 0, length);
        return result;
    }

    public static IAccessRule[] getAccessRules(IPath[] accessibleFiles, IPath[] nonAccessibleFiles) {
        int nonAccessibleFilesLength;
        int accessibleFilesLength = accessibleFiles == null ? 0 : accessibleFiles.length;
        int length = accessibleFilesLength + (nonAccessibleFilesLength = nonAccessibleFiles == null ? 0 : nonAccessibleFiles.length);
        if (length == 0) {
            return null;
        }
        IAccessRule[] accessRules = new IAccessRule[length];
        int i = 0;
        while (i < accessibleFilesLength) {
            accessRules[i] = DLTKCore.newAccessRule(accessibleFiles[i], 0);
            ++i;
        }
        i = 0;
        while (i < nonAccessibleFilesLength) {
            accessRules[accessibleFilesLength + i] = DLTKCore.newAccessRule(nonAccessibleFiles[i], 1);
            ++i;
        }
        return accessRules;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPath().toString());
        buffer.append('[');
        switch (this.getEntryKind()) {
            case 1: {
                buffer.append("BPE_LIBRARY");
                break;
            }
            case 2: {
                buffer.append("BPE_PROJECT");
                break;
            }
            case 3: {
                buffer.append("BPE_SOURCE");
                break;
            }
            case 5: {
                buffer.append("BPE_CONTAINER");
            }
        }
        buffer.append("][");
        switch (this.getContentKind()) {
            case 1: {
                buffer.append("K_SOURCE");
            }
        }
        buffer.append(']');
        buffer.append("[isExported:");
        buffer.append(this.isExported);
        buffer.append(']');
        IPath[] patterns = this.inclusionPatterns;
        int length = patterns == null ? 0 : patterns.length;
        if (length > 0) {
            buffer.append("[including:");
            i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if ((length = (patterns = this.exclusionPatterns) == null ? 0 : patterns.length) > 0) {
            buffer.append("[excluding:");
            i = 0;
            while (i < length) {
                buffer.append(patterns[i]);
                if (i != length - 1) {
                    buffer.append('|');
                }
                ++i;
            }
            buffer.append(']');
        }
        if (this.accessRuleSet != null) {
            buffer.append('[');
            buffer.append(this.accessRuleSet.toString(false));
            buffer.append(']');
        }
        if (this.entryKind == 2) {
            buffer.append("[combine access rules:");
            buffer.append(this.combineAccessRules);
            buffer.append(']');
        }
        if ((length = this.extraAttributes == null ? 0 : this.extraAttributes.length) > 0) {
            buffer.append("[attributes:");
            i = 0;
            while (i < length) {
                buffer.append(this.extraAttributes[i]);
                if (i != length - 1) {
                    buffer.append(',');
                }
                ++i;
            }
            buffer.append(']');
        }
        return buffer.toString();
    }

    public AccessRuleSet getAccessRuleSet() {
        return this.accessRuleSet;
    }

    public int getContentKind() {
        return this.contentKind;
    }

    public static IBuildpathEntry elementDecode(Element element, IScriptProject project, Map unknownElements) {
        IPath[] exclusionPatterns;
        IPath projectPath = project.getProject().getFullPath();
        NamedNodeMap attributes = element.getAttributes();
        NodeList children = element.getChildNodes();
        boolean[] foundChildren = new boolean[children.getLength()];
        String kindAttr = BuildpathEntry.removeAttribute(TAG_KIND, attributes);
        String pathAttr = BuildpathEntry.removeAttribute(TAG_PATH, attributes);
        Path path = new Path(pathAttr);
        int kind = BuildpathEntry.kindFromString(kindAttr);
        if (kind != 5 && !path.isAbsolute()) {
            path = projectPath.append((IPath)path);
        }
        boolean isExported = BuildpathEntry.removeAttribute(TAG_EXPORTED, attributes).equals("true");
        boolean isExternal = BuildpathEntry.removeAttribute(TAG_EXTERNAL, attributes).equals("true");
        IPath[] inclusionPatterns = BuildpathEntry.decodePatterns(attributes, TAG_INCLUDING);
        if (inclusionPatterns == null) {
            inclusionPatterns = INCLUDE_ALL;
        }
        if ((exclusionPatterns = BuildpathEntry.decodePatterns(attributes, TAG_EXCLUDING)) == null) {
            exclusionPatterns = EXCLUDE_NONE;
        }
        NodeList attributeList = BuildpathEntry.getChildAttributes(TAG_ACCESS_RULES, children, foundChildren);
        IAccessRule[] accessRules = BuildpathEntry.decodeAccessRules(attributeList);
        boolean combineAccessRestrictions = !BuildpathEntry.removeAttribute(TAG_COMBINE_ACCESS_RULES, attributes).equals("false");
        attributeList = BuildpathEntry.getChildAttributes(TAG_ATTRIBUTES, children, foundChildren);
        IBuildpathAttribute[] extraAttributes = BuildpathEntry.decodeExtraAttributes(attributeList);
        String[] unknownAttributes = null;
        ArrayList<String> unknownChildren = null;
        if (unknownElements != null) {
            int i;
            int unknownAttributeLength = attributes.getLength();
            if (unknownAttributeLength != 0) {
                unknownAttributes = new String[unknownAttributeLength * 2];
                i = 0;
                while (i < unknownAttributeLength) {
                    Node attribute = attributes.item(i);
                    unknownAttributes[i * 2] = attribute.getNodeName();
                    unknownAttributes[i * 2 + 1] = attribute.getNodeValue();
                    ++i;
                }
            }
            i = 0;
            int length = foundChildren.length;
            while (i < length) {
                Node node;
                if (!foundChildren[i] && (node = children.item(i)).getNodeType() == 1) {
                    if (unknownChildren == null) {
                        unknownChildren = new ArrayList<String>();
                    }
                    StringBuffer buffer = new StringBuffer();
                    BuildpathEntry.decodeUnknownNode(node, buffer, project);
                    unknownChildren.add(buffer.toString());
                }
                ++i;
            }
        }
        IBuildpathEntry entry = null;
        switch (kind) {
            case 2: {
                entry = new BuildpathEntry(1, 2, (IPath)path, isExported, INCLUDE_ALL, EXCLUDE_NONE, accessRules, combineAccessRestrictions, extraAttributes, false);
                break;
            }
            case 1: {
                IEnvironment environment;
                if (isExternal && (environment = EnvironmentManager.getEnvironment(project)) != null) {
                    path = EnvironmentPathUtils.getFullPath(environment, (IPath)path);
                }
                entry = DLTKCore.newLibraryEntry((IPath)path, accessRules, extraAttributes, inclusionPatterns, exclusionPatterns, isExported, isExternal);
                break;
            }
            case 3: {
                String projSegment = path.segment(0);
                if (projSegment != null && projSegment.equals(project.getElementName())) {
                    entry = DLTKCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, extraAttributes);
                    break;
                }
                if (path.segmentCount() == 1) {
                    entry = DLTKCore.newProjectEntry((IPath)path, accessRules, combineAccessRestrictions, extraAttributes, isExported);
                    break;
                }
                entry = DLTKCore.newSourceEntry((IPath)path, inclusionPatterns, exclusionPatterns, extraAttributes);
                break;
            }
            case 5: {
                entry = DLTKCore.newContainerEntry((IPath)path, accessRules, extraAttributes, isExported);
                break;
            }
            default: {
                throw new AssertionFailedException(Messages.bind(Messages.buildpath_unknownKind, kindAttr));
            }
        }
        if (unknownAttributes != null || unknownChildren != null) {
            UnknownXmlElements unknownXmlElements = new UnknownXmlElements();
            unknownXmlElements.attributes = unknownAttributes;
            unknownXmlElements.children = unknownChildren;
            unknownElements.put(path, unknownXmlElements);
        }
        return entry;
    }

    static IBuildpathAttribute[] decodeExtraAttributes(NodeList attributes) {
        if (attributes == null) {
            return NO_EXTRA_ATTRIBUTES;
        }
        int length = attributes.getLength();
        if (length == 0) {
            return NO_EXTRA_ATTRIBUTES;
        }
        IBuildpathAttribute[] result = new IBuildpathAttribute[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            String value;
            Element attribute;
            String name;
            Node node = attributes.item(i);
            if (node.getNodeType() == 1 && (name = (attribute = (Element)node).getAttribute(TAG_ATTRIBUTE_NAME)) != null && (value = attribute.getAttribute(TAG_ATTRIBUTE_VALUE)) != null) {
                result[index++] = new BuildpathAttribute(name, value);
            }
            ++i;
        }
        if (index != length) {
            IBuildpathAttribute[] iBuildpathAttributeArray = result;
            result = new IBuildpathAttribute[index];
            System.arraycopy(iBuildpathAttributeArray, 0, result, 0, index);
        }
        return result;
    }

    static IAccessRule[] decodeAccessRules(NodeList list) {
        if (list == null) {
            return null;
        }
        int length = list.getLength();
        if (length == 0) {
            return null;
        }
        IAccessRule[] result = new IAccessRule[length];
        int index = 0;
        int i = 0;
        while (i < length) {
            block7: {
                int kind;
                Element elementAccessRule;
                String pattern;
                block9: {
                    String tagKind;
                    block10: {
                        block8: {
                            Node accessRule = list.item(i);
                            if (accessRule.getNodeType() != 1 || (pattern = (elementAccessRule = (Element)accessRule).getAttribute(TAG_PATTERN)) == null) break block7;
                            tagKind = elementAccessRule.getAttribute(TAG_KIND);
                            if (!TAG_ACCESSIBLE.equals(tagKind)) break block8;
                            kind = 0;
                            break block9;
                        }
                        if (!TAG_NON_ACCESSIBLE.equals(tagKind)) break block10;
                        kind = 1;
                        break block9;
                    }
                    if (!TAG_DISCOURAGED.equals(tagKind)) break block7;
                    kind = 2;
                }
                boolean ignoreIfBetter = "true".equals(elementAccessRule.getAttribute(TAG_IGNORE_IF_BETTER));
                result[index++] = new BuildpathAccessRule((IPath)new Path(pattern), ignoreIfBetter ? kind | 0x100 : kind);
            }
            ++i;
        }
        if (index != length) {
            IAccessRule[] iAccessRuleArray = result;
            result = new IAccessRule[index];
            System.arraycopy(iAccessRuleArray, 0, result, 0, index);
        }
        return result;
    }

    private static IPath[] decodePatterns(NamedNodeMap nodeMap, String tag) {
        char[][] patterns;
        int patternCount;
        String sequence = BuildpathEntry.removeAttribute(tag, nodeMap);
        if (!sequence.equals("") && (patternCount = (patterns = CharOperation.splitOn('|', sequence.toCharArray())).length) > 0) {
            IPath[] paths = new IPath[patternCount];
            int index = 0;
            int j = 0;
            while (j < patternCount) {
                char[] pattern = patterns[j];
                if (pattern.length != 0) {
                    paths[index++] = new Path(new String(pattern));
                }
                ++j;
            }
            if (index < patternCount) {
                IPath[] iPathArray = paths;
                paths = new IPath[index];
                System.arraycopy(iPathArray, 0, paths, 0, index);
            }
            return paths;
        }
        return null;
    }

    private static void decodeUnknownNode(Node node, StringBuffer buffer, IScriptProject project) {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)s, "UTF8");
            XMLWriter xmlWriter = new XMLWriter((Writer)writer, project, false);
            BuildpathEntry.decodeUnknownNode(node, xmlWriter, true);
            xmlWriter.flush();
            xmlWriter.close();
            buffer.append(s.toString("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    private static void decodeUnknownNode(Node node, XMLWriter xmlWriter, boolean insertNewLine) {
        switch (node.getNodeType()) {
            case 1: {
                NamedNodeMap attributes = node.getAttributes();
                HashMap<String, String> parameters = new HashMap<String, String>();
                int i = 0;
                int length = attributes == null ? 0 : attributes.getLength();
                while (i < length) {
                    Node attribute = attributes.item(i);
                    parameters.put(attribute.getNodeName(), attribute.getNodeValue());
                    ++i;
                }
                NodeList children = node.getChildNodes();
                int childrenLength = children.getLength();
                String nodeName = node.getNodeName();
                xmlWriter.printTag(nodeName, parameters, false, false, childrenLength == 0);
                if (childrenLength <= 0) break;
                int i2 = 0;
                while (i2 < childrenLength) {
                    BuildpathEntry.decodeUnknownNode(children.item(i2), xmlWriter, false);
                    ++i2;
                }
                xmlWriter.endTag(nodeName, false, insertNewLine);
                break;
            }
            case 3: {
                String data = ((Text)node).getData();
                xmlWriter.printString(data, false, false);
            }
        }
    }

    public char[][] fullExclusionPatternChars() {
        if (this.fullExclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.exclusionPatterns.length;
            this.fullExclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullExclusionPatternChars[i] = prefixPath.append(this.exclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullExclusionPatternChars;
    }

    public char[][] fullInclusionPatternChars() {
        if (this.fullInclusionPatternChars == UNINIT_PATTERNS) {
            int length = this.inclusionPatterns.length;
            this.fullInclusionPatternChars = new char[length][];
            IPath prefixPath = this.path.removeTrailingSeparator();
            int i = 0;
            while (i < length) {
                this.fullInclusionPatternChars[i] = prefixPath.append(this.inclusionPatterns[i]).toString().toCharArray();
                ++i;
            }
        }
        return this.fullInclusionPatternChars;
    }

    public static NodeList getChildAttributes(String childName, NodeList children, boolean[] foundChildren) {
        int i = 0;
        int length = foundChildren.length;
        while (i < length) {
            Node node = children.item(i);
            if (childName.equals(node.getNodeName())) {
                foundChildren[i] = true;
                return node.getChildNodes();
            }
            ++i;
        }
        return null;
    }

    private static String removeAttribute(String nodeName, NamedNodeMap nodeMap) {
        Node node = BuildpathEntry.removeNode(nodeName, nodeMap);
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    private static Node removeNode(String nodeName, NamedNodeMap nodeMap) {
        try {
            return nodeMap.removeNamedItem(nodeName);
        }
        catch (DOMException e) {
            if (e.code != 8) {
                throw e;
            }
            return null;
        }
    }

    static int kindFromString(String kindStr) {
        if (kindStr.equalsIgnoreCase("prj")) {
            return 2;
        }
        if (kindStr.equalsIgnoreCase("con")) {
            return 5;
        }
        if (kindStr.equalsIgnoreCase("src")) {
            return 3;
        }
        if (kindStr.equalsIgnoreCase("lib")) {
            return 1;
        }
        return -1;
    }

    public void elementEncode(XMLWriter writer, IPath projectPath, boolean indent, boolean newLine, Map unknownElements) {
        UnknownXmlElements unknownXmlElements;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TAG_KIND, BuildpathEntry.kindToString(this.entryKind));
        IPath xmlPath = this.path;
        if (this.entryKind != 5 && this.entryKind != 5) {
            if (EnvironmentPathUtils.isFull(xmlPath)) {
                xmlPath = EnvironmentPathUtils.getLocalPath(this.path);
            }
            if (xmlPath.isAbsolute() && projectPath != null && projectPath.isPrefixOf(xmlPath)) {
                if (xmlPath.segment(0).equals(projectPath.segment(0))) {
                    xmlPath = xmlPath.removeFirstSegments(1);
                    xmlPath = xmlPath.makeRelative();
                } else {
                    xmlPath = xmlPath.makeAbsolute();
                }
            }
        }
        parameters.put(TAG_PATH, String.valueOf(xmlPath));
        if (this.isExported) {
            parameters.put(TAG_EXPORTED, "true");
        }
        if (this.isExternal) {
            parameters.put(TAG_EXTERNAL, "true");
        }
        BuildpathEntry.encodePatterns(this.inclusionPatterns, TAG_INCLUDING, parameters);
        BuildpathEntry.encodePatterns(this.exclusionPatterns, TAG_EXCLUDING, parameters);
        if (this.entryKind == 2 && !this.combineAccessRules) {
            parameters.put(TAG_COMBINE_ACCESS_RULES, "false");
        }
        UnknownXmlElements unknownXmlElements2 = unknownXmlElements = unknownElements == null ? null : (UnknownXmlElements)unknownElements.get(this.path);
        if (unknownXmlElements != null) {
            String[] unknownAttributes = unknownXmlElements.attributes;
            if (unknownXmlElements.attributes != null) {
                int i = 0;
                int length = unknownAttributes.length;
                while (i < length) {
                    String tagName = unknownAttributes[i];
                    String tagValue = unknownAttributes[i + 1];
                    parameters.put(tagName, tagValue);
                    i += 2;
                }
            }
        }
        boolean hasExtraAttributes = this.extraAttributes.length != 0;
        boolean hasRestrictions = this.getAccessRuleSet() != null;
        ArrayList unknownChildren = unknownXmlElements != null ? unknownXmlElements.children : null;
        boolean hasUnknownChildren = unknownChildren != null;
        writer.printTag(TAG_BUILDPATHENTRY, parameters, indent, newLine, !hasExtraAttributes && !hasRestrictions && !hasUnknownChildren);
        if (hasExtraAttributes) {
            this.encodeExtraAttributes(writer, indent, newLine);
        }
        if (hasRestrictions) {
            this.encodeAccessRules(writer, indent, newLine);
        }
        if (hasUnknownChildren) {
            this.encodeUnknownChildren(writer, indent, newLine, unknownChildren);
        }
        if (hasUnknownChildren) {
            writer.endTag(TAG_BUILDPATHENTRY, indent, true);
        }
        if (hasExtraAttributes || hasRestrictions || hasUnknownChildren) {
            writer.endTag(TAG_BUILDPATHENTRY, indent, true);
        }
    }

    void encodeExtraAttributes(XMLWriter writer, boolean indent, boolean newLine) {
        writer.startTag(TAG_ATTRIBUTES, indent);
        int i = 0;
        while (i < this.extraAttributes.length) {
            IBuildpathAttribute attribute = this.extraAttributes[i];
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put(TAG_ATTRIBUTE_NAME, attribute.getName());
            parameters.put(TAG_ATTRIBUTE_VALUE, attribute.getValue());
            writer.printTag(TAG_ATTRIBUTE, parameters, indent, newLine, true);
            ++i;
        }
        writer.endTag(TAG_ATTRIBUTES, indent, true);
    }

    void encodeAccessRules(XMLWriter writer, boolean indent, boolean newLine) {
        writer.startTag(TAG_ACCESS_RULES, indent);
        AccessRule[] rules = this.getAccessRuleSet().getAccessRules();
        int i = 0;
        int length = rules.length;
        while (i < length) {
            this.encodeAccessRule(rules[i], writer, indent, newLine);
            ++i;
        }
        writer.endTag(TAG_ACCESS_RULES, indent, true);
    }

    private void encodeAccessRule(AccessRule accessRule, XMLWriter writer, boolean indent, boolean newLine) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(TAG_PATTERN, new String(accessRule.pattern));
        switch (accessRule.getProblemId()) {
            case 0x1000133: {
                parameters.put(TAG_KIND, TAG_NON_ACCESSIBLE);
                break;
            }
            case 0x1000118: {
                parameters.put(TAG_KIND, TAG_DISCOURAGED);
                break;
            }
            default: {
                parameters.put(TAG_KIND, TAG_ACCESSIBLE);
            }
        }
        if (accessRule.ignoreIfBetter()) {
            parameters.put(TAG_IGNORE_IF_BETTER, "true");
        }
        writer.printTag(TAG_ACCESS_RULE, parameters, indent, newLine, true);
    }

    static String kindToString(int kind) {
        switch (kind) {
            case 2: {
                return "prj";
            }
            case 3: {
                return "src";
            }
            case 1: {
                return "lib";
            }
            case 5: {
                return "con";
            }
        }
        return "unknown";
    }

    private void encodeUnknownChildren(XMLWriter writer, boolean indent, boolean newLine, ArrayList unknownChildren) {
        int i = 0;
        int length = unknownChildren.size();
        while (i < length) {
            String child = (String)unknownChildren.get(i);
            writer.printString(child, indent, false);
            ++i;
        }
    }

    public static IModelStatus validateBuildpath(IScriptProject scriptProject, IBuildpathEntry[] rawBuildpath) {
        IBuildpathEntry[] buildpath;
        IProject project = scriptProject.getProject();
        IPath projectPath = project.getFullPath();
        String projectName = scriptProject.getElementName();
        if (rawBuildpath == null) {
            return ModelStatus.VERIFIED_OK;
        }
        int interpreterCount = 0;
        int i = 0;
        while (i < rawBuildpath.length) {
            IBuildpathEntry entry = rawBuildpath[i];
            if (entry.isContainerEntry() && BuiltinProjectFragment.INTERPRETER_CONTAINER.equals(entry.getPath().segment(0)) && ++interpreterCount > 1) {
                return new ModelStatus(977, Messages.buildpath_multipleInterpreters);
            }
            ++i;
        }
        try {
            buildpath = ((ScriptProject)scriptProject).getResolvedBuildpath(rawBuildpath, true, false, null);
        }
        catch (ModelException e) {
            return e.getModelStatus();
        }
        int length = buildpath.length;
        boolean disableExclusionPatterns = "disabled".equals(scriptProject.getOption("org.eclipse.dltk.core.buildpath.exclusionPatterns", true));
        int i2 = 0;
        while (i2 < length) {
            IBuildpathEntry resolvedEntry = buildpath[i2];
            if (disableExclusionPatterns && (resolvedEntry.getInclusionPatterns() != null && resolvedEntry.getInclusionPatterns().length > 0 || resolvedEntry.getExclusionPatterns() != null && resolvedEntry.getExclusionPatterns().length > 0)) {
                return new ModelStatus(1002, (IModelElement)scriptProject, resolvedEntry.getPath());
            }
            ++i2;
        }
        HashSet<String> paths = new HashSet<String>(length);
        int i3 = 0;
        while (i3 < length) {
            IBuildpathEntry entry = buildpath[i3];
            if (entry != null) {
                String entryPathMsg;
                IPath entryPath = entry.getPath();
                int kind = entry.getEntryKind();
                boolean isProjectRelative = projectName.equals(entryPath.segment(0));
                String string = entryPathMsg = isProjectRelative ? entryPath.removeFirstSegments(1).toString() : EnvironmentPathUtils.getLocalPath(entryPath).makeRelative().toString();
                if (!paths.add(entryPath.toString())) {
                    return new ModelStatus(977, Messages.bind(Messages.buildpath_duplicateEntryPath, new String[]{entryPathMsg, projectName}));
                }
                if (entryPath.equals((Object)projectPath)) {
                    if (kind == 2) {
                        return new ModelStatus(979, Messages.bind(Messages.buildpath_cannotReferToItself, entryPath.makeRelative().toString()));
                    }
                } else if (kind == 3 || kind == 1 && !org.eclipse.dltk.compiler.util.Util.isArchiveFileName(entryPath.lastSegment())) {
                    int j = 0;
                    while (j < buildpath.length) {
                        IBuildpathEntry otherEntry = buildpath[j];
                        if (otherEntry != null) {
                            int otherKind = otherEntry.getEntryKind();
                            IPath otherPath = otherEntry.getPath();
                            if (entry != otherEntry && (otherKind == 3 || otherKind == 1 && !org.eclipse.dltk.compiler.util.Util.isArchiveFileName(otherPath.lastSegment())) && otherPath.isPrefixOf(entryPath) && !otherPath.equals((Object)entryPath)) {
                                char[][] inclusionPatterns = ((BuildpathEntry)otherEntry).fullInclusionPatternChars();
                                char[][] exclusionPatterns = ((BuildpathEntry)otherEntry).fullExclusionPatternChars();
                                if (!Util.isExcluded(entryPath.append("*"), inclusionPatterns, exclusionPatterns, false)) {
                                    String exclusionPattern = entryPath.removeFirstSegments(otherPath.segmentCount()).segment(0);
                                    if (Util.isExcluded(entryPath, inclusionPatterns, exclusionPatterns, false)) {
                                        return new ModelStatus(964, Messages.bind(Messages.buildpath_mustEndWithSlash, new String[]{exclusionPattern, EnvironmentPathUtils.getLocalPath(entryPath).makeRelative().toString()}));
                                    }
                                    if (otherKind == 3) {
                                        exclusionPattern = String.valueOf(exclusionPattern) + '/';
                                        if (!disableExclusionPatterns) {
                                            return new ModelStatus(964, Messages.bind(Messages.buildpath_cannotNestEntryInEntry, new String[]{EnvironmentPathUtils.getLocalPath(entryPath).makeRelative().toString(), EnvironmentPathUtils.getLocalPath(otherEntry.getPath()).makeRelative().toString(), exclusionPattern}));
                                        }
                                        return new ModelStatus(964, Messages.bind(Messages.buildpath_cannotNestEntryInEntryNoExclusion, new String[]{EnvironmentPathUtils.getLocalPath(entryPath).makeRelative().toString(), EnvironmentPathUtils.getLocalPath(otherEntry.getPath()).makeRelative().toString(), exclusionPattern}));
                                    }
                                    return new ModelStatus(964, Messages.bind(Messages.buildpath_cannotNestEntryInLibrary, new String[]{EnvironmentPathUtils.getLocalPath(entryPath).makeRelative().toString(), EnvironmentPathUtils.getLocalPath(otherEntry.getPath()).makeRelative().toString()}));
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i3;
        }
        return ModelStatus.VERIFIED_OK;
    }

    public static IModelStatus validateBuildpathEntry(IScriptProject project, IBuildpathEntry entry, boolean recurseInContainers) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = entry.getPath();
        String projectName = project.getElementName();
        boolean pathStartsWithProject = projectName.equals(path.segment(0));
        String entryPathMsg = pathStartsWithProject ? path.removeFirstSegments(1).makeRelative().toString() : EnvironmentPathUtils.getLocalPath(path).toString();
        block2 : switch (entry.getEntryKind()) {
            case 5: {
                if (path != null && path.segmentCount() >= 1) {
                    try {
                        IBuildpathContainer container = ModelManager.getModelManager().getBuildpathContainer(path, project);
                        if (container == null) {
                            return new ModelStatus(963, (IModelElement)project, path);
                        }
                        if (container == ModelManager.CONTAINER_INITIALIZATION_IN_PROGRESS) {
                            IBuildpathAttribute[] extraAttributes = entry.getExtraAttributes();
                            if (extraAttributes != null) {
                                int length = extraAttributes.length;
                                HashSet<String> set = new HashSet<String>(length);
                                int i = 0;
                                while (i < length) {
                                    String attName = extraAttributes[i].getName();
                                    if (!set.add(attName)) {
                                        return new ModelStatus(977, Messages.bind(Messages.buildpath_duplicateEntryExtraAttribute, new String[]{attName, entryPathMsg, projectName}));
                                    }
                                    ++i;
                                }
                            }
                            return ModelStatus.VERIFIED_OK;
                        }
                        IBuildpathEntry[] containerEntries = container.getBuildpathEntries(project);
                        if (containerEntries == null) break;
                        int i = 0;
                        int length = containerEntries.length;
                        while (i < length) {
                            IModelStatus containerEntryStatus;
                            int kind;
                            IBuildpathEntry containerEntry = containerEntries[i];
                            int n = kind = containerEntry == null ? 0 : containerEntry.getEntryKind();
                            if (containerEntry == null || kind == 3 || kind == 5) {
                                return new ModelStatus(962, (IModelElement)project, path);
                            }
                            if (recurseInContainers && !(containerEntryStatus = BuildpathEntry.validateBuildpathEntry(project, containerEntry, recurseInContainers)).isOK()) {
                                return containerEntryStatus;
                            }
                            ++i;
                        }
                        break;
                    }
                    catch (ModelException e) {
                        return new ModelStatus(e);
                    }
                }
                return new ModelStatus(964, Messages.bind(Messages.buildpath_illegalContainerPath, new String[]{entryPathMsg, projectName}));
            }
            case 4: {
                if (path.segmentCount() >= 1) {
                    try {
                        entry = DLTKCore.getResolvedBuildpathEntry(entry);
                    }
                    catch (AssertionFailedException e) {
                        return new ModelStatus(979, e.getMessage());
                    }
                    if (entry == null) {
                        return new ModelStatus(965, (IModelElement)project, path);
                    }
                    IModelStatus status = BuildpathEntry.validateBuildpathEntry(project, entry, recurseInContainers);
                    if (status.isOK()) break;
                    return status;
                }
                return new ModelStatus(964, Messages.bind(Messages.buildpath_illegalVariablePath, new String[]{entryPathMsg, projectName}));
            }
            case 1: {
                if (path.toString().startsWith("#special#builtin#")) break;
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    IFileHandle file;
                    Object target = Model.getTarget((IContainer)workspaceRoot, path, true);
                    if (!entry.isExternal()) {
                        if (target instanceof IResource) {
                            IResource resolvedResource = (IResource)target;
                            switch (resolvedResource.getType()) {
                                case 1: {
                                    break block2;
                                }
                            }
                            break;
                        }
                        if (!(target instanceof IFileHandle) || (file = (IFileHandle)target).exists()) break;
                        return new ModelStatus(964, Messages.bind(Messages.buildpath_illegalLibraryArchive, new String[]{EnvironmentPathUtils.getLocalPath(path).toString(), projectName}));
                    }
                    file = EnvironmentPathUtils.getFile(entry.getPath());
                    if (file != null && file.exists()) break;
                    return new ModelStatus(964, Messages.bind(Messages.buildpath_illegalExternalFolder, new String[]{EnvironmentPathUtils.getLocalPath(path).toString(), projectName}));
                }
                return new ModelStatus(964, Messages.bind(Messages.buildpath_illegalLibraryPath, new String[]{entryPathMsg, projectName}));
            }
            case 2: {
                if (path != null && path.isAbsolute() && path.segmentCount() == 1) {
                    IProject prereqProjectRsc = workspaceRoot.getProject(path.segment(0));
                    if (!prereqProjectRsc.exists() || !DLTKLanguageManager.hasScriptNature(prereqProjectRsc)) {
                        return new ModelStatus(964, Messages.bind(Messages.buildpath_unboundProject, new String[]{path.segment(0), projectName}));
                    }
                    if (prereqProjectRsc.isOpen()) break;
                    return new ModelStatus(964, Messages.bind(Messages.buildpath_closedProject, new String[]{path.segment(0)}));
                }
                return new ModelStatus(964, Messages.bind(Messages.buildpath_illegalProjectPath, new String[]{path.toString(), projectName}));
            }
            case 3: {
                if ((entry.getInclusionPatterns() != null && entry.getInclusionPatterns().length > 0 || entry.getExclusionPatterns() != null && entry.getExclusionPatterns().length > 0) && "disabled".equals(project.getOption("org.eclipse.dltk.core.buildpath.exclusionPatterns", true))) {
                    return new ModelStatus(1002, (IModelElement)project, path);
                }
                if (path != null && path.isAbsolute() && !path.isEmpty()) {
                    IPath projectPath = project.getProject().getFullPath();
                    if (projectPath.isPrefixOf(path) && Model.getTarget((IContainer)workspaceRoot, path, true) != null) break;
                    return new ModelStatus(964, Messages.bind(Messages.buildpath_unboundSourceFolder, new String[]{entryPathMsg, projectName}));
                }
                return new ModelStatus(964, Messages.bind(Messages.buildpath_illegalSourceFolderPath, new String[]{entryPathMsg, projectName}));
            }
        }
        IBuildpathAttribute[] extraAttributes = entry.getExtraAttributes();
        if (extraAttributes != null) {
            int length = extraAttributes.length;
            HashSet<String> set = new HashSet<String>(length);
            int i = 0;
            while (i < length) {
                String attName = extraAttributes[i].getName();
                if (!set.add(attName)) {
                    return new ModelStatus(977, Messages.bind(Messages.buildpath_duplicateEntryExtraAttribute, new String[]{attName, entryPathMsg, projectName}));
                }
                ++i;
            }
        }
        return ModelStatus.VERIFIED_OK;
    }

    private static void encodePatterns(IPath[] patterns, String tag, Map parameters) {
        if (patterns != null && patterns.length > 0) {
            StringBuffer rule = new StringBuffer(10);
            int i = 0;
            int max = patterns.length;
            while (i < max) {
                if (i > 0) {
                    rule.append('|');
                }
                rule.append(patterns[i]);
                ++i;
            }
            parameters.put(tag, String.valueOf(rule));
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof BuildpathEntry) {
            BuildpathEntry otherEntry = (BuildpathEntry)object;
            if (this.contentKind != otherEntry.getContentKind()) {
                return false;
            }
            if (this.entryKind != otherEntry.getEntryKind()) {
                return false;
            }
            if (this.isExported != otherEntry.isExported()) {
                return false;
            }
            if (this.isExternal != otherEntry.isExternal()) {
                return false;
            }
            if (!this.path.equals((Object)otherEntry.getPath())) {
                return false;
            }
            if (!BuildpathEntry.equalPatterns(this.inclusionPatterns, otherEntry.getInclusionPatterns())) {
                return false;
            }
            if (!BuildpathEntry.equalPatterns(this.exclusionPatterns, otherEntry.getExclusionPatterns())) {
                return false;
            }
            AccessRuleSet otherRuleSet = otherEntry.getAccessRuleSet();
            if (this.getAccessRuleSet() != null ? !this.getAccessRuleSet().equals(otherRuleSet) : otherRuleSet != null) {
                return false;
            }
            if (this.combineAccessRules != otherEntry.combineAccessRules()) {
                return false;
            }
            return BuildpathEntry.equalAttributes(this.extraAttributes, otherEntry.getExtraAttributes());
        }
        return false;
    }

    private static boolean equalAttributes(IBuildpathAttribute[] firstAttributes, IBuildpathAttribute[] secondAttributes) {
        if (firstAttributes != secondAttributes) {
            if (firstAttributes == null) {
                return false;
            }
            int length = firstAttributes.length;
            if (secondAttributes == null || secondAttributes.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!firstAttributes[i].equals(secondAttributes[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private static boolean equalPatterns(IPath[] firstPatterns, IPath[] secondPatterns) {
        if (firstPatterns != secondPatterns) {
            if (firstPatterns == null) {
                return false;
            }
            int length = firstPatterns.length;
            if (secondPatterns == null || secondPatterns.length != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (!firstPatterns[i].toString().equals(secondPatterns[i].toString())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isContainerEntry() {
        return this.fIsContainerEntry;
    }

    public void setIsContainerEntry(boolean value) {
        this.fIsContainerEntry = value;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    static class UnknownXmlElements {
        String[] attributes;
        ArrayList children;

        UnknownXmlElements() {
        }
    }
}

