/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.util.HashtableOfObject;
import org.eclipse.dltk.compiler.util.HashtableOfObjectToInt;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.DLTKSearchParticipant;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.indexing.IIndexConstants;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.core.search.matching.MatchLocator;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.IPathRequestor;
import org.eclipse.dltk.internal.core.Member;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.dltk.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.dltk.internal.core.hierarchy.IndexBasedHierarchyBuilder;
import org.eclipse.dltk.internal.core.hierarchy.TypeHierarchy;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;
import org.eclipse.dltk.internal.core.search.SubTypeSearchJob;
import org.eclipse.dltk.internal.core.search.matching.SuperTypeReferencePattern;

public class IndexBasedHierarchyBuilder
extends HierarchyBuilder {
    public static final int MAXTICKS = 800;
    protected Map cuToHandle;
    protected IDLTKSearchScope scope;
    protected Map binariesFromIndexMatches;

    public IndexBasedHierarchyBuilder(TypeHierarchy hierarchy, IDLTKSearchScope scope) throws ModelException {
        this.setRequestor(hierarchy);
        this.cuToHandle = new HashMap(5);
        this.binariesFromIndexMatches = new HashMap(10);
        this.scope = scope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void build(boolean computeSubtypes) {
        ModelManager manager = ModelManager.getModelManager();
        try {
            manager.cacheZipFiles();
            if (computeSubtypes) {
                IType focusType = this.getType();
                boolean focusIsObject = focusType.getElementName().equals(new String(IIndexConstants.OBJECT));
                int amountOfWorkForSubtypes = focusIsObject ? 5 : 80;
                SubProgressMonitor possibleSubtypesMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, amountOfWorkForSubtypes);
                HashSet localTypes = new HashSet(10);
                String[] allPossibleSubtypes = ((Member)((Object)focusType)).getOuterMostLocalContext() == null ? this.determinePossibleSubTypes(localTypes, (IProgressMonitor)possibleSubtypesMonitor) : CharOperation.NO_STRINGS;
                if (allPossibleSubtypes != null) {
                    SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 100 - amountOfWorkForSubtypes);
                    this.hierarchy.initialize(allPossibleSubtypes.length);
                    this.buildFromPotentialSubtypes(allPossibleSubtypes, localTypes, (IProgressMonitor)buildMonitor);
                }
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
            Object var10_12 = null;
            manager.flushZipFiles();
            return;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            manager.flushZipFiles();
            throw throwable;
        }
    }

    private void buildForProject(ScriptProject project, ArrayList potentialSubtypes, ISourceModule[] workingCopies, HashSet localTypes, IProgressMonitor monitor) throws ModelException {
        int openablesLength = potentialSubtypes.size();
        if (openablesLength > 0) {
            Member declaringMember;
            Openable[] openables = new Openable[openablesLength];
            potentialSubtypes.toArray(openables);
            IProjectFragment[] roots = project.getProjectFragments();
            int rootsLength = roots.length;
            final HashtableOfObjectToInt indexes = new HashtableOfObjectToInt(openablesLength);
            int i = 0;
            while (i < openablesLength) {
                IModelElement root = openables[i].getAncestor(3);
                int index = 0;
                while (index < rootsLength) {
                    if (roots[index].equals(root)) break;
                    ++index;
                }
                indexes.put(openables[i], index);
                ++i;
            }
            Arrays.sort(openables, new Comparator(){

                public int compare(Object a, Object b) {
                    int bIndex;
                    int aIndex = indexes.get(a);
                    if (aIndex != (bIndex = indexes.get(b))) {
                        return aIndex - bIndex;
                    }
                    return ((Openable)b).getElementName().compareTo(((Openable)a).getElementName());
                }
            });
            IType focusType = this.getType();
            boolean inProjectOfFocusType = focusType != null && focusType.getScriptProject().equals(project);
            ISourceModule[] unitsToLookInside = null;
            if (inProjectOfFocusType) {
                ISourceModule unitToLookInside = focusType.getSourceModule();
                if (unitToLookInside != null) {
                    int wcLength;
                    int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
                    if (wcLength == 0) {
                        unitsToLookInside = new ISourceModule[]{unitToLookInside};
                    } else {
                        unitsToLookInside = new ISourceModule[wcLength + 1];
                        unitsToLookInside[0] = unitToLookInside;
                        System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
                    }
                } else {
                    unitsToLookInside = workingCopies;
                }
            }
            ISearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(unitsToLookInside);
            this.nameLookup = searchableEnvironment.getNameLookup();
            this.hierarchyResolver = new HierarchyResolver(this);
            if (focusType != null && (declaringMember = ((Member)((Object)focusType)).getOuterMostLocalContext()) != null) {
                Openable openable = (Openable)((Object)declaringMember.getSourceModule());
                localTypes = new HashSet<String>();
                localTypes.add(openable.getPath().toString());
                this.hierarchyResolver.resolve(new Openable[]{openable}, localTypes);
                return;
            }
            this.hierarchyResolver.resolve(openables, localTypes);
        }
    }

    /*
     * Exception decompiling
     */
    private void buildFromPotentialSubtypes(String[] allPotentialSubTypes, HashSet localTypes, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [6 : 574->578)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected ISourceModule createCompilationUnitFromPath(Openable handle, IFile file) {
        ISourceModule unit = super.createCompilationUnitFromPath(handle, file);
        this.cuToHandle.put(unit, handle);
        return unit;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] determinePossibleSubTypes(HashSet localTypes, IProgressMonitor monitor) {
        class PathCollector
        implements IPathRequestor {
            HashSet paths;
            final /* synthetic */ IndexBasedHierarchyBuilder this$0;
            private final /* synthetic */ HashSet val$localTypes;

            PathCollector(IndexBasedHierarchyBuilder indexBasedHierarchyBuilder, HashSet hashSet) {
                this.this$0 = indexBasedHierarchyBuilder;
                this.val$localTypes = hashSet;
                this.paths = new HashSet<E>(10);
            }

            public void acceptPath(String path, boolean containsLocalTypes) {
                this.paths.add(path);
                if (containsLocalTypes) {
                    this.val$localTypes.add(path);
                }
            }
        }
        PathCollector collector;
        block7: {
            collector = new PathCollector(this, localTypes);
            try {
                if (monitor != null) {
                    monitor.beginTask("", 800);
                }
                IndexBasedHierarchyBuilder.searchAllPossibleSubTypes(this.getType(), this.scope, this.binariesFromIndexMatches, collector, 3, monitor);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            {
                Object var4_7 = null;
                if (monitor == null) break block7;
            }
            monitor.done();
        }
        HashSet paths = collector.paths;
        int length = paths.size();
        String[] result = new String[length];
        int count = 0;
        Iterator iter = paths.iterator();
        while (iter.hasNext()) {
            result[count++] = (String)iter.next();
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void searchAllPossibleSubTypes(IType type, IDLTKSearchScope scope, Map binariesFromIndexMatches, final IPathRequestor pathRequestor, int waitingPolicy, IProgressMonitor progressMonitor) {
        final Queue queue = new Queue();
        final HashtableOfObject foundSuperNames = new HashtableOfObject(5);
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                SuperTypeReferencePattern record = (SuperTypeReferencePattern)indexRecord;
                boolean isLocalOrAnonymous = record.enclosingTypeName == IIndexConstants.ONE_ZERO;
                pathRequestor.acceptPath(documentPath, isLocalOrAnonymous);
                char[] typeName = record.simpleName;
                if (!isLocalOrAnonymous && !foundSuperNames.containsKey(typeName)) {
                    foundSuperNames.put(typeName, typeName);
                    queue.add(typeName);
                }
                return true;
            }
        };
        int superRefKind = 0;
        SuperTypeReferencePattern pattern = new SuperTypeReferencePattern(null, null, superRefKind, 8, scope.getLanguageToolkit());
        MatchLocator.setFocus(pattern, type);
        SubTypeSearchJob job = new SubTypeSearchJob(pattern, new DLTKSearchParticipant(), scope, searchRequestor);
        int ticks = 0;
        queue.add(type.getElementName().toCharArray());
        try {
            while (queue.start <= queue.end) {
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    Object var15_15 = null;
                    job.finished();
                    return;
                }
                char[] currentTypeName = queue.retrieve();
                if (CharOperation.equals(currentTypeName, IIndexConstants.OBJECT)) {
                    currentTypeName = null;
                }
                pattern.superSimpleName = currentTypeName;
                indexManager.performConcurrentJob(job, waitingPolicy, null);
                if (progressMonitor != null && ++ticks <= 800) {
                    progressMonitor.worked(1);
                }
                if (currentTypeName != null) continue;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            job.finished();
            throw throwable;
        }
        {
            Object var15_17 = null;
            job.finished();
            return;
        }
    }

    static class Queue {
        public char[][] names = new char[10][];
        public int start = 0;
        public int end = -1;

        Queue() {
        }

        public void add(char[] name) {
            if (++this.end == this.names.length) {
                this.end -= this.start;
                char[][] cArrayArray = new char[this.end * 2][];
                this.names = cArrayArray;
                System.arraycopy(this.names, this.start, cArrayArray, 0, this.end);
                this.start = 0;
            }
            this.names[this.end] = name;
        }

        public char[] retrieve() {
            if (this.start > this.end) {
                return null;
            }
            char[] name = this.names[this.start++];
            if (this.start > this.end) {
                this.start = 0;
                this.end = -1;
            }
            return name;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer("Queue:\n");
            int i = this.start;
            while (i <= this.end) {
                buffer.append(this.names[i]).append('\n');
                ++i;
            }
            return buffer.toString();
        }
    }
}

