/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.mixin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.mixin.IMixinParser;
import org.eclipse.dltk.core.mixin.IMixinRequestor;
import org.eclipse.dltk.core.search.SearchDocument;
import org.eclipse.dltk.core.search.index.MixinIndex;
import org.eclipse.dltk.core.search.indexing.AbstractIndexer;
import org.eclipse.dltk.internal.core.mixin.MixinManager;

public class MixinIndexer
extends AbstractIndexer {
    private final ISourceModule sourceModule;

    public MixinIndexer(SearchDocument document, ISourceModule module) {
        super(document);
        this.sourceModule = module;
    }

    public void indexDocument() {
        IDLTKLanguageToolkit toolkit = this.document.getToolkit();
        if (toolkit == null) {
            toolkit = DLTKLanguageManager.findToolkit((IPath)new Path(this.document.getPath()));
        }
        if (toolkit == null) {
            return;
        }
        try {
            IMixinParser parser = MixinManager.getMixinParser(toolkit.getNatureId());
            if (parser != null) {
                MixinIndexRequestor requestor = new MixinIndexRequestor();
                parser.setRequirestor(requestor);
                parser.parserSourceModule(false, this.sourceModule);
                if (requestor.count == 0) {
                    ((MixinIndex)this.document.getIndex()).addDocumentName(this.document.getContainerRelativePath());
                }
            }
        }
        catch (CoreException e) {
            DLTKCore.error("Error in MixinIndexer", e);
        }
    }

    private class MixinIndexRequestor
    implements IMixinRequestor {
        int count = 0;

        private MixinIndexRequestor() {
        }

        public void reportElement(IMixinRequestor.ElementInfo info) {
            if (info.key.length() > 0) {
                MixinIndexer.this.addIndexEntry(MIXIN, info.key.toCharArray());
                ++this.count;
            }
        }
    }
}

