/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPTreeViewer;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.OpenActionUtil;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class OpenAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;

    public OpenAction(IWorkbenchSite site) {
        super(site);
        this.setText(PHPUIMessages.getString("OpenAction_label"));
        this.setToolTipText(PHPUIMessages.getString("OpenAction_tooltip"));
        this.setDescription(PHPUIMessages.getString("OpenAction_description"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ui.ide.open_resource_action_context");
    }

    public OpenAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(EditorUtility.getEditorInputModelElement((IEditorPart)this.fEditor, (boolean)false) != null);
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
    }

    public boolean isEnabled() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            return this.checkEnabled(structuredSelection);
        }
        return true;
    }

    private boolean checkEnabled(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        for (Object element : selection) {
            if (element instanceof ISourceModule || element instanceof IFile || element instanceof IStorage) continue;
            return false;
        }
        return true;
    }

    public void run(ITextSelection selection) {
        if (!ActionUtils.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        IModelElement[] element = null;
        try {
            element = SelectionConverter.codeResolve(this.fEditor);
        }
        catch (ModelException e) {
            Logger.logException(e);
        }
        if (element == null) {
            IEditorStatusLine statusLine = (IEditorStatusLine)this.fEditor.getAdapter(IEditorStatusLine.class);
            if (statusLine != null) {
                statusLine.setMessage(true, PHPUIMessages.getString("OpenAction_error_messageBadSelection"), null);
            }
            this.getShell().getDisplay().beep();
            return;
        }
        this.run(new Object[]{element}, null);
    }

    public void run(IStructuredSelection selection) {
        if (!this.checkEnabled(selection)) {
            return;
        }
        this.run(selection.toArray(), ((PHPTreeViewer)this.getSelectionProvider()).getTree().getSelection());
    }

    public void run(Object[] elements, Object[] treeNodes) {
        if (elements == null) {
            return;
        }
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            try {
                boolean activateOnOpen;
                element = this.getElementToOpen(element);
                boolean bl = activateOnOpen = this.fEditor != null ? true : OpenStrategy.activateOnOpen();
                if (element instanceof ISourceModule && treeNodes != null) {
                    OpenActionUtil.open(treeNodes[i], activateOnOpen);
                } else {
                    OpenActionUtil.open(element, activateOnOpen);
                }
            }
            catch (PartInitException partInitException) {
                MessageDialog.openError((Shell)this.getShell(), (String)PHPUIMessages.getString("OpenAction_error_messageProblems"), (String)"");
            }
            ++i;
        }
    }

    public Object getElementToOpen(Object object) {
        return object;
    }

    private String getDialogTitle() {
        return PHPUIMessages.getString("OpenAction_error_title");
    }
}

