/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.dialogs.saveFiles;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.dialogs.saveFiles.SaveFilesHandler;
import org.eclipse.php.internal.ui.util.ListContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class SaveFilesDialog
extends ListSelectionDialog {
    boolean promptAutoSave;
    SaveFilesHandler.SaveFilesResult result;

    public SaveFilesDialog(Shell parent, List dirtyEditors, SaveFilesHandler.SaveFilesResult result, boolean promptAutoSave) {
        super(parent, (Object)dirtyEditors, (IStructuredContentProvider)new ListContentProvider(), (ILabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                IEditorPart editor = (IEditorPart)element;
                IFile file = (IFile)editor.getEditorInput().getAdapter(IResource.class);
                String title = editor.getTitle();
                if (file == null) {
                    return title;
                }
                return MessageFormat.format("{0} [{1}]", title, file.getFullPath().toString());
            }
        }, PHPUIMessages.getString("SaveFilesDialog.1"));
        this.promptAutoSave = promptAutoSave;
        this.result = result;
        this.setTitle(PHPUIMessages.getString("SaveFilesDialog.2"));
        this.setMessage(PHPUIMessages.getString("SaveFilesDialog.3"));
    }

    protected Control createDialogArea(Composite container) {
        Composite area = (Composite)super.createDialogArea(container);
        if (this.promptAutoSave) {
            final Button check = new Button(area, 32);
            check.setText(PHPUIMessages.getString("SaveFilesDialog.4"));
            check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SaveFilesDialog.this.result.setAutoSave(check.getSelection());
                }
            });
            SaveFilesDialog.applyDialogFont((Control)area);
        }
        return area;
    }
}

