/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.ast.nodes.ASTNode;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Program;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.ast.visitor.ApplyAll;
import org.eclipse.php.internal.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.IPhpScriptReconcilingListener;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.editor.SemanticHighlighting;
import org.eclipse.php.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.php.internal.ui.editor.SemanticHighlightingPresenter;
import org.eclipse.php.internal.ui.editor.SemanticToken;
import org.eclipse.php.ui.editor.SharedASTProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public class SemanticHighlightingReconciler
implements IPhpScriptReconcilingListener {
    private PositionCollector fCollector = new PositionCollector();
    private PHPStructuredEditor fEditor;
    private ISourceViewer fSourceViewer;
    private SemanticHighlightingPresenter fPresenter;
    private SemanticHighlighting[] fSemanticHighlightings;
    private SemanticHighlightingManager.Highlighting[] fHighlightings;
    private List fAddedPositions = new ArrayList();
    private List fRemovedPositions = new ArrayList();
    private int fNOfRemovedPositions;
    private Job fJob;
    private final Object fJobLock = new Object();
    private final Object fReconcileLock = new Object();
    private boolean fIsReconciling = false;
    private SemanticHighlightingPresenter fJobPresenter;
    private SemanticHighlighting[] fJobSemanticHighlightings;
    private SemanticHighlightingManager.Highlighting[] fJobHighlightings;

    public void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconciled(Program ast, boolean forced, IProgressMonitor progressMonitor) {
        Object object = this.fReconcileLock;
        synchronized (object) {
            if (this.fIsReconciling) {
                return;
            }
            this.fIsReconciling = true;
        }
        this.fJobPresenter = this.fPresenter;
        this.fJobSemanticHighlightings = this.fSemanticHighlightings;
        this.fJobHighlightings = this.fHighlightings;
        try {
            ASTNode[] subtrees;
            block22: {
                block21: {
                    if (this.fJobPresenter == null || this.fJobSemanticHighlightings == null || this.fJobHighlightings == null) break block21;
                    this.fJobPresenter.setCanceled(progressMonitor.isCanceled());
                    if (ast != null && !this.fJobPresenter.isCanceled() && (subtrees = this.getAffectedSubtrees((ASTNode)ast)).length != 0) break block22;
                }
                this.fJobPresenter = null;
                this.fJobSemanticHighlightings = null;
                this.fJobHighlightings = null;
                Object object2 = this.fReconcileLock;
                synchronized (object2) {
                    this.fIsReconciling = false;
                    return;
                }
            }
            this.startReconcilingPositions();
            if (!this.fJobPresenter.isCanceled()) {
                this.reconcilePositions(subtrees);
            }
            TextPresentation textPresentation = null;
            if (!this.fJobPresenter.isCanceled() && !this.fJobPresenter.isCanceled()) {
                this.updatePresentation(textPresentation, this.fAddedPositions, this.fRemovedPositions);
            }
            this.stopReconcilingPositions();
        }
        catch (Throwable throwable) {
            this.fJobPresenter = null;
            this.fJobSemanticHighlightings = null;
            this.fJobHighlightings = null;
            Object object3 = this.fReconcileLock;
            synchronized (object3) {
                this.fIsReconciling = false;
                throw throwable;
            }
        }
        this.fJobPresenter = null;
        this.fJobSemanticHighlightings = null;
        this.fJobHighlightings = null;
        Object object4 = this.fReconcileLock;
        synchronized (object4) {
            this.fIsReconciling = false;
            return;
        }
    }

    private ASTNode[] getAffectedSubtrees(ASTNode node) {
        return new ASTNode[]{node};
    }

    private void startReconcilingPositions() {
        this.fJobPresenter.addAllPositions(this.fRemovedPositions);
        this.fNOfRemovedPositions = this.fRemovedPositions.size();
    }

    private void reconcilePositions(ASTNode[] subtrees) {
        int i = 0;
        int n = subtrees.length;
        while (i < n) {
            subtrees[i].accept((Visitor)this.fCollector);
            ++i;
        }
        List oldPositions = this.fRemovedPositions;
        ArrayList newPositions = new ArrayList(this.fNOfRemovedPositions);
        int i2 = 0;
        int n2 = oldPositions.size();
        while (i2 < n2) {
            Object current = oldPositions.get(i2);
            if (current != null) {
                newPositions.add(current);
            }
            ++i2;
        }
        this.fRemovedPositions = newPositions;
    }

    private void updatePresentation(TextPresentation textPresentation, List addedPositions, List removedPositions) {
        Runnable runnable = this.fJobPresenter.createUpdateRunnable(textPresentation, addedPositions, removedPositions);
        if (runnable == null) {
            return;
        }
        PHPStructuredEditor editor = this.fEditor;
        if (editor == null) {
            return;
        }
        IWorkbenchPartSite site = editor.getSite();
        if (site == null) {
            return;
        }
        Shell shell = site.getShell();
        if (shell == null || shell.isDisposed()) {
            return;
        }
        Display display = shell.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(runnable);
    }

    private void stopReconcilingPositions() {
        this.fRemovedPositions.clear();
        this.fNOfRemovedPositions = 0;
        this.fAddedPositions.clear();
    }

    public void install(PHPStructuredEditor editor, ISourceViewer sourceViewer, SemanticHighlightingPresenter presenter, SemanticHighlighting[] semanticHighlightings, SemanticHighlightingManager.Highlighting[] highlightings) {
        this.fPresenter = presenter;
        this.fSemanticHighlightings = semanticHighlightings;
        this.fHighlightings = highlightings;
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        this.fEditor.addReconcileListener(this);
    }

    public void uninstall() {
        if (this.fPresenter != null) {
            this.fPresenter.setCanceled(true);
        }
        this.fEditor.removeReconcileListener(this);
        this.fSourceViewer = null;
        this.fSemanticHighlightings = null;
        this.fHighlightings = null;
        this.fPresenter = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJob() {
        final ISourceModule element = (ISourceModule)this.fEditor.getModelElement();
        Object object = this.fJobLock;
        synchronized (object) {
            final Job oldJob = this.fJob;
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
            if (element != null) {
                this.fJob = new Job(PHPUIMessages.getString("SemanticHighlighting_job")){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    protected IStatus run(IProgressMonitor monitor) {
                        Program ast;
                        if (oldJob != null) {
                            try {
                                oldJob.join();
                            }
                            catch (InterruptedException e) {
                                PHPCorePlugin.log((Throwable)e);
                                return Status.CANCEL_STATUS;
                            }
                        }
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        try {
                            ast = SharedASTProvider.getAST(element, SharedASTProvider.WAIT_YES, monitor);
                        }
                        catch (ModelException e) {
                            PHPCorePlugin.log((Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                        catch (IOException e) {
                            PHPCorePlugin.log((Throwable)e);
                            return Status.CANCEL_STATUS;
                        }
                        SemanticHighlightingReconciler.this.reconciled(ast, false, monitor);
                        Object object = SemanticHighlightingReconciler.this.fJobLock;
                        synchronized (object) {
                            if (SemanticHighlightingReconciler.this.fJob == this) {
                                SemanticHighlightingReconciler.this.fJob = null;
                            }
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.fJob.setSystem(true);
                this.fJob.setPriority(50);
                this.fJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        Object object = this.fJobLock;
        synchronized (object) {
            if (this.fJob != null) {
                this.fJob.cancel();
                this.fJob = null;
            }
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.scheduleJob();
        }
    }

    public void refresh() {
        this.scheduleJob();
    }

    private class PositionCollector
    extends ApplyAll {
        private SemanticToken fToken = new SemanticToken();

        private PositionCollector() {
        }

        protected boolean apply(ASTNode node) {
            if ((node.getFlags() & 1) == 1) {
                this.retainPositions(node.getStart(), node.getLength());
                return false;
            }
            return true;
        }

        public boolean visit(Scalar node) {
            this.fToken.update((Expression)node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumesLiteral(this.fToken)) {
                    int offset = node.getStart();
                    int length = node.getLength();
                    if (offset <= -1 || length <= 0) break;
                    this.addPosition(offset, length, SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return false;
        }

        public boolean visit(Identifier node) {
            this.fToken.update(node);
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fJobSemanticHighlightings.length;
            while (i < n) {
                SemanticHighlighting semanticHighlighting = SemanticHighlightingReconciler.this.fJobSemanticHighlightings[i];
                if (SemanticHighlightingReconciler.this.fJobHighlightings[i].isEnabled() && semanticHighlighting.consumes(this.fToken)) {
                    int offset = node.getStart();
                    int length = node.getLength();
                    if (offset <= -1 || length <= 0) break;
                    this.addPosition(offset, length, SemanticHighlightingReconciler.this.fJobHighlightings[i]);
                    break;
                }
                ++i;
            }
            this.fToken.clear();
            return false;
        }

        private void addPosition(int offset, int length, SemanticHighlightingManager.Highlighting highlighting) {
            boolean isExisting = false;
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position != null && position.isEqual(offset, length, highlighting)) {
                    isExisting = true;
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                    break;
                }
                ++i;
            }
            if (!isExisting) {
                SemanticHighlightingManager.HighlightedPosition position = SemanticHighlightingReconciler.this.fJobPresenter.createHighlightedPosition(offset, length, highlighting);
                SemanticHighlightingReconciler.this.fAddedPositions.add(position);
            }
        }

        private void retainPositions(int offset, int length) {
            int i = 0;
            int n = SemanticHighlightingReconciler.this.fRemovedPositions.size();
            while (i < n) {
                SemanticHighlightingManager.HighlightedPosition position = (SemanticHighlightingManager.HighlightedPosition)((Object)SemanticHighlightingReconciler.this.fRemovedPositions.get(i));
                if (position != null && position.isContained(offset, length)) {
                    SemanticHighlightingReconciler.this.fRemovedPositions.set(i, null);
                    SemanticHighlightingReconciler semanticHighlightingReconciler = SemanticHighlightingReconciler.this;
                    semanticHighlightingReconciler.fNOfRemovedPositions = semanticHighlightingReconciler.fNOfRemovedPositions - 1;
                }
                ++i;
            }
        }
    }
}

