/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.configuration;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.dltk.internal.ui.typehierarchy.HierarchyInformationControl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.php.internal.core.format.FormatPreferencesSupport;
import org.eclipse.php.internal.core.format.PhpFormatProcessorImpl;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.autoEdit.CloseTagAutoEditStrategyPHP;
import org.eclipse.php.internal.ui.autoEdit.MainAutoEditStrategy;
import org.eclipse.php.internal.ui.doubleclick.PHPDoubleClickStrategy;
import org.eclipse.php.internal.ui.editor.PHPStructuredTextViewer;
import org.eclipse.php.internal.ui.editor.contentassist.PHPCompletionProcessor;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.php.internal.ui.editor.hover.PHPTextHoverProxy;
import org.eclipse.php.internal.ui.editor.hyperlink.PHPHyperlinkDetector;
import org.eclipse.php.internal.ui.text.PHPElementProvider;
import org.eclipse.php.internal.ui.text.PHPInformationHierarchyProvider;
import org.eclipse.php.internal.ui.text.PHPOutlineInformationControl;
import org.eclipse.php.internal.ui.text.hover.PHPEditorTextHoverDescriptor;
import org.eclipse.php.internal.ui.util.ElementCreationProxy;
import org.eclipse.php.ui.editor.hover.IHyperlinkDetectorForPHP;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.html.ui.StructuredTextViewerConfigurationHTML;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.format.StructuredFormattingStrategy;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.xml.core.internal.text.rules.StructuredTextPartitionerForXML;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPStructuredTextViewerConfiguration
extends StructuredTextViewerConfigurationHTML {
    private static final String PHP_CONTENT_ASSISTANT_EXT = "org.eclipse.php.ui.phpContentAssistant";
    private static final String CONTENT_ASSIST_PROCESSOR_EXT = "org.eclipse.php.ui.phpContentAssistProcessor";
    private static final String HYPERLINK_DETECTOR_EXT = "org.eclipse.php.ui.phpHyperlinkDetector";
    private static final String FORMATTER_PROCESSOR_EXT = "org.eclipse.php.ui.phpFormatterProcessor";
    private static final String SHOW_OUTLINE_PREF_KEY = "org.eclipse.php.ui.edit.text.php.show.outline";
    private static final String EMPTY = "";
    private static final String[] DEFAULT_PREFIXES = new String[]{"//", "#", ""};
    private static final IAutoEditStrategy mainAutoEditStrategy = new MainAutoEditStrategy();
    private static final IAutoEditStrategy closeTagAutoEditStrategy = new CloseTagAutoEditStrategyPHP();
    private static final IAutoEditStrategy[] phpStrategies = new IAutoEditStrategy[]{mainAutoEditStrategy};
    private String[] configuredContentTypes;
    private LineStyleProvider fLineStyleProvider;
    private StructuredContentAssistant fContentAssistant = null;

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        if (this.configuredContentTypes == null) {
            String[] phpTypes = PHPStructuredTextPartitioner.getConfiguredContentTypes();
            String[] xmlTypes = StructuredTextPartitionerForXML.getConfiguredContentTypes();
            String[] htmlTypes = StructuredTextPartitionerForHTML.getConfiguredContentTypes();
            this.configuredContentTypes = new String[2 + phpTypes.length + xmlTypes.length + htmlTypes.length];
            this.configuredContentTypes[0] = "org.eclipse.wst.sse.ST_DEFAULT";
            this.configuredContentTypes[1] = "org.eclipse.wst.sse.UNKNOWN_PARTITION_TYPE";
            int index = 0;
            System.arraycopy(phpTypes, 0, this.configuredContentTypes, index += 2, phpTypes.length);
            System.arraycopy(xmlTypes, 0, this.configuredContentTypes, index += phpTypes.length, xmlTypes.length);
            System.arraycopy(htmlTypes, 0, this.configuredContentTypes, index += xmlTypes.length, htmlTypes.length);
        }
        return this.configuredContentTypes;
    }

    public LineStyleProvider getLineStyleProvider() {
        if (this.fLineStyleProvider == null) {
            this.fLineStyleProvider = new LineStyleProviderForPhp();
        }
        return this.fLineStyleProvider;
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        if (partitionType == "org.eclipse.php.PHP_DEFAULT") {
            return new LineStyleProvider[]{this.getLineStyleProvider()};
        }
        return super.getLineStyleProviders(sourceViewer, partitionType);
    }

    public IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        IContentAssistProcessor[] processors = null;
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            if (partitionType == "org.eclipse.php.PHP_DEFAULT") {
                ArrayList<IContentAssistProcessor> processorsList = this.getPHPProcessors(partitionType, (PHPStructuredTextViewer)sourceViewer);
                processors = new IContentAssistProcessor[processorsList.size()];
                processorsList.toArray(processors);
            } else {
                ArrayList<IContentAssistProcessor> phpDocProcessors = this.getPHPProcessors(partitionType, (PHPStructuredTextViewer)sourceViewer);
                IContentAssistProcessor[] superProcessors = super.getContentAssistProcessors(sourceViewer, partitionType);
                if (superProcessors != null) {
                    IContentAssistProcessor[] iContentAssistProcessorArray = superProcessors;
                    int n = superProcessors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContentAssistProcessor processor = iContentAssistProcessorArray[n2];
                        phpDocProcessors.add(processor);
                        ++n2;
                    }
                }
                processors = new IContentAssistProcessor[phpDocProcessors.size()];
                phpDocProcessors.toArray(processors);
            }
        } else {
            processors = new IContentAssistProcessor[]{};
        }
        return processors;
    }

    private ArrayList<IContentAssistProcessor> getPHPProcessors(String partitionType, PHPStructuredTextViewer viewer) {
        ArrayList<IContentAssistProcessor> processors = new ArrayList<IContentAssistProcessor>();
        processors.add((IContentAssistProcessor)new PHPCompletionProcessor((IEditorPart)viewer.getTextEditor(), (ContentAssistant)this.getPHPContentAssistant((ISourceViewer)viewer), "org.eclipse.php.PHP_DEFAULT"));
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(CONTENT_ASSIST_PROCESSOR_EXT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("processor")) {
                ElementCreationProxy ecProxy;
                IContentAssistProcessor processor;
                String partitionTypeAtt = element.getAttribute("partitionType");
                if (partitionTypeAtt == null) {
                    partitionTypeAtt = "org.eclipse.php.PHP_DEFAULT";
                }
                if (partitionTypeAtt.equals(partitionType) && (processor = (IContentAssistProcessor)(ecProxy = new ElementCreationProxy(element, CONTENT_ASSIST_PROCESSOR_EXT)).getObject()) != null) {
                    processors.add(processor);
                }
            }
            ++i;
        }
        return processors;
    }

    public IContentAssistant getPHPContentAssistant(ISourceViewer sourceViewer) {
        return this.getPHPContentAssistant(sourceViewer, false);
    }

    public IContentAssistant getPHPContentAssistant(ISourceViewer sourceViewer, boolean reCreate) {
        if (this.fContentAssistant == null || reCreate) {
            this.fContentAssistant = this.getPHPContentAssistantExtension();
            if (this.fContentAssistant == null) {
                this.fContentAssistant = new StructuredContentAssistant();
            }
            this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fContentAssistant.setProposalPopupOrientation(10);
            this.fContentAssistant.setContextInformationPopupOrientation(20);
            this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            Preferences preferences = PHPCorePlugin.getDefault().getPluginPreferences();
            this.fContentAssistant.enableAutoActivation(preferences.getBoolean("contentAssistAutoactivation"));
            this.fContentAssistant.setAutoActivationDelay(preferences.getInt("contentAssistAutoactivationDelay"));
            this.fContentAssistant.enableAutoInsert(preferences.getBoolean("contentAssistAutoinsert"));
            String[] types = this.getConfiguredContentTypes(sourceViewer);
            int i = 0;
            while (i < types.length) {
                String type = types[i];
                IContentAssistProcessor[] processors = this.getContentAssistProcessors(sourceViewer, type);
                if (processors != null) {
                    int j = 0;
                    while (j < processors.length) {
                        this.fContentAssistant.setContentAssistProcessor(processors[j], type);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return this.fContentAssistant;
    }

    private StructuredContentAssistant getPHPContentAssistantExtension() {
        StructuredContentAssistant rv = null;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(PHP_CONTENT_ASSISTANT_EXT);
        int i = 0;
        while (i < elements.length) {
            ElementCreationProxy ecProxy;
            StructuredContentAssistant contentAssistant;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("contentAssistant") && (contentAssistant = (StructuredContentAssistant)(ecProxy = new ElementCreationProxy(element, PHP_CONTENT_ASSISTANT_EXT)).getObject()) != null) {
                rv = contentAssistant;
            }
            ++i;
        }
        return rv;
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return DEFAULT_PREFIXES;
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        PHPEditorTextHoverDescriptor[] hoverDescs = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        if (!PHPStructuredTextPartitioner.isPHPPartitionType((String)contentType)) {
            return super.getTextHover(sourceViewer, contentType, stateMask);
        }
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            PHPEditorTextHoverDescriptor[] hoverDescs = PHPUiPlugin.getDefault().getPHPEditorTextHoverDescriptors();
            int i = 0;
            while (i < hoverDescs.length) {
                if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                    return new PHPTextHoverProxy(hoverDescs[i], (IEditorPart)((PHPStructuredTextViewer)sourceViewer).getTextEditor(), this.fPreferenceStore);
                }
                ++i;
            }
        }
        return null;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return this.getTextHover(sourceViewer, contentType, 255);
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        if (!this.fPreferenceStore.getBoolean("hyperlinksEnabled")) {
            return null;
        }
        LinkedList<Object> detectors = new LinkedList<Object>();
        IHyperlinkDetector[] inheritedDetectors = super.getHyperlinkDetectors(sourceViewer);
        if (inheritedDetectors != null) {
            IHyperlinkDetector[] iHyperlinkDetectorArray = inheritedDetectors;
            int n = inheritedDetectors.length;
            int n2 = 0;
            while (n2 < n) {
                final IHyperlinkDetector detector = iHyperlinkDetectorArray[n2];
                detectors.add(new IHyperlinkDetector(){

                    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
                        try {
                            return detector.detectHyperlinks(textViewer, region, canShowMultipleHyperlinks);
                        }
                        catch (Throwable throwable) {
                            return null;
                        }
                    }
                });
                ++n2;
            }
        }
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            detectors.add(new PHPHyperlinkDetector((IEditorPart)((PHPStructuredTextViewer)sourceViewer).getTextEditor()));
        }
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(HYPERLINK_DETECTOR_EXT);
        int i = 0;
        while (i < elements.length) {
            ElementCreationProxy ecProxy;
            IHyperlinkDetectorForPHP detector;
            IConfigurationElement element = elements[i];
            if (element.getName().equals("detector") && (detector = (IHyperlinkDetectorForPHP)(ecProxy = new ElementCreationProxy(element, HYPERLINK_DETECTOR_EXT)).getObject()) != null) {
                detectors.add(detector);
            }
            ++i;
        }
        return detectors.toArray(new IHyperlinkDetector[detectors.size()]);
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        MultiPassContentFormatter usedFormatter = null;
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(FORMATTER_PROCESSOR_EXT);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("processor")) {
                ElementCreationProxy ecProxy = new ElementCreationProxy(element, FORMATTER_PROCESSOR_EXT);
                usedFormatter = (IContentFormatter)ecProxy.getObject();
            }
            ++i;
        }
        if (usedFormatter == null) {
            usedFormatter = new MultiPassContentFormatter(this.getConfiguredDocumentPartitioning(sourceViewer), "org.eclipse.wst.html.HTML_DEFAULT");
            usedFormatter.setMasterStrategy((IFormattingStrategy)new StructuredFormattingStrategy((IStructuredFormatProcessor)new PhpFormatProcessorImpl()));
        }
        return usedFormatter;
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("org.eclipse.php.PHP_DEFAULT")) {
            return phpStrategies;
        }
        return this.getPhpAutoEditStrategy(sourceViewer, contentType);
    }

    private final IAutoEditStrategy[] getPhpAutoEditStrategy(ISourceViewer sourceViewer, String contentType) {
        IAutoEditStrategy[] autoEditStrategies = super.getAutoEditStrategies(sourceViewer, contentType);
        int length = autoEditStrategies.length;
        IAutoEditStrategy[] augAutoEditStrategies = new IAutoEditStrategy[length + 1];
        System.arraycopy(autoEditStrategies, 0, augAutoEditStrategies, 0, length);
        augAutoEditStrategies[length] = closeTagAutoEditStrategy;
        return augAutoEditStrategies;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (contentType == "org.eclipse.php.PHP_DEFAULT") {
            return new PHPDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        Vector<String> vector = new Vector<String>();
        char indentCharPref = FormatPreferencesSupport.getInstance().getIndentationChar(null);
        int indentationSize = FormatPreferencesSupport.getInstance().getIndentationSize(null);
        int i = 0;
        while (i <= indentationSize) {
            StringBuffer prefix = new StringBuffer();
            boolean appendTab = false;
            int j = 0;
            while (j + i < indentationSize) {
                prefix.append(indentCharPref);
                ++j;
            }
            if (i != 0) {
                appendTab = true;
            }
            if (appendTab) {
                prefix.append('\t');
                vector.add(prefix.toString());
                prefix.deleteCharAt(prefix.length() - 1);
            }
            vector.add(prefix.toString());
            ++i;
        }
        vector.add(EMPTY);
        return vector.toArray(new String[vector.size()]);
    }

    public IInformationPresenter getOutlinePresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = null;
        if (sourceViewer instanceof PHPStructuredTextViewer) {
            presenter = new InformationPresenter(this.getOutlinePresenterControlCreator(sourceViewer, SHOW_OUTLINE_PREF_KEY));
            presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
            PHPElementProvider provider = new PHPElementProvider((IEditorPart)((PHPStructuredTextViewer)sourceViewer).getTextEditor());
            presenter.setInformationProvider((IInformationProvider)provider, "org.eclipse.php.PHP_DEFAULT");
            presenter.setSizeConstraints(50, 20, true, false);
        }
        return presenter;
    }

    public IInformationPresenter getHierarchyPresenter(PHPStructuredTextViewer viewer, boolean doCodeResolve) {
        if (viewer.getTextEditor() == null || viewer.getTextEditor().getEditorInput() == null) {
            return null;
        }
        InformationPresenter presenter = new InformationPresenter(this.getHierarchyPresenterControlCreator());
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning((ISourceViewer)viewer));
        presenter.setAnchor(AbstractInformationControlManager.ANCHOR_GLOBAL);
        PHPInformationHierarchyProvider provider = new PHPInformationHierarchyProvider((IEditorPart)viewer.getTextEditor(), doCodeResolve);
        presenter.setInformationProvider((IInformationProvider)provider, "org.eclipse.php.PHP_DEFAULT");
        presenter.setSizeConstraints(50, 20, true, false);
        return presenter;
    }

    private IInformationControlCreator getHierarchyPresenterControlCreator() {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new HierarchyInformationControl(parent, shellStyle, treeStyle){

                    protected IPreferenceStore getPreferenceStore() {
                        return PHPUiPlugin.getDefault().getPreferenceStore();
                    }
                };
            }
        };
    }

    private IInformationControlCreator getOutlinePresenterControlCreator(ISourceViewer sourceViewer, final String commandId) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 16;
                int treeStyle = 768;
                return new PHPOutlineInformationControl(parent, shellStyle, treeStyle, commandId);
            }
        };
    }
}

