/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.explorer;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IOpenable;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.core.BuildpathEntry;
import org.eclipse.dltk.internal.core.ExternalProjectFragment;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.ui.navigator.ScriptExplorerContentProvider;
import org.eclipse.dltk.internal.ui.scriptview.BuildPathContainer;
import org.eclipse.php.internal.core.includepath.IIncludepathListener;
import org.eclipse.php.internal.core.includepath.IncludePath;
import org.eclipse.php.internal.core.includepath.IncludePathManager;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;

public class PHPExplorerContentProvider
extends ScriptExplorerContentProvider
implements IIncludepathListener {
    public PHPExplorerContentProvider(boolean provideMembers) {
        super(provideMembers);
        IncludePathManager.getInstance().registerIncludepathListener((IIncludepathListener)this);
        this.setIsFlatLayout(false);
    }

    public void setIsFlatLayout(boolean state) {
        super.setIsFlatLayout(false);
    }

    public void dispose() {
        super.dispose();
        IncludePathManager.getInstance().unregisterIncludepathListener((IIncludepathListener)this);
    }

    public Object[] getChildren(Object parentElement) {
        Object entry;
        if (parentElement instanceof IncludePath && (entry = ((IncludePath)parentElement).getEntry()) instanceof IBuildpathEntry) {
            IProjectFragment[] findProjectFragments;
            IScriptProject scriptProject = DLTKCore.create((IProject)((IncludePath)parentElement).getProject());
            IProjectFragment[] iProjectFragmentArray = findProjectFragments = scriptProject.findProjectFragments((IBuildpathEntry)entry);
            if (findProjectFragments.length != 0) {
                IProjectFragment projectFragment = iProjectFragmentArray[0];
                return this.getChildren(projectFragment);
            }
            return this.getChildren(((BuildpathEntry)entry).getPath());
        }
        try {
            if (parentElement instanceof ISourceModule || !(parentElement instanceof IOpenable) || parentElement instanceof ExternalProjectFragment) {
                if (parentElement instanceof IFolder) {
                    return ((IFolder)parentElement).members();
                }
                return super.getChildren(parentElement);
            }
            if (parentElement instanceof IOpenable) {
                if (parentElement instanceof ExternalScriptFolder) {
                    return super.getChildren(parentElement);
                }
                IResource resource = ((IOpenable)parentElement).getResource();
                if (resource instanceof IContainer) {
                    Object modelElement;
                    IResource[] resChildren = ((IContainer)resource).members();
                    ArrayList<Object> returnChlidren = new ArrayList<Object>();
                    IResource[] iResourceArray = resChildren;
                    int n = resChildren.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource2 = iResourceArray[n2];
                        modelElement = DLTKCore.create((IResource)resource2);
                        if (modelElement != null) {
                            returnChlidren.add(modelElement);
                        } else {
                            returnChlidren.add(resource2);
                        }
                        ++n2;
                    }
                    if (parentElement instanceof IScriptProject) {
                        Object[] projectChildren;
                        IScriptProject project = (IScriptProject)parentElement;
                        IncludePath[] includePaths = IncludePathManager.getInstance().getIncludePaths(project.getProject());
                        IncludePathContainer incPathContainer = new IncludePathContainer(project, includePaths);
                        returnChlidren.add((Object)incPathContainer);
                        Object[] objectArray = projectChildren = this.getProjectFragments(project);
                        int n3 = projectChildren.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            modelElement = objectArray[n4];
                            if (modelElement instanceof BuildPathContainer) {
                                returnChlidren.add(modelElement);
                            }
                            ++n4;
                        }
                    }
                    return returnChlidren.toArray();
                }
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return NO_CHILDREN;
    }

    public void refresh(IProject project) {
        ArrayList runnables = new ArrayList();
        ArrayList<IScriptProject> resources = new ArrayList<IScriptProject>(1);
        resources.add(DLTKCore.create((IProject)project));
        this.postRefresh(resources, true, runnables);
        this.executeRunnables(runnables);
    }

    protected class IncludePathContainer
    extends BuildPathContainer {
        private IncludePath[] fIncludePath;

        public IncludePathContainer(IScriptProject parent, IncludePath[] entries) {
            super(parent, DLTKCore.newContainerEntry((IPath)parent.getPath()));
            this.fIncludePath = entries;
        }

        public String getLabel() {
            return PHPUIMessages.getString("IncludePathExplorerNode_label");
        }

        public IAdaptable[] getChildren() {
            return this.fIncludePath;
        }
    }
}

