/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.outline;

import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.SortAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.outline.ChangeOutlineModeAction;
import org.eclipse.php.internal.ui.outline.PHPNodeActionManager;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.outline.PHPOutlineLabelProvider;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wst.html.ui.views.contentoutline.HTMLContentOutlineConfiguration;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeContentProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.contentoutline.XMLNodeActionManager;

public class PHPContentOutlineConfiguration
extends HTMLContentOutlineConfiguration {
    protected PHPOutlineContentProvider fContentProvider = null;
    protected JFaceNodeContentProvider fContentProviderHTML = null;
    protected DecoratingModelLabelProvider fLabelProvider = null;
    protected PHPOutlineLabelProvider fLabelProviderHTML = null;
    private IPropertyChangeListener propertyChangeListener;
    private ChangeOutlineModeAction changeOutlineModeActionPHP;
    private ChangeOutlineModeAction changeOutlineModeActionHTML;
    static Object[] NO_CHILDREN = new Object[0];
    public static final int MODE_HTML = 2;
    public static final int MODE_PHP = 1;
    private int mode;
    private SortAction sortAction;
    private JFaceNodeLabelProvider fSimpleLabelProvider;
    protected IPreferenceStore fStore = PHPUiPlugin.getDefault().getPreferenceStore();

    public PHPContentOutlineConfiguration() {
        this.mode = PHPUiPlugin.getDefault().getPreferenceStore().getInt("ChangeOutlineModeAction.selectedMode");
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    protected IContributionItem[] createMenuContributions(TreeViewer viewer) {
        this.changeOutlineModeActionPHP = new ChangeOutlineModeAction(PHPUIMessages.getString("PHPOutlinePage_mode_php"), 1, this, viewer);
        ActionContributionItem showPHPItem = new ActionContributionItem((IAction)this.changeOutlineModeActionPHP);
        this.changeOutlineModeActionHTML = new ChangeOutlineModeAction(PHPUIMessages.getString("PHPOutlinePage_mode_html"), 2, this, viewer);
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("checked")) {
                    boolean checked = (Boolean)event.getNewValue();
                    if (PHPContentOutlineConfiguration.this.sortAction != null) {
                        PHPContentOutlineConfiguration.this.sortAction.setEnabled(!checked);
                    }
                }
            }
        };
        this.changeOutlineModeActionHTML.addPropertyChangeListener(this.propertyChangeListener);
        ActionContributionItem showHTMLItem = new ActionContributionItem((IAction)this.changeOutlineModeActionHTML);
        IContributionItem[] items = super.createMenuContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{showPHPItem, showHTMLItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 2];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = showPHPItem;
            combinedItems[items.length + 1] = showHTMLItem;
            items = combinedItems;
        }
        if (this.changeOutlineModeActionHTML.isChecked()) {
            this.sortAction.setEnabled(false);
        }
        return items;
    }

    protected IContributionItem[] createToolbarContributions(TreeViewer viewer) {
        IContributionItem[] menuContributions = super.createMenuContributions(viewer);
        IContributionItem toggleLinking = menuContributions[0];
        int i = 1;
        while (i < menuContributions.length) {
            menuContributions[i].dispose();
            ++i;
        }
        this.sortAction = new SortAction(viewer);
        ActionContributionItem sortItem = new ActionContributionItem((IAction)this.sortAction);
        IContributionItem[] items = super.createToolbarContributions(viewer);
        if (items == null) {
            items = new IContributionItem[]{sortItem};
        } else {
            IContributionItem[] combinedItems = new IContributionItem[items.length + 2];
            System.arraycopy(items, 0, combinedItems, 0, items.length);
            combinedItems[items.length] = sortItem;
            combinedItems[items.length + 1] = toggleLinking;
            items = combinedItems;
        }
        return items;
    }

    public void unconfigure(TreeViewer viewer) {
        if (this.changeOutlineModeActionHTML != null && this.propertyChangeListener != null) {
            this.changeOutlineModeActionHTML.removePropertyChangeListener(this.propertyChangeListener);
        }
        super.unconfigure(viewer);
    }

    public IContentProvider getContentProvider(TreeViewer viewer) {
        if (1 == this.mode) {
            if (this.fContentProvider == null) {
                this.fContentProvider = new PHPOutlineContentProvider(viewer);
            }
            viewer.setContentProvider((IContentProvider)this.fContentProvider);
        } else if (2 == this.mode) {
            if (this.fContentProviderHTML == null) {
                this.fContentProviderHTML = new JFaceNodeContentProvider(){

                    public Object[] getElements(Object object) {
                        IEditorPart activeEditor;
                        if (object instanceof ISourceModule && (activeEditor = PHPUiPlugin.getActiveEditor()) instanceof StructuredTextEditor) {
                            StructuredTextEditor editor = (StructuredTextEditor)activeEditor;
                            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                            IStructuredModel model = null;
                            try {
                                model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                                Object[] objectArray = super.getElements((Object)model);
                                return objectArray;
                            }
                            finally {
                                if (model != null) {
                                    model.releaseFromRead();
                                }
                            }
                        }
                        return super.getElements(object);
                    }
                };
            }
            viewer.setContentProvider((IContentProvider)this.fContentProviderHTML);
        }
        return viewer.getContentProvider();
    }

    public ILabelProvider getLabelProvider(TreeViewer viewer) {
        if (1 == this.mode) {
            if (this.fLabelProvider == null) {
                AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(0x201000000402BL | ScriptElementLabels.ALL_CATEGORY, 1, this.fStore);
                this.fLabelProvider = new DecoratingModelLabelProvider((ScriptUILabelProvider)lprovider);
            }
            viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
        } else if (2 == this.mode) {
            if (this.fLabelProviderHTML == null) {
                this.fLabelProviderHTML = new PHPOutlineLabelProvider();
            }
            viewer.setLabelProvider((IBaseLabelProvider)this.fLabelProviderHTML);
        }
        return (ILabelProvider)viewer.getLabelProvider();
    }

    public ISelection getSelection(TreeViewer viewer, ISelection selection) {
        ISourceReference computedSourceReference;
        IEditorPart activeEditor;
        IContentProvider contentProvider = viewer.getContentProvider();
        if (contentProvider instanceof PHPOutlineContentProvider && 1 == this.mode && selection instanceof IStructuredSelection && selection instanceof TextSelection && (activeEditor = PHPUiPlugin.getActiveEditor()) instanceof PHPStructuredEditor && (computedSourceReference = ((PHPStructuredEditor)activeEditor).computeHighlightRangeSourceReference()) != null) {
            return new StructuredSelection((Object)computedSourceReference);
        }
        return super.getSelection(viewer, selection);
    }

    public ILabelProvider getStatusLineLabelProvider(TreeViewer treeViewer) {
        if (this.fSimpleLabelProvider == null) {
            this.getLabelProvider(treeViewer);
        }
        return this.fSimpleLabelProvider;
    }

    protected XMLNodeActionManager createNodeActionManager(TreeViewer treeViewer) {
        IEditorPart activeEditor = PHPUiPlugin.getActiveEditor();
        if (activeEditor instanceof StructuredTextEditor) {
            StructuredTextEditor editor = (StructuredTextEditor)activeEditor;
            IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
            IStructuredModel model = null;
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
                PHPNodeActionManager pHPNodeActionManager = new PHPNodeActionManager(model, (Viewer)treeViewer);
                return pHPNodeActionManager;
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                }
            }
        }
        return null;
    }

    protected void enableShowAttributes(boolean showAttributes, TreeViewer treeViewer) {
        super.enableShowAttributes(showAttributes, treeViewer);
        if (this.fLabelProviderHTML != null) {
            this.fLabelProviderHTML.fShowAttributes = showAttributes;
        }
    }
}

