/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.breakpoints;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPConditionalBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPLineBreakpoint;
import org.eclipse.php.internal.debug.core.model.PHPRunToLineBreakpoint;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpBreakpoint;

public class PdtBreakpoint
implements DBGpBreakpoint {
    private PHPLineBreakpoint bp;
    private IFile workspaceFile;

    public PdtBreakpoint(PHPLineBreakpoint breakpoint) {
        IResource resource;
        this.bp = breakpoint;
        IMarker marker = this.bp.getMarker();
        int lineNumber = 0;
        if (breakpoint instanceof PHPRunToLineBreakpoint) {
            resource = ((PHPRunToLineBreakpoint)breakpoint).getSourceFile();
            lineNumber = this.bp.getRuntimeBreakpoint().getLineNumber();
        } else {
            resource = marker.getResource();
            lineNumber = marker.getAttribute("lineNumber", 0);
        }
        String fileName = "";
        if (resource instanceof IWorkspaceRoot) {
            try {
                fileName = (String)marker.getAttribute("org.eclipse.php.debug.core.Include");
                fileName = marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path", fileName);
                IFile res = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fileName));
                if (res instanceof IFile) {
                    this.workspaceFile = res;
                }
            }
            catch (CoreException coreException) {}
        } else {
            fileName = resource.getRawLocation().toOSString();
            if (resource instanceof IFile) {
                this.workspaceFile = (IFile)resource;
            }
        }
        this.bp.getRuntimeBreakpoint().setFileName(fileName);
        this.bp.getRuntimeBreakpoint().setLineNumber(lineNumber);
    }

    public IBreakpoint getBreakpoint() {
        return this.bp;
    }

    public void setBreakpoint(IBreakpoint breakpoint) {
        this.bp = (PHPLineBreakpoint)breakpoint;
    }

    public int getID() {
        return this.bp.getRuntimeBreakpoint().getID();
    }

    public void setID(int id) {
        this.bp.getRuntimeBreakpoint().setID(id);
    }

    public boolean hasConditionChanged() {
        return this.bp.isConditionChanged();
    }

    public void resetConditionChanged() {
        this.bp.setConditionChanged(false);
    }

    public IFile getIFile() {
        return this.workspaceFile;
    }

    public String getFileName() {
        return this.bp.getRuntimeBreakpoint().getFileName();
    }

    public int getLineNumber() {
        return this.bp.getRuntimeBreakpoint().getLineNumber();
    }

    public String getExpression() {
        return this.bp.getRuntimeBreakpoint().getExpression();
    }

    public boolean isConditional() {
        return this.bp instanceof PHPConditionalBreakpoint;
    }

    public boolean isConditionEnabled() {
        if (this.isConditional()) {
            return ((PHPConditionalBreakpoint)this.bp).isConditionEnabled();
        }
        return false;
    }
}

