/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.natives;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.FileUtils;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Messages;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.osgi.util.NLS;

public class BackupFiles {
    private static final String ZIP_SUFFIX = ".zip";
    private static final String PROPERTIES_SUFFIX = ".properties";
    private final File backupDir;
    private boolean doBackup = true;

    public BackupFiles(File backupDir) {
        this.backupDir = backupDir;
        this.backupDir.mkdirs();
    }

    public void restore(IProgressMonitor monitor) throws IOException {
        File propsFile;
        LinkedList<File> propsFiles = new LinkedList<File>();
        int i = 0;
        while ((propsFile = this.getBackupProperties(i)).exists()) {
            propsFiles.add(0, propsFile);
            ++i;
        }
        IProgressMonitor[] pm = Util.splitProgressMonitor(monitor, propsFiles.size());
        int j = 0;
        Iterator i2 = propsFiles.iterator();
        while (i2.hasNext()) {
            File propsFile2 = (File)i2.next();
            this.restoreFilesFromBackup(propsFile2, pm[j++]);
        }
        if (this.backupDir.delete()) {
            this.backupDir.getParentFile().delete();
        }
        monitor.done();
    }

    public void backupFilesInZip(String identifier, URL zipURL, File outputDir, IProgressMonitor monitor) throws IOException {
        BackupProperties backupProps = new BackupProperties(identifier, outputDir);
        ZipOutputStream zos = null;
        String prevDir = null;
        try {
            ZipEntry ze;
            ZipInputStream in = new ZipInputStream(zipURL.openStream());
            while ((ze = in.getNextEntry()) != null) {
                String name = ze.getName();
                int i = name.lastIndexOf(47);
                if (i != -1) {
                    String dir = name.substring(0, i);
                    if (this.doBackup && !dir.equals(prevDir)) {
                        monitor.subTask(name.substring(0, i));
                        prevDir = dir;
                    }
                }
                if (!ze.isDirectory()) {
                    File origFile = new File(outputDir, name);
                    if (this.doBackup && origFile.exists()) {
                        if (zos == null) {
                            File zipFile = backupProps.getArchive();
                            zos = new ZipOutputStream(new FileOutputStream(zipFile));
                        }
                        ZipEntry zipEntry = new ZipEntry(name);
                        zipEntry.setTime(origFile.lastModified());
                        zos.putNextEntry(zipEntry);
                        FileUtils.copyStream((InputStream)new FileInputStream(origFile), (boolean)true, (OutputStream)zos, (boolean)false);
                        zos.closeEntry();
                    } else {
                        backupProps.addFileToDelete(name);
                    }
                    origFile.delete();
                }
                in.closeEntry();
            }
            in.close();
        }
        finally {
            backupProps.store();
            if (zos != null) {
                zos.close();
            }
        }
    }

    private void restoreFilesFromBackup(File propsFile, IProgressMonitor monitor) throws IOException {
        BackupProperties backupProps = new BackupProperties(propsFile);
        monitor.beginTask(NLS.bind((String)Messages.restoring, (Object)propsFile.toString()), 3);
        monitor.subTask("");
        Iterator i = backupProps.getFilesToDelete().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            File full = new File(backupProps.getRootDir(), name);
            full.delete();
        }
        monitor.worked(1);
        File zipFile = backupProps.getArchive();
        if (zipFile.exists()) {
            SubProgressMonitor sub = new SubProgressMonitor(monitor, 1, 4);
            FileUtils.unzipFile((File)zipFile, (File)backupProps.getRootDir(), (String)"", (IProgressMonitor)sub);
            zipFile.delete();
        } else {
            monitor.worked(1);
        }
        Iterator i2 = backupProps.getDirsToDelete().iterator();
        while (i2.hasNext()) {
            String name = (String)i2.next();
            File full = new File(backupProps.getRootDir(), name);
            FileUtils.deleteEmptyDirs((File)full);
        }
        propsFile.delete();
        monitor.worked(1);
        monitor.done();
    }

    File getBackupProperties() {
        int i = 0;
        File result;
        while ((result = this.getBackupProperties(i)).exists()) {
            ++i;
        }
        return result;
    }

    private File getBackupProperties(int i) {
        return new File(this.backupDir, String.valueOf(Integer.toString(i)) + PROPERTIES_SUFFIX);
    }

    private class BackupProperties
    extends Properties {
        private static final long serialVersionUID = 2268313492348533029L;
        private static final char FILE_KIND = 'f';
        private static final char DIR_KIND = 'd';
        private static final String ROOT_DIR = "rootDir";
        private static final String ARTIFACT_KEY = "artifactKey";
        private int n = 0;
        private File file;
        private List keys = new LinkedList();
        private final File rootDir;
        private Set dirsToCreate = new TreeSet();

        public BackupProperties(String identifier, File rootDir) {
            this.file = BackupFiles.this.getBackupProperties();
            this.rootDir = rootDir;
            this.setProperty(ROOT_DIR, rootDir.getPath().replace('\\', '/'));
            this.setProperty(ARTIFACT_KEY, identifier != null ? identifier : rootDir.getAbsolutePath());
            this.addDir("./");
        }

        public BackupProperties(File file) throws IOException {
            this.file = file;
            FileInputStream stream = new FileInputStream(file);
            try {
                this.load(stream);
            }
            finally {
                stream.close();
            }
            this.rootDir = new File(this.getProperty(ROOT_DIR));
        }

        public File getRootDir() {
            return this.rootDir;
        }

        public File getArchive() {
            String path = this.file.getPath();
            if (path.endsWith(BackupFiles.PROPERTIES_SUFFIX)) {
                path = path.substring(0, path.length() - BackupFiles.PROPERTIES_SUFFIX.length());
            }
            return new File(String.valueOf(path) + BackupFiles.ZIP_SUFFIX);
        }

        public List getFilesToDelete() {
            return this.getMatchingProperties('f');
        }

        public List getDirsToDelete() {
            return this.getMatchingProperties('d');
        }

        private List getMatchingProperties(char c) {
            LinkedList<String> result = new LinkedList<String>();
            Enumeration<?> e = this.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (key.equals(ROOT_DIR) || key.charAt(0) != c) continue;
                result.add(this.getProperty(key));
            }
            return result;
        }

        public void addFileToDelete(String name) {
            this.add('f', name);
            this.addDir(name);
        }

        public void store() throws IOException {
            Iterator i = this.dirsToCreate.iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                this.add('d', name);
            }
            FileOutputStream stream = new FileOutputStream(this.file);
            try {
                this.store(stream, null);
            }
            finally {
                stream.close();
            }
        }

        public Object put(Object key, Object value) {
            if (!(key instanceof String)) {
                throw new AssertionError((Object)("expected String: " + key));
            }
            if (!(value instanceof String)) {
                throw new AssertionError((Object)("expected String: " + value));
            }
            this.keys.add(key);
            return super.put(key, value);
        }

        public synchronized Enumeration keys() {
            Iterator iterator = this.keys.iterator();
            return new Enumeration(this, iterator){
                final /* synthetic */ BackupProperties this$1;
                private final /* synthetic */ Iterator val$iterator;
                {
                    this.this$1 = backupProperties;
                    this.val$iterator = iterator;
                }

                public boolean hasMoreElements() {
                    return this.val$iterator.hasNext();
                }

                public Object nextElement() {
                    return this.val$iterator.next();
                }
            };
        }

        private void add(char kind, String name) {
            StringBuffer key = new StringBuffer(4);
            key.append(kind).append(this.n++);
            this.setProperty(key.toString(), name.replace('\\', '/'));
        }

        private void addDir(String name) {
            int slash = name.lastIndexOf(47);
            if (slash == -1) {
                return;
            }
            String dirName = name.substring(0, slash);
            if (this.dirsToCreate.contains(dirName)) {
                return;
            }
            if (new File(this.rootDir, dirName).exists()) {
                return;
            }
            this.dirsToCreate.add(dirName);
        }
    }
}

