/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.formatter;

import java.net.URL;
import org.eclipse.dltk.ui.formatter.FormatterMessages;
import org.eclipse.dltk.ui.formatter.FormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.FormatterPreviewUtils;
import org.eclipse.dltk.ui.formatter.IFormatterControlManager;
import org.eclipse.dltk.ui.formatter.IFormatterModifiyTabPage;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.formatter.internal.WhitespaceCharacterPainter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public abstract class FormatterModifyTabPage
implements IFormatterModifiyTabPage {
    protected static final String SHOW_INVISIBLE_PREFERENCE_KEY = "invisible.characters";
    private final IFormatterModifyDialog dialog;
    private ISourceViewer previewViewer;
    private Button fShowInvisibleButton;
    private WhitespaceCharacterPainter whitespaceCharacterPainter = null;

    public FormatterModifyTabPage(IFormatterModifyDialog dialog) {
        this.dialog = dialog;
    }

    public Composite createContents(IFormatterControlManager manager, Composite parent) {
        SashForm page = new SashForm(parent, 256);
        Composite options = SWTFactory.createComposite((Composite)page, page.getFont(), 1, 1, 1808);
        this.createOptions(manager, options);
        Composite previewBlock = SWTFactory.createComposite((Composite)page, page.getFont(), 1, 1, 1808);
        this.fShowInvisibleButton = new Button(previewBlock, 32);
        this.fShowInvisibleButton.setText(FormatterMessages.FormatterModifyTabPage_showInvisible);
        this.fShowInvisibleButton.setLayoutData((Object)new GridData(131072, 128, true, false));
        this.fShowInvisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean newValue = FormatterModifyTabPage.this.fShowInvisibleButton.getSelection();
                FormatterModifyTabPage.this.updateShowInvisible(newValue);
                FormatterModifyTabPage.this.getDialogSettings().put(FormatterModifyTabPage.SHOW_INVISIBLE_PREFERENCE_KEY, newValue);
            }
        });
        this.previewViewer = this.dialog.getOwner().createPreview(previewBlock);
        boolean savedValue = this.getDialogSettings().getBoolean(SHOW_INVISIBLE_PREFERENCE_KEY);
        this.fShowInvisibleButton.setSelection(savedValue);
        this.updateShowInvisible(savedValue);
        return page;
    }

    protected void updateShowInvisible(boolean value) {
        if (value) {
            if (this.whitespaceCharacterPainter == null) {
                this.whitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)this.previewViewer);
                ((ITextViewerExtension2)this.previewViewer).addPainter((IPainter)this.whitespaceCharacterPainter);
            }
        } else if (this.whitespaceCharacterPainter != null) {
            ((ITextViewerExtension2)this.previewViewer).removePainter((IPainter)this.whitespaceCharacterPainter);
            this.whitespaceCharacterPainter = null;
        }
    }

    private IDialogSettings getDialogSettings() {
        return ((FormatterModifyDialog)this.dialog).fDialogSettings;
    }

    public void updatePreview() {
        if (this.previewViewer != null) {
            FormatterPreviewUtils.updatePreview(this.previewViewer, this.getPreviewContent(), this.dialog.getFormatterFactory(), this.dialog.getPreferences());
        }
    }

    protected abstract void createOptions(IFormatterControlManager var1, Composite var2);

    protected URL getPreviewContent() {
        return null;
    }
}

