/*
 * Decompiled with CFR 0.152.
 */
package JFlex.gui;

import JFlex.Out;
import JFlex.gui.GeneratorThread;
import JFlex.gui.GridPanel;
import JFlex.gui.Handles;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

public final class MainFrame
extends Frame
implements Handles {
    private boolean choosing;
    private String fileName = "";
    private String dirName = "";
    private Button quit;
    private Button generate;
    private Button stop;
    private Button specChoose;
    private Button dirChoose;
    private TextField spec;
    private TextField dir;
    private TextArea messages;
    private GeneratorThread thread;

    public MainFrame() {
        super("JFlex 1.2.2");
        this.buildContent();
        this.addWindowListener(new 1());
        this.pack();
        this.show();
    }

    private void buildContent() {
        ((Component)this).setBackground(SystemColor.control);
        this.generate = new Button("Generate");
        this.quit = new Button("Quit");
        this.stop = new Button("Stop");
        this.dirChoose = new Button("Choose");
        this.dir = new TextField(10);
        this.specChoose = new Button("Choose");
        this.spec = new TextField(10);
        this.messages = new TextArea(10, 80);
        this.messages.setEditable(false);
        Font font = this.messages.getFont();
        if (font != null) {
            this.messages.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        } else {
            this.messages.setFont(new Font("Monospaced", 0, 12));
        }
        this.generate.addActionListener(new 2());
        this.quit.addActionListener(new 3());
        this.stop.addActionListener(new 4());
        this.specChoose.addActionListener(new 5());
        this.dirChoose.addActionListener(new 6());
        this.spec.addActionListener(new 7());
        this.spec.addTextListener(new 8());
        this.dir.addActionListener(new 9());
        this.dir.addTextListener(new 10());
        GridPanel gridPanel = new GridPanel(5, 4, 10, 10);
        gridPanel.setInsets(new Insets(10, 5, 5, 10));
        gridPanel.add(4, 0, this.quit);
        gridPanel.add(4, 1, this.generate);
        gridPanel.add(4, 2, this.stop);
        gridPanel.add(0, 0, 7, new Label("Lexical specification:"));
        gridPanel.add(0, 1, 2, 1, this.spec);
        gridPanel.add(2, 1, this.specChoose);
        gridPanel.add(0, 2, 7, new Label("Output directory:"));
        gridPanel.add(0, 3, 2, 1, this.dir);
        gridPanel.add(2, 3, this.dirChoose);
        Panel panel = new Panel(new BorderLayout());
        panel.add("North", new Label("Messages:"));
        panel.add("Center", this.messages);
        this.add("North", gridPanel);
        this.add("Center", panel);
        this.setEnabledAll(false);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.width = this.messages.getPreferredSize().width;
        return dimension;
    }

    private void setEnabledAll(boolean bl) {
        this.stop.setEnabled(bl);
        this.quit.setEnabled(!bl);
        this.generate.setEnabled(!bl);
        this.dirChoose.setEnabled(!bl);
        this.dir.setEnabled(!bl);
        this.specChoose.setEnabled(!bl);
        this.spec.setEnabled(!bl);
    }

    private void generate() {
        if (this.choosing) {
            return;
        }
        this.setEnabledAll(true);
        this.thread = new GeneratorThread(this, this.fileName, this.messages, this.dirName);
        this.thread.start();
    }

    public void generationFinished(boolean bl) {
        this.setEnabledAll(false);
        if (bl) {
            this.messages.append(String.valueOf(Out.NL) + "Generation finished successfully." + Out.NL);
            return;
        }
        this.messages.append(String.valueOf(Out.NL) + "Generation aborted." + Out.NL);
    }

    private void stop() {
        if (this.thread != null) {
            this.thread.stop();
            this.thread = null;
            this.generationFinished(false);
        }
    }

    private void quit() {
        ((Component)this).setVisible(false);
        System.exit(0);
    }

    private void dirChoose() {
        this.choosing = true;
        FileDialog fileDialog = new FileDialog((Frame)this, "Choose directory", 0);
        fileDialog.show();
        if (fileDialog.getDirectory() != null) {
            ((TextComponent)this.dir).setText(new File(fileDialog.getDirectory()).getAbsolutePath());
        }
        this.choosing = false;
    }

    private void specChoose() {
        this.choosing = true;
        FileDialog fileDialog = new FileDialog((Frame)this, "Choose file", 0);
        fileDialog.setFile("*.flex");
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            this.fileName = String.valueOf(fileDialog.getDirectory()) + fileDialog.getFile();
            ((TextComponent)this.dir).setText(fileDialog.getDirectory());
            ((TextComponent)this.spec).setText(this.fileName);
        }
        this.choosing = false;
    }

    static /* synthetic */ String access$6(MainFrame mainFrame) {
        return mainFrame.fileName;
    }

    static /* synthetic */ String access$9(MainFrame mainFrame) {
        return mainFrame.dirName;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            MainFrame.this.quit();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 10
    implements TextListener {
        public void textValueChanged(TextEvent textEvent) {
            MainFrame.this.dirName = MainFrame.this.dir.getText();
        }

        /* synthetic */ 10() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.generate();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.quit();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.stop();
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.specChoose();
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.dirChoose();
        }

        /* synthetic */ 6() {
        }
    }

    private final class 7
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.fileName = MainFrame.this.spec.getText();
            MainFrame.this.generate();
        }

        /* synthetic */ 7() {
        }
    }

    private final class 8
    implements TextListener {
        public void textValueChanged(TextEvent textEvent) {
            MainFrame.this.fileName = MainFrame.this.spec.getText();
        }

        /* synthetic */ 8() {
        }
    }

    private final class 9
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.dirName = MainFrame.this.dir.getText();
            MainFrame.this.generate();
        }

        /* synthetic */ 9() {
        }
    }
}

