/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.garbagecollector;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.garbagecollector.CoreGarbageCollector;
import org.eclipse.equinox.internal.p2.garbagecollector.GCActivator;
import org.eclipse.equinox.internal.p2.garbagecollector.IMarkSetProvider;
import org.eclipse.equinox.internal.p2.garbagecollector.MarkSet;
import org.eclipse.equinox.internal.p2.garbagecollector.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfile;
import org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.osgi.framework.BundleContext;

public class GarbageCollector {
    private static final String ATTRIBUTE_CLASS = "class";
    private static final String PT_MARKSET = "org.eclipse.equinox.p2.garbagecollector.marksetproviders";
    private Map markSet;
    static /* synthetic */ Class class$0;

    public void runGC(IProfile profile) {
        this.markSet = new HashMap();
        if (!this.traverseMainProfile(profile)) {
            return;
        }
        this.traverseRegisteredProfiles();
        this.invokeCoreGC();
    }

    private boolean traverseMainProfile(IProfile profile) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] configElts = registry.getConfigurationElementsFor(PT_MARKSET);
        int i = 0;
        while (i < configElts.length) {
            IConfigurationElement runAttribute;
            if (configElts[i].getName().equals("run") && (runAttribute = configElts[i]) != null) {
                this.contributeMarkSets(runAttribute, profile, true);
            }
            ++i;
        }
        return true;
    }

    private void invokeCoreGC() {
        Iterator keyIterator = this.markSet.keySet().iterator();
        while (keyIterator.hasNext()) {
            IArtifactRepository nextRepo = (IArtifactRepository)keyIterator.next();
            IArtifactKey[] keys = ((Collection)this.markSet.get(nextRepo)).toArray(new IArtifactKey[0]);
            MarkSet aMarkSet = new MarkSet(keys, nextRepo);
            new CoreGarbageCollector().clean(aMarkSet.getKeys(), aMarkSet.getRepo());
        }
    }

    private void traverseRegisteredProfiles() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IConfigurationElement[] configElts = registry.getConfigurationElementsFor(PT_MARKSET);
        int i = 0;
        while (i < configElts.length) {
            IConfigurationElement runAttribute;
            if (configElts[i].getName().equals("run") && (runAttribute = configElts[i]) != null) {
                IProfileRegistry profileRegistry;
                BundleContext bundleContext = GCActivator.getContext();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.equinox.internal.provisional.p2.engine.IProfileRegistry");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((profileRegistry = (IProfileRegistry)GCActivator.getService(bundleContext, clazz.getName())) == null) {
                    return;
                }
                IProfile[] registeredProfiles = profileRegistry.getProfiles();
                int j = 0;
                while (j < registeredProfiles.length) {
                    this.contributeMarkSets(runAttribute, registeredProfiles[j], false);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void contributeMarkSets(IConfigurationElement runAttribute, IProfile profile, boolean addRepositories) {
        ParameterizedSafeRunnable providerExecutor = new ParameterizedSafeRunnable(runAttribute, profile);
        SafeRunner.run((ISafeRunnable)providerExecutor);
        MarkSet[] aProfileMarkSets = providerExecutor.getResult();
        if (aProfileMarkSets == null || aProfileMarkSets.length == 0 || aProfileMarkSets[0] == null) {
            return;
        }
        int i = 0;
        while (i < aProfileMarkSets.length) {
            if (aProfileMarkSets[i] != null) {
                int j = 0;
                while (j < aProfileMarkSets.length) {
                    if (aProfileMarkSets[j] != null) {
                        HashSet keys = (HashSet)this.markSet.get(aProfileMarkSets[j].getRepo());
                        if (keys == null) {
                            if (addRepositories) {
                                keys = new HashSet();
                                this.markSet.put(aProfileMarkSets[j].getRepo(), keys);
                                this.addKeys(keys, aProfileMarkSets[j].getKeys());
                            }
                        } else {
                            this.addKeys(keys, aProfileMarkSets[j].getKeys());
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private void addKeys(Collection keyList, IArtifactKey[] keyArray) {
        int i = 0;
        while (i < keyArray.length) {
            keyList.add(keyArray[i]);
            ++i;
        }
    }

    private class ParameterizedSafeRunnable
    implements ISafeRunnable {
        IConfigurationElement cfg;
        IProfile aProfile;
        MarkSet[] aProfileMarkSets;

        public ParameterizedSafeRunnable(IConfigurationElement runtAttribute, IProfile profile) {
            this.cfg = runtAttribute;
            this.aProfile = profile;
        }

        public void handleException(Throwable exception) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.garbagecollector", Messages.Error_in_extension, exception));
        }

        public void run() throws Exception {
            IMarkSetProvider aMarkSetProvider = (IMarkSetProvider)this.cfg.createExecutableExtension(GarbageCollector.ATTRIBUTE_CLASS);
            if (aMarkSetProvider == null) {
                this.aProfileMarkSets = null;
                return;
            }
            this.aProfileMarkSets = aMarkSetProvider.getMarkSets(this.aProfile);
        }

        public MarkSet[] getResult() {
            return this.aProfileMarkSets;
        }
    }
}

